/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.component.browse;

import com.hpplay.component.browse.LelinkBrowseCore;
import com.hpplay.component.browse.LelinkBrowseTask;
import com.hpplay.component.browse.LelinkBrowseThread;
import com.hpplay.component.common.browse.IBrowseResultListener;
import com.hpplay.component.common.utils.CLog;
import org.json.JSONObject;

public class LelinkBrowse
extends LelinkBrowseCore
implements Runnable {
    private static final String TAG = "LelinkBrowse";
    private static final String LELINK_HEADER = "LBTP";
    private boolean isStart;
    private LelinkBrowseTask mBrowseRunnable;
    private LelinkBrowseThread mLelinkBrowseThread;
    private IBrowseResultListener mBrowseListener;
    private LelinkBrowseThread mThread;

    public void startBrowse(IBrowseResultListener iBrowseResultListener) {
        if (this.mLelinkBrowseThread != null) {
            this.mLelinkBrowseThread.interrupt();
        }
        this.mBrowseListener = iBrowseResultListener;
        this.mThread = new LelinkBrowseThread(this, "LelinkBrowseSender");
        this.mThread.start();
    }

    public void release() {
        this.isStart = false;
        CLog.i("LelinkBrowseTask", " LelinkBrowse release  ");
        if (this.mBrowseServSocket != null) {
            this.mBrowseServSocket.close();
        }
        if (this.mThread != null) {
            this.mThread.interrupt();
        }
    }

    private void stopBrowseTask() {
        this.isStart = false;
        if (this.mLelinkBrowseThread != null) {
            this.mLelinkBrowseThread.interrupt();
        }
        if (this.mBrowseRunnable != null) {
            this.mBrowseRunnable.releae();
        }
    }

    @Override
    public void run() {
        this.isStart = this.createUDPServer();
        if (this.isStart) {
            this.mBrowseRunnable = new LelinkBrowseTask();
            this.mLelinkBrowseThread = new LelinkBrowseThread(this.mBrowseRunnable, "LelinkBrowseReceiver");
            this.mLelinkBrowseThread.start();
        }
        while (this.isStart) {
            try {
                this.mBrowseServSocket.receive(this.mReceiverPacket);
                if (this.mReceiverPacket == null) continue;
                byte[] byArray = new byte[this.mReceiverPacket.getLength()];
                byte[] byArray2 = this.mReceiverPacket.getData();
                System.arraycopy(byArray2, 0, byArray, 0, byArray.length);
                String string = new String(byArray);
                try {
                    if (!string.contains(LELINK_HEADER)) continue;
                    String[] stringArray = string.split("\r\n");
                    JSONObject jSONObject = new JSONObject(stringArray[2]);
                    if (this.mBrowseListener == null) continue;
                    this.mBrowseListener.onBrowseResultCallback(2, jSONObject);
                }
                catch (Exception exception) {
                    CLog.w(TAG, "lelink scan paser error ..");
                }
            }
            catch (Exception exception) {
                CLog.w(TAG, "lelink scan stop ..");
                break;
            }
        }
        this.stopBrowseTask();
    }
}

