/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.component.protocol.server;

import com.hpplay.component.protocol.server.IRequestHandler;
import com.hpplay.component.protocol.server.IRequstManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class RequestManagerImp
implements IRequstManager {
    protected long requestCount;
    private final List<IRequestHandler> running = Collections.synchronizedList(new ArrayList());

    public List<IRequestHandler> getRunning() {
        return this.running;
    }

    @Override
    public void closeAll() {
        for (IRequestHandler iRequestHandler : new ArrayList<IRequestHandler>(this.running)) {
            iRequestHandler.close();
        }
    }

    @Override
    public void closed(IRequestHandler iRequestHandler) {
        this.running.remove(iRequestHandler);
    }

    @Override
    public void exec(IRequestHandler iRequestHandler) {
        ++this.requestCount;
        this.running.add(iRequestHandler);
        this.createThread(iRequestHandler).start();
    }

    protected Thread createThread(IRequestHandler iRequestHandler) {
        Thread thread = new Thread((Runnable)((Object)iRequestHandler));
        thread.setDaemon(true);
        thread.setName("Request thread  " + this.requestCount);
        return thread;
    }
}

