/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.glide.load.engine.executor;

import android.os.Process;
import android.util.Log;
import com.hpplay.glide.load.engine.executor.Prioritized;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class FifoPriorityThreadPoolExecutor
extends ThreadPoolExecutor {
    private static final String TAG = "PriorityExecutor";
    private final AtomicInteger ordering = new AtomicInteger();
    private final UncaughtThrowableStrategy uncaughtThrowableStrategy;

    public FifoPriorityThreadPoolExecutor(int n2) {
        this(n2, UncaughtThrowableStrategy.LOG);
    }

    public FifoPriorityThreadPoolExecutor(int n2, UncaughtThrowableStrategy uncaughtThrowableStrategy) {
        this(n2, n2, 0L, TimeUnit.MILLISECONDS, new DefaultThreadFactory(), uncaughtThrowableStrategy);
    }

    public FifoPriorityThreadPoolExecutor(int n2, int n3, long l2, TimeUnit timeUnit, ThreadFactory threadFactory, UncaughtThrowableStrategy uncaughtThrowableStrategy) {
        super(n2, n3, l2, timeUnit, new PriorityBlockingQueue<Runnable>(), threadFactory);
        this.uncaughtThrowableStrategy = uncaughtThrowableStrategy;
    }

    @Override
    protected <T> RunnableFuture<T> newTaskFor(Runnable runnable, T t2) {
        return new LoadTask<T>(runnable, t2, this.ordering.getAndIncrement());
    }

    @Override
    protected void afterExecute(Runnable runnable, Throwable throwable) {
        Future future;
        super.afterExecute(runnable, throwable);
        if (throwable == null && runnable instanceof Future && (future = (Future)((Object)runnable)).isDone() && !future.isCancelled()) {
            try {
                future.get();
            }
            catch (InterruptedException interruptedException) {
                this.uncaughtThrowableStrategy.handle(interruptedException);
            }
            catch (ExecutionException executionException) {
                this.uncaughtThrowableStrategy.handle(executionException);
            }
        }
    }

    static class LoadTask<T>
    extends FutureTask<T>
    implements Comparable<LoadTask<?>> {
        private final int priority;
        private final int order;

        public LoadTask(Runnable runnable, T t2, int n2) {
            super(runnable, t2);
            if (!(runnable instanceof Prioritized)) {
                throw new IllegalArgumentException("FifoPriorityThreadPoolExecutor must be given Runnables that implement Prioritized");
            }
            this.priority = ((Prioritized)((Object)runnable)).getPriority();
            this.order = n2;
        }

        public boolean equals(Object object) {
            if (object instanceof LoadTask) {
                LoadTask loadTask = (LoadTask)object;
                return this.order == loadTask.order && this.priority == loadTask.priority;
            }
            return false;
        }

        public int hashCode() {
            int n2 = this.priority;
            n2 = 31 * n2 + this.order;
            return n2;
        }

        @Override
        public int compareTo(LoadTask<?> loadTask) {
            int n2 = this.priority - loadTask.priority;
            if (n2 == 0) {
                n2 = this.order - loadTask.order;
            }
            return n2;
        }
    }

    public static class DefaultThreadFactory
    implements ThreadFactory {
        int threadNum = 0;

        @Override
        public Thread newThread(Runnable runnable) {
            Thread thread = new Thread(runnable, "fifo-pool-thread-" + this.threadNum){

                @Override
                public void run() {
                    Process.setThreadPriority((int)10);
                    super.run();
                }
            };
            ++this.threadNum;
            return thread;
        }
    }

    public static enum UncaughtThrowableStrategy {
        IGNORE,
        LOG{

            @Override
            protected void handle(Throwable throwable) {
                if (Log.isLoggable((String)FifoPriorityThreadPoolExecutor.TAG, (int)6)) {
                    Log.e((String)FifoPriorityThreadPoolExecutor.TAG, (String)"Request threw uncaught throwable", (Throwable)throwable);
                }
            }
        }
        ,
        THROW{

            @Override
            protected void handle(Throwable throwable) {
                super.handle(throwable);
                throw new RuntimeException(throwable);
            }
        };


        protected void handle(Throwable throwable) {
        }
    }
}

