/*
 * Decompiled with CFR 0.152.
 */
package com.wizapply.libspap;

import android.util.Log;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;

public class TCPInputOutputManager
implements Runnable {
    private static final String TAG = TCPInputOutputManager.class.getSimpleName();
    private static final boolean DEBUG = false;
    private static final int READ_WAIT_MILLIS = 10;
    private static final int BUFSIZ = 0x200000;
    public SocketChannel mSocket = null;
    public ServerSocketChannel mSocketServer = null;
    public InetSocketAddress mISA;
    private final ByteBuffer mReadBuffer = ByteBuffer.allocate(0x200000);
    private final ByteBuffer mWriteBuffer = ByteBuffer.allocate(0x200000);
    public boolean tcp_connect = false;
    public State mState = State.STOPPED;

    public TCPInputOutputManager(String ipv4, int port) {
        try {
            this.mSocketServer = null;
            this.mSocket = SocketChannel.open();
            this.mISA = new InetSocketAddress(ipv4, port);
            this.mSocket.configureBlocking(true);
            this.tcp_connect = false;
        }
        catch (IOException e) {
            Log.i((String)TAG, (String)"TCP Client create Error!");
        }
    }

    public TCPInputOutputManager(int port) {
        try {
            this.mSocketServer = ServerSocketChannel.open();
            this.mISA = new InetSocketAddress(port);
            this.mSocketServer.socket().bind(this.mISA);
            this.mSocketServer.configureBlocking(false);
            this.mSocket = null;
            this.tcp_connect = false;
        }
        catch (IOException e) {
            Log.i((String)TAG, (String)"TCP Server create Error!");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeAsync(byte[] data) {
        ByteBuffer byteBuffer = this.mWriteBuffer;
        synchronized (byteBuffer) {
            this.mWriteBuffer.put(data);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeAsync(byte[] data, int data_size) {
        ByteBuffer byteBuffer = this.mWriteBuffer;
        synchronized (byteBuffer) {
            this.mWriteBuffer.put(data, 0, data_size);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int readData(byte[] data, int data_size, boolean discard_null) {
        int get_size = 0;
        ByteBuffer byteBuffer = this.mReadBuffer;
        synchronized (byteBuffer) {
            int i = 0;
            this.mReadBuffer.flip();
            try {
                for (i = 0; i < data_size && this.mReadBuffer.hasRemaining(); ++i) {
                    byte d = this.mReadBuffer.get();
                    if (discard_null && d == 0) continue;
                    data[get_size] = d;
                    ++get_size;
                }
            }
            catch (BufferUnderflowException bufferUnderflowException) {
                // empty catch block
            }
            this.mReadBuffer.compact();
        }
        return get_size;
    }

    public int readDataAvailable() {
        return this.mReadBuffer.position();
    }

    public void stop() {
        if (this.getState() == State.RUNNING) {
            Log.i((String)TAG, (String)"Stop requested");
            this.mState = State.STOPPING;
        }
    }

    private State getState() {
        return this.mState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void run() {
        TCPInputOutputManager tCPInputOutputManager = this;
        // MONITORENTER : tCPInputOutputManager
        this.tcp_connect = false;
        if (this.getState() != State.STOPPED) {
            throw new IllegalStateException("Already running.");
        }
        this.mState = State.RUNNING;
        try {
            if (this.mSocketServer == null) {
                this.mSocket.connect(this.mISA);
                this.mSocket.configureBlocking(false);
            } else {
                do {
                    if (this.getState() != State.RUNNING) {
                        throw new IOException();
                    }
                    this.mSocket = this.mSocketServer.accept();
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                } while (this.mSocket == null);
                this.mSocket.configureBlocking(false);
            }
        }
        catch (IOException e) {
            if (this.mSocketServer != null) {
                try {
                    this.mSocketServer.close();
                    this.mSocketServer = null;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (this.mSocket != null) {
                try {
                    this.mSocket.close();
                    this.mSocket = null;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            this.mState = State.STOPPED;
            // MONITOREXIT : tCPInputOutputManager
            return;
        }
        // MONITOREXIT : tCPInputOutputManager
        this.mWriteBuffer.clear();
        this.tcp_connect = true;
        try {
            while (true) {
                if (this.getState() != State.RUNNING) {
                    Log.i((String)TAG, (String)("Stopping mState=" + (Object)((Object)this.getState())));
                }
                this.step();
            }
        }
        catch (Exception e) {
            Log.w((String)TAG, (String)("Run ending due to exception: " + e.getMessage()), (Throwable)e);
        }
        finally {
            tCPInputOutputManager = this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void step() throws IOException {
        int len = 0;
        ByteBuffer readbuffers = ByteBuffer.allocate(4096);
        len = this.mSocket.read(readbuffers);
        if (len > 0) {
            ByteBuffer byteBuffer = this.mReadBuffer;
            synchronized (byteBuffer) {
                this.mReadBuffer.put(readbuffers.array(), 0, len);
            }
        }
        if (len == -1) {
            throw new IOException("socket close");
        }
        byte[] outBuff = null;
        ByteBuffer byteBuffer = this.mWriteBuffer;
        synchronized (byteBuffer) {
            len = this.mWriteBuffer.position();
            if (len > 0) {
                outBuff = new byte[len];
                this.mWriteBuffer.rewind();
                this.mWriteBuffer.get(outBuff, 0, len);
                ByteBuffer outByteBuffer = ByteBuffer.wrap(outBuff);
                this.mSocket.write(outByteBuffer);
                this.mWriteBuffer.clear();
            }
        }
    }

    public static enum State {
        STOPPED,
        RUNNING,
        STOPPING;

    }
}

