/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.cybergarage.http;

import com.hpplay.component.common.utils.CLog;
import com.hpplay.cybergarage.http.HTTP;
import com.hpplay.cybergarage.http.HTTPPacket;
import com.hpplay.cybergarage.http.HTTPResponse;
import com.hpplay.cybergarage.http.HTTPSocket;
import com.hpplay.cybergarage.http.Parameter;
import com.hpplay.cybergarage.http.ParameterList;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.StringTokenizer;

public class HTTPRequest
extends HTTPPacket {
    private static final String TAG = "HTTPRequest";
    private String method = null;
    private String uri = null;
    private String requestHost = "";
    private int requestPort = -1;
    private HTTPSocket httpSocket = null;
    private Socket postSocket = null;
    public static final int DEFAULT_TIMEOUT = 10000;
    private static final String NO_HOST = "No route to host";

    public HTTPRequest() {
        this.setVersion("1.1");
    }

    public HTTPRequest(InputStream inputStream) {
        super(inputStream);
    }

    public HTTPRequest(HTTPSocket hTTPSocket) {
        this(hTTPSocket.getInputStream());
        this.setSocket(hTTPSocket);
    }

    public void setMethod(String string) {
        this.method = string;
    }

    public String getMethod() {
        if (this.method != null) {
            return this.method;
        }
        return this.getFirstLineToken(0);
    }

    public boolean isMethod(String string) {
        String string2 = this.getMethod();
        if (string2 == null) {
            return false;
        }
        return string2.equalsIgnoreCase(string);
    }

    public boolean isGetRequest() {
        return this.isMethod("GET");
    }

    public boolean isPostRequest() {
        return this.isMethod("POST");
    }

    public boolean isHeadRequest() {
        return this.isMethod("HEAD");
    }

    public boolean isSubscribeRequest() {
        return this.isMethod("SUBSCRIBE");
    }

    public boolean isUnsubscribeRequest() {
        return this.isMethod("UNSUBSCRIBE");
    }

    public boolean isNotifyRequest() {
        return this.isMethod("NOTIFY");
    }

    public void setURI(String string, boolean bl) {
        this.uri = string;
        if (!bl) {
            return;
        }
        this.uri = HTTP.toRelativeURL(this.uri);
    }

    public void setURI(String string) {
        this.setURI(string, false);
    }

    public String getURI() {
        if (this.uri != null) {
            return this.uri;
        }
        return this.getFirstLineToken(1);
    }

    public ParameterList getParameterList() {
        ParameterList parameterList = new ParameterList();
        String string = this.getURI();
        if (string == null) {
            return parameterList;
        }
        int n2 = string.indexOf(63);
        if (n2 < 0) {
            return parameterList;
        }
        while (0 < n2) {
            int n3 = string.indexOf(61, n2 + 1);
            String string2 = string.substring(n2 + 1, n3);
            int n4 = string.indexOf(38, n3 + 1);
            String string3 = string.substring(n3 + 1, 0 < n4 ? n4 : string.length());
            Parameter parameter = new Parameter(string2, string3);
            parameterList.add(parameter);
            n2 = n4;
        }
        return parameterList;
    }

    public String getParameterValue(String string) {
        ParameterList parameterList = this.getParameterList();
        return parameterList.getValue(string);
    }

    public boolean isSOAPAction() {
        return this.hasHeader("SOAPACTION");
    }

    public void setRequestHost(String string) {
        this.requestHost = string;
    }

    public String getRequestHost() {
        return this.requestHost;
    }

    public void setRequestPort(int n2) {
        this.requestPort = n2;
    }

    public int getRequestPort() {
        return this.requestPort;
    }

    public void setSocket(HTTPSocket hTTPSocket) {
        this.httpSocket = hTTPSocket;
    }

    public HTTPSocket getSocket() {
        return this.httpSocket;
    }

    public String getLocalAddress() {
        return this.getSocket().getLocalAddress();
    }

    public int getLocalPort() {
        return this.getSocket().getLocalPort();
    }

    public boolean parseRequestLine(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
        if (!stringTokenizer.hasMoreTokens()) {
            return false;
        }
        this.setMethod(stringTokenizer.nextToken());
        if (!stringTokenizer.hasMoreTokens()) {
            return false;
        }
        this.setURI(stringTokenizer.nextToken());
        if (!stringTokenizer.hasMoreTokens()) {
            return false;
        }
        this.setVersion(stringTokenizer.nextToken());
        return true;
    }

    public String getHTTPVersion() {
        if (this.hasFirstLine()) {
            return this.getFirstLineToken(2);
        }
        return "HTTP/" + super.getVersion();
    }

    public String getFirstLineString() {
        return this.getMethod() + " " + this.getURI() + " " + this.getHTTPVersion() + "\r\n";
    }

    public String getHeader() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getFirstLineString());
        String string = this.getHeaderString();
        stringBuffer.append(string);
        return stringBuffer.toString();
    }

    public boolean isKeepAlive() {
        boolean bl;
        if (this.isCloseConnection()) {
            return false;
        }
        if (this.isKeepAliveConnection()) {
            return true;
        }
        String string = this.getHTTPVersion();
        boolean bl2 = bl = 0 < string.indexOf("1.0");
        return !bl;
    }

    public boolean read() {
        return super.read(this.getSocket());
    }

    public boolean post(HTTPResponse hTTPResponse) {
        HTTPSocket hTTPSocket = this.getSocket();
        long l2 = 0L;
        long l3 = hTTPResponse.getContentLength();
        if (this.hasContentRange()) {
            long l4 = this.getContentRangeFirstPosition();
            long l5 = this.getContentRangeLastPosition();
            if (l5 <= 0L) {
                l5 = l3 - 1L;
            }
            if (l4 > l3 || l5 > l3) {
                return this.returnResponse(416);
            }
            hTTPResponse.setContentRange(l4, l5, l3);
            hTTPResponse.setStatusCode(206);
            l2 = l4;
            l3 = l5 - l4 + 1L;
        }
        return hTTPSocket.post(hTTPResponse, l2, l3, this.isHeadRequest());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HTTPResponse post(String string, int n2, boolean bl) {
        HTTPResponse hTTPResponse = new HTTPResponse();
        this.setHost(string);
        this.setConnection(bl ? "Keep-Alive" : "close");
        boolean bl2 = this.isHeadRequest();
        OutputStream outputStream = null;
        InputStream inputStream = null;
        try {
            boolean bl3 = false;
            try {
                this.postSocket = new Socket();
                this.postSocket.connect(new InetSocketAddress(string, n2), 10000);
                bl3 = true;
            }
            catch (Exception exception) {
                if (exception.toString().contains(NO_HOST)) {
                    hTTPResponse.setStatusCode(600);
                } else {
                    hTTPResponse.setStatusCode(510);
                }
                hTTPResponse.setContent(exception.toString());
            }
            if (bl3) {
                outputStream = this.postSocket.getOutputStream();
                PrintStream printStream = new PrintStream(outputStream);
                printStream.print(this.getHeader());
                printStream.print("\r\n");
                boolean bl4 = this.isChunked();
                String string2 = this.getContentString();
                int n3 = 0;
                if (string2 != null) {
                    n3 = string2.length();
                }
                if (0 < n3) {
                    if (bl4) {
                        String string3 = Long.toHexString(n3);
                        printStream.print(string3);
                        printStream.print("\r\n");
                    }
                    printStream.print(string2);
                    if (bl4) {
                        printStream.print("\r\n");
                    }
                }
                if (bl4) {
                    printStream.print("0");
                    printStream.print("\r\n");
                }
                printStream.flush();
                inputStream = this.postSocket.getInputStream();
                hTTPResponse.set(inputStream, bl2);
            }
        }
        catch (Exception exception) {
            hTTPResponse.setStatusCode(7000);
            hTTPResponse.setContent(exception.toString());
            CLog.w(TAG, exception);
        }
        finally {
            if (!bl) {
                try {
                    inputStream.close();
                }
                catch (Exception exception) {}
                if (inputStream != null) {
                    try {
                        outputStream.close();
                    }
                    catch (Exception exception) {}
                }
                if (outputStream != null) {
                    try {
                        this.postSocket.close();
                    }
                    catch (Exception exception) {}
                }
                this.postSocket = null;
            }
        }
        return hTTPResponse;
    }

    public HTTPResponse post(String string, int n2) {
        return this.post(string, n2, false);
    }

    public void set(HTTPRequest hTTPRequest) {
        this.set((HTTPPacket)hTTPRequest);
        this.setSocket(hTTPRequest.getSocket());
    }

    public boolean returnResponse(int n2) {
        HTTPResponse hTTPResponse = new HTTPResponse();
        hTTPResponse.setStatusCode(n2);
        hTTPResponse.setContentLength(0L);
        return this.post(hTTPResponse);
    }

    public boolean returnOK() {
        return this.returnResponse(200);
    }

    public boolean returnBadRequest() {
        return this.returnResponse(400);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getHeader());
        stringBuffer.append("\r\n");
        stringBuffer.append(this.getContentString());
        return stringBuffer.toString();
    }

    public void print() {
        CLog.d(TAG, this.toString());
    }
}

