/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.glide.load.engine.bitmap_recycle;

import android.graphics.Bitmap;
import com.hpplay.glide.load.engine.bitmap_recycle.BaseKeyPool;
import com.hpplay.glide.load.engine.bitmap_recycle.GroupedLinkedMap;
import com.hpplay.glide.load.engine.bitmap_recycle.LruPoolStrategy;
import com.hpplay.glide.load.engine.bitmap_recycle.Poolable;
import com.hpplay.glide.util.Util;

class AttributeStrategy
implements LruPoolStrategy {
    private final KeyPool keyPool = new KeyPool();
    private final GroupedLinkedMap<Key, Bitmap> groupedMap = new GroupedLinkedMap();

    AttributeStrategy() {
    }

    @Override
    public void put(Bitmap bitmap) {
        Key key = this.keyPool.get(bitmap.getWidth(), bitmap.getHeight(), bitmap.getConfig());
        this.groupedMap.put(key, bitmap);
    }

    @Override
    public Bitmap get(int n2, int n3, Bitmap.Config config) {
        Key key = this.keyPool.get(n2, n3, config);
        return this.groupedMap.get(key);
    }

    @Override
    public Bitmap removeLast() {
        return this.groupedMap.removeLast();
    }

    @Override
    public String logBitmap(Bitmap bitmap) {
        return AttributeStrategy.getBitmapString(bitmap);
    }

    @Override
    public String logBitmap(int n2, int n3, Bitmap.Config config) {
        return AttributeStrategy.getBitmapString(n2, n3, config);
    }

    @Override
    public int getSize(Bitmap bitmap) {
        return Util.getBitmapByteSize(bitmap);
    }

    public String toString() {
        return "AttributeStrategy:\n  " + this.groupedMap;
    }

    private static String getBitmapString(Bitmap bitmap) {
        return AttributeStrategy.getBitmapString(bitmap.getWidth(), bitmap.getHeight(), bitmap.getConfig());
    }

    private static String getBitmapString(int n2, int n3, Bitmap.Config config) {
        return "[" + n2 + "x" + n3 + "], " + config;
    }

    static class Key
    implements Poolable {
        private final KeyPool pool;
        private int width;
        private int height;
        private Bitmap.Config config;

        public Key(KeyPool keyPool) {
            this.pool = keyPool;
        }

        public void init(int n2, int n3, Bitmap.Config config) {
            this.width = n2;
            this.height = n3;
            this.config = config;
        }

        public boolean equals(Object object) {
            if (object instanceof Key) {
                Key key = (Key)object;
                return this.width == key.width && this.height == key.height && this.config == key.config;
            }
            return false;
        }

        public int hashCode() {
            int n2 = this.width;
            n2 = 31 * n2 + this.height;
            n2 = 31 * n2 + (this.config != null ? this.config.hashCode() : 0);
            return n2;
        }

        public String toString() {
            return AttributeStrategy.getBitmapString(this.width, this.height, this.config);
        }

        @Override
        public void offer() {
            this.pool.offer(this);
        }
    }

    static class KeyPool
    extends BaseKeyPool<Key> {
        KeyPool() {
        }

        public Key get(int n2, int n3, Bitmap.Config config) {
            Key key = (Key)this.get();
            key.init(n2, n3, config);
            return key;
        }

        @Override
        protected Key create() {
            return new Key(this);
        }
    }
}

