/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.glide.load.engine;

import android.os.Looper;
import android.os.MessageQueue;
import android.util.Log;
import com.hpplay.glide.Priority;
import com.hpplay.glide.load.Key;
import com.hpplay.glide.load.Transformation;
import com.hpplay.glide.load.data.DataFetcher;
import com.hpplay.glide.load.engine.DecodeJob;
import com.hpplay.glide.load.engine.DiskCacheStrategy;
import com.hpplay.glide.load.engine.EngineJob;
import com.hpplay.glide.load.engine.EngineJobListener;
import com.hpplay.glide.load.engine.EngineKey;
import com.hpplay.glide.load.engine.EngineKeyFactory;
import com.hpplay.glide.load.engine.EngineResource;
import com.hpplay.glide.load.engine.EngineRunnable;
import com.hpplay.glide.load.engine.Resource;
import com.hpplay.glide.load.engine.ResourceRecycler;
import com.hpplay.glide.load.engine.cache.DiskCache;
import com.hpplay.glide.load.engine.cache.DiskCacheAdapter;
import com.hpplay.glide.load.engine.cache.MemoryCache;
import com.hpplay.glide.load.resource.transcode.ResourceTranscoder;
import com.hpplay.glide.provider.DataLoadProvider;
import com.hpplay.glide.request.ResourceCallback;
import com.hpplay.glide.util.LogTime;
import com.hpplay.glide.util.Util;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;

public class Engine
implements EngineJobListener,
EngineResource.ResourceListener,
MemoryCache.ResourceRemovedListener {
    private static final String TAG = "Engine";
    private final Map<Key, EngineJob> jobs;
    private final EngineKeyFactory keyFactory;
    private final MemoryCache cache;
    private final EngineJobFactory engineJobFactory;
    private final Map<Key, WeakReference<EngineResource<?>>> activeResources;
    private final ResourceRecycler resourceRecycler;
    private final LazyDiskCacheProvider diskCacheProvider;
    private ReferenceQueue<EngineResource<?>> resourceReferenceQueue;

    public Engine(MemoryCache memoryCache, DiskCache.Factory factory, ExecutorService executorService, ExecutorService executorService2) {
        this(memoryCache, factory, executorService, executorService2, null, null, null, null, null);
    }

    Engine(MemoryCache memoryCache, DiskCache.Factory factory, ExecutorService executorService, ExecutorService executorService2, Map<Key, EngineJob> map, EngineKeyFactory engineKeyFactory, Map<Key, WeakReference<EngineResource<?>>> map2, EngineJobFactory engineJobFactory, ResourceRecycler resourceRecycler) {
        this.cache = memoryCache;
        this.diskCacheProvider = new LazyDiskCacheProvider(factory);
        if (map2 == null) {
            map2 = new HashMap();
        }
        this.activeResources = map2;
        if (engineKeyFactory == null) {
            engineKeyFactory = new EngineKeyFactory();
        }
        this.keyFactory = engineKeyFactory;
        if (map == null) {
            map = new HashMap<Key, EngineJob>();
        }
        this.jobs = map;
        if (engineJobFactory == null) {
            engineJobFactory = new EngineJobFactory(executorService, executorService2, this);
        }
        this.engineJobFactory = engineJobFactory;
        if (resourceRecycler == null) {
            resourceRecycler = new ResourceRecycler();
        }
        this.resourceRecycler = resourceRecycler;
        memoryCache.setResourceRemovedListener(this);
    }

    public <T, Z, R> LoadStatus load(Key key, int n2, int n3, DataFetcher<T> dataFetcher, DataLoadProvider<T, Z> dataLoadProvider, Transformation<Z> transformation, ResourceTranscoder<Z, R> resourceTranscoder, Priority priority, boolean bl, DiskCacheStrategy diskCacheStrategy, ResourceCallback resourceCallback) {
        Util.assertMainThread();
        long l2 = LogTime.getLogTime();
        String string = dataFetcher.getId();
        EngineKey engineKey = this.keyFactory.buildKey(string, key, n2, n3, dataLoadProvider.getCacheDecoder(), dataLoadProvider.getSourceDecoder(), transformation, dataLoadProvider.getEncoder(), resourceTranscoder, dataLoadProvider.getSourceEncoder());
        EngineResource<?> engineResource = this.loadFromCache(engineKey, bl);
        if (engineResource != null) {
            resourceCallback.onResourceReady(engineResource);
            if (Log.isLoggable((String)TAG, (int)2)) {
                Engine.logWithTimeAndKey("Loaded resource from cache", l2, engineKey);
            }
            return null;
        }
        EngineResource<?> engineResource2 = this.loadFromActiveResources(engineKey, bl);
        if (engineResource2 != null) {
            resourceCallback.onResourceReady(engineResource2);
            if (Log.isLoggable((String)TAG, (int)2)) {
                Engine.logWithTimeAndKey("Loaded resource from active resources", l2, engineKey);
            }
            return null;
        }
        EngineJob engineJob = this.jobs.get(engineKey);
        if (engineJob != null) {
            engineJob.addCallback(resourceCallback);
            if (Log.isLoggable((String)TAG, (int)2)) {
                Engine.logWithTimeAndKey("Added to existing load", l2, engineKey);
            }
            return new LoadStatus(resourceCallback, engineJob);
        }
        EngineJob engineJob2 = this.engineJobFactory.build(engineKey, bl);
        DecodeJob<T, Z, R> decodeJob = new DecodeJob<T, Z, R>(engineKey, n2, n3, dataFetcher, dataLoadProvider, transformation, resourceTranscoder, this.diskCacheProvider, diskCacheStrategy, priority);
        EngineRunnable engineRunnable = new EngineRunnable(engineJob2, decodeJob, priority);
        this.jobs.put(engineKey, engineJob2);
        engineJob2.addCallback(resourceCallback);
        engineJob2.start(engineRunnable);
        if (Log.isLoggable((String)TAG, (int)2)) {
            Engine.logWithTimeAndKey("Started new load", l2, engineKey);
        }
        return new LoadStatus(resourceCallback, engineJob2);
    }

    private static void logWithTimeAndKey(String string, long l2, Key key) {
        Log.v((String)TAG, (String)(string + " in " + LogTime.getElapsedMillis(l2) + "ms, key: " + key));
    }

    private EngineResource<?> loadFromActiveResources(Key key, boolean bl) {
        if (!bl) {
            return null;
        }
        EngineResource engineResource = null;
        WeakReference<EngineResource<?>> weakReference = this.activeResources.get(key);
        if (weakReference != null) {
            engineResource = (EngineResource)weakReference.get();
            if (engineResource != null) {
                engineResource.acquire();
            } else {
                this.activeResources.remove(key);
            }
        }
        return engineResource;
    }

    private EngineResource<?> loadFromCache(Key key, boolean bl) {
        if (!bl) {
            return null;
        }
        EngineResource<?> engineResource = this.getEngineResourceFromCache(key);
        if (engineResource != null) {
            engineResource.acquire();
            this.activeResources.put(key, new ResourceWeakReference(key, engineResource, this.getReferenceQueue()));
        }
        return engineResource;
    }

    private EngineResource<?> getEngineResourceFromCache(Key key) {
        Resource<?> resource = this.cache.remove(key);
        EngineResource engineResource = resource == null ? null : (resource instanceof EngineResource ? (EngineResource)resource : new EngineResource(resource, true));
        return engineResource;
    }

    public void release(Resource resource) {
        Util.assertMainThread();
        if (!(resource instanceof EngineResource)) {
            throw new IllegalArgumentException("Cannot release anything but an EngineResource");
        }
        ((EngineResource)resource).release();
    }

    @Override
    public void onEngineJobComplete(Key key, EngineResource<?> engineResource) {
        Util.assertMainThread();
        if (engineResource != null) {
            engineResource.setResourceListener(key, this);
            if (engineResource.isCacheable()) {
                this.activeResources.put(key, new ResourceWeakReference(key, engineResource, this.getReferenceQueue()));
            }
        }
        this.jobs.remove(key);
    }

    @Override
    public void onEngineJobCancelled(EngineJob engineJob, Key key) {
        Util.assertMainThread();
        EngineJob engineJob2 = this.jobs.get(key);
        if (engineJob.equals(engineJob2)) {
            this.jobs.remove(key);
        }
    }

    @Override
    public void onResourceRemoved(Resource<?> resource) {
        Util.assertMainThread();
        this.resourceRecycler.recycle(resource);
    }

    public void onResourceReleased(Key key, EngineResource engineResource) {
        Util.assertMainThread();
        this.activeResources.remove(key);
        if (engineResource.isCacheable()) {
            this.cache.put(key, engineResource);
        } else {
            this.resourceRecycler.recycle(engineResource);
        }
    }

    public void clearDiskCache() {
        this.diskCacheProvider.getDiskCache().clear();
    }

    private ReferenceQueue<EngineResource<?>> getReferenceQueue() {
        if (this.resourceReferenceQueue == null) {
            this.resourceReferenceQueue = new ReferenceQueue();
            MessageQueue messageQueue = Looper.myQueue();
            messageQueue.addIdleHandler((MessageQueue.IdleHandler)new RefQueueIdleHandler(this.activeResources, this.resourceReferenceQueue));
        }
        return this.resourceReferenceQueue;
    }

    static class EngineJobFactory {
        private final ExecutorService diskCacheService;
        private final ExecutorService sourceService;
        private final EngineJobListener listener;

        public EngineJobFactory(ExecutorService executorService, ExecutorService executorService2, EngineJobListener engineJobListener) {
            this.diskCacheService = executorService;
            this.sourceService = executorService2;
            this.listener = engineJobListener;
        }

        public EngineJob build(Key key, boolean bl) {
            return new EngineJob(key, this.diskCacheService, this.sourceService, bl, this.listener);
        }
    }

    private static class RefQueueIdleHandler
    implements MessageQueue.IdleHandler {
        private final Map<Key, WeakReference<EngineResource<?>>> activeResources;
        private final ReferenceQueue<EngineResource<?>> queue;

        public RefQueueIdleHandler(Map<Key, WeakReference<EngineResource<?>>> map, ReferenceQueue<EngineResource<?>> referenceQueue) {
            this.activeResources = map;
            this.queue = referenceQueue;
        }

        public boolean queueIdle() {
            ResourceWeakReference resourceWeakReference = (ResourceWeakReference)this.queue.poll();
            if (resourceWeakReference != null) {
                this.activeResources.remove(resourceWeakReference.key);
            }
            return true;
        }
    }

    private static class ResourceWeakReference
    extends WeakReference<EngineResource<?>> {
        private final Key key;

        public ResourceWeakReference(Key key, EngineResource<?> engineResource, ReferenceQueue<? super EngineResource<?>> referenceQueue) {
            super(engineResource, referenceQueue);
            this.key = key;
        }
    }

    private static class LazyDiskCacheProvider
    implements DecodeJob.DiskCacheProvider {
        private final DiskCache.Factory factory;
        private volatile DiskCache diskCache;

        public LazyDiskCacheProvider(DiskCache.Factory factory) {
            this.factory = factory;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public DiskCache getDiskCache() {
            if (this.diskCache == null) {
                LazyDiskCacheProvider lazyDiskCacheProvider = this;
                synchronized (lazyDiskCacheProvider) {
                    if (this.diskCache == null) {
                        this.diskCache = this.factory.build();
                    }
                    if (this.diskCache == null) {
                        this.diskCache = new DiskCacheAdapter();
                    }
                }
            }
            return this.diskCache;
        }
    }

    public static class LoadStatus {
        private final EngineJob engineJob;
        private final ResourceCallback cb;

        public LoadStatus(ResourceCallback resourceCallback, EngineJob engineJob) {
            this.cb = resourceCallback;
            this.engineJob = engineJob;
        }

        public void cancel() {
            this.engineJob.removeCallback(this.cb);
        }
    }
}

