/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.component.protocol.mirror;

import com.hpplay.component.common.protocol.IMirrorStateListener;
import com.hpplay.component.common.utils.CLog;
import com.hpplay.component.netcore.LelinkNetCore;
import com.hpplay.component.protocol.ProtocolCore;
import java.io.IOException;
import java.nio.ByteBuffer;

public class VideoSender
extends ProtocolCore {
    private static final String TAG = "VideoSender";
    private LelinkNetCore mRudpDataSender;
    public static final int TIME_OUT = 3000;
    private int mType = 0;
    private byte[] videoData = new byte[0x200000];
    private int len;
    private long printType;
    private int sendLen;
    private long mTimeout = 0L;

    public boolean connect(String string, int n2, int n3) {
        this.mType = n3;
        this.release();
        if (n3 == 2) {
            return this.createMirrorSocket(string, n2);
        }
        if (this.mRudpDataSender == null) {
            CLog.i(TAG, "......rudp create......");
            this.mRudpDataSender = new LelinkNetCore();
            this.mRudpDataSender.init();
        }
        return this.mRudpDataSender.connect(string, n2) == 0;
    }

    public int getInitBitrate() {
        if (this.mRudpDataSender != null) {
            return this.mRudpDataSender.getInitBitrate();
        }
        return 9000000;
    }

    public void setMirrorStateListener(IMirrorStateListener iMirrorStateListener) {
        if (this.mRudpDataSender != null) {
            this.mRudpDataSender.setMirrorStateListener(iMirrorStateListener);
        }
    }

    public void sendData(ByteBuffer byteBuffer) {
        if (System.currentTimeMillis() - this.printType > 3000L) {
            CLog.i(TAG, "==============sendData ==" + (this.mType == 2 ? "TCP" : "UDP"));
            this.printType = System.currentTimeMillis();
        }
        if (this.mType == 2) {
            this.mLocalFileOutputStream.getChannel().write(byteBuffer);
            this.mLocalFileOutputStream.flush();
        } else {
            this.len = byteBuffer.remaining();
            byteBuffer.get(this.videoData, 0, this.len);
            this.sendLen = this.mRudpDataSender.send(this.videoData, this.len);
            if (this.sendLen == 0 && this.mTimeout == 0L) {
                this.mTimeout = System.currentTimeMillis();
            } else if (this.sendLen > 0) {
                this.mTimeout = System.currentTimeMillis();
            }
            if (System.currentTimeMillis() - this.mTimeout > 3000L) {
                throw new Exception("RUDP send data error ...");
            }
        }
    }

    public int getSendType() {
        return this.mType;
    }

    public synchronized void release() {
        CLog.i(TAG, "==============release ==" + this.mType);
        if (this.mSocket != null) {
            try {
                this.mSocket.close();
            }
            catch (IOException iOException) {
                CLog.w(TAG, iOException);
            }
            finally {
                this.mSocket = null;
                this.mLocalFileOutputStream = null;
                this.mLocalAutoCloseInputStream = null;
            }
        }
        if (this.mLocalFileOutputStream != null) {
            try {
                this.mLocalFileOutputStream.close();
            }
            catch (IOException iOException) {
                CLog.w(TAG, iOException);
            }
        }
        if (this.mLocalAutoCloseInputStream != null) {
            try {
                this.mLocalAutoCloseInputStream.close();
            }
            catch (IOException iOException) {
                CLog.w(TAG, iOException);
            }
        }
        if (this.mRudpDataSender != null) {
            CLog.i(TAG, "......rudp close......");
            this.mRudpDataSender.close();
            this.mRudpDataSender.unInit();
            this.mRudpDataSender = null;
        }
    }
}

