/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.glide.load.engine;

import android.util.Log;
import com.hpplay.glide.Priority;
import com.hpplay.glide.load.Encoder;
import com.hpplay.glide.load.Key;
import com.hpplay.glide.load.Transformation;
import com.hpplay.glide.load.data.DataFetcher;
import com.hpplay.glide.load.engine.DiskCacheStrategy;
import com.hpplay.glide.load.engine.EngineKey;
import com.hpplay.glide.load.engine.Resource;
import com.hpplay.glide.load.engine.cache.DiskCache;
import com.hpplay.glide.load.resource.transcode.ResourceTranscoder;
import com.hpplay.glide.provider.DataLoadProvider;
import com.hpplay.glide.util.LogTime;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

class DecodeJob<A, T, Z> {
    private static final String TAG = "DecodeJob";
    private static final FileOpener DEFAULT_FILE_OPENER = new FileOpener();
    private final EngineKey resultKey;
    private final int width;
    private final int height;
    private final DataFetcher<A> fetcher;
    private final DataLoadProvider<A, T> loadProvider;
    private final Transformation<T> transformation;
    private final ResourceTranscoder<T, Z> transcoder;
    private final DiskCacheProvider diskCacheProvider;
    private final DiskCacheStrategy diskCacheStrategy;
    private final Priority priority;
    private final FileOpener fileOpener;
    private volatile boolean isCancelled;

    public DecodeJob(EngineKey engineKey, int n2, int n3, DataFetcher<A> dataFetcher, DataLoadProvider<A, T> dataLoadProvider, Transformation<T> transformation, ResourceTranscoder<T, Z> resourceTranscoder, DiskCacheProvider diskCacheProvider, DiskCacheStrategy diskCacheStrategy, Priority priority) {
        this(engineKey, n2, n3, dataFetcher, dataLoadProvider, transformation, resourceTranscoder, diskCacheProvider, diskCacheStrategy, priority, DEFAULT_FILE_OPENER);
    }

    DecodeJob(EngineKey engineKey, int n2, int n3, DataFetcher<A> dataFetcher, DataLoadProvider<A, T> dataLoadProvider, Transformation<T> transformation, ResourceTranscoder<T, Z> resourceTranscoder, DiskCacheProvider diskCacheProvider, DiskCacheStrategy diskCacheStrategy, Priority priority, FileOpener fileOpener) {
        this.resultKey = engineKey;
        this.width = n2;
        this.height = n3;
        this.fetcher = dataFetcher;
        this.loadProvider = dataLoadProvider;
        this.transformation = transformation;
        this.transcoder = resourceTranscoder;
        this.diskCacheProvider = diskCacheProvider;
        this.diskCacheStrategy = diskCacheStrategy;
        this.priority = priority;
        this.fileOpener = fileOpener;
    }

    public Resource<Z> decodeResultFromCache() {
        if (!this.diskCacheStrategy.cacheResult()) {
            return null;
        }
        long l2 = LogTime.getLogTime();
        Resource<T> resource = this.loadFromCache(this.resultKey);
        if (Log.isLoggable((String)TAG, (int)2)) {
            this.logWithTimeAndKey("Decoded transformed from cache", l2);
        }
        l2 = LogTime.getLogTime();
        Resource<Z> resource2 = this.transcode(resource);
        if (Log.isLoggable((String)TAG, (int)2)) {
            this.logWithTimeAndKey("Transcoded transformed from cache", l2);
        }
        return resource2;
    }

    public Resource<Z> decodeSourceFromCache() {
        if (!this.diskCacheStrategy.cacheSource()) {
            return null;
        }
        long l2 = LogTime.getLogTime();
        Resource<T> resource = this.loadFromCache(this.resultKey.getOriginalKey());
        if (Log.isLoggable((String)TAG, (int)2)) {
            this.logWithTimeAndKey("Decoded source from cache", l2);
        }
        return this.transformEncodeAndTranscode(resource);
    }

    public Resource<Z> decodeFromSource() {
        Resource<T> resource = this.decodeSource();
        return this.transformEncodeAndTranscode(resource);
    }

    public void cancel() {
        this.isCancelled = true;
        this.fetcher.cancel();
    }

    private Resource<Z> transformEncodeAndTranscode(Resource<T> resource) {
        long l2 = LogTime.getLogTime();
        Resource<T> resource2 = this.transform(resource);
        if (Log.isLoggable((String)TAG, (int)2)) {
            this.logWithTimeAndKey("Transformed resource from source", l2);
        }
        this.writeTransformedToCache(resource2);
        l2 = LogTime.getLogTime();
        Resource<Z> resource3 = this.transcode(resource2);
        if (Log.isLoggable((String)TAG, (int)2)) {
            this.logWithTimeAndKey("Transcoded transformed from source", l2);
        }
        return resource3;
    }

    private void writeTransformedToCache(Resource<T> resource) {
        if (resource == null || !this.diskCacheStrategy.cacheResult()) {
            return;
        }
        long l2 = LogTime.getLogTime();
        SourceWriter<Resource<T>> sourceWriter = new SourceWriter<Resource<T>>(this.loadProvider.getEncoder(), resource);
        this.diskCacheProvider.getDiskCache().put(this.resultKey, sourceWriter);
        if (Log.isLoggable((String)TAG, (int)2)) {
            this.logWithTimeAndKey("Wrote transformed from source to cache", l2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Resource<T> decodeSource() {
        Resource<T> resource = null;
        try {
            long l2 = LogTime.getLogTime();
            A a2 = this.fetcher.loadData(this.priority);
            if (Log.isLoggable((String)TAG, (int)2)) {
                this.logWithTimeAndKey("Fetched data", l2);
            }
            if (this.isCancelled) {
                Resource<T> resource2 = null;
                return resource2;
            }
            resource = this.decodeFromSourceData(a2);
        }
        finally {
            this.fetcher.cleanup();
        }
        return resource;
    }

    private Resource<T> decodeFromSourceData(A a2) {
        Resource<T> resource;
        if (this.diskCacheStrategy.cacheSource()) {
            resource = this.cacheAndDecodeSourceData(a2);
        } else {
            long l2 = LogTime.getLogTime();
            resource = this.loadProvider.getSourceDecoder().decode(a2, this.width, this.height);
            if (Log.isLoggable((String)TAG, (int)2)) {
                this.logWithTimeAndKey("Decoded from source", l2);
            }
        }
        return resource;
    }

    private Resource<T> cacheAndDecodeSourceData(A a2) {
        long l2 = LogTime.getLogTime();
        SourceWriter<A> sourceWriter = new SourceWriter<A>(this.loadProvider.getSourceEncoder(), a2);
        this.diskCacheProvider.getDiskCache().put(this.resultKey.getOriginalKey(), sourceWriter);
        if (Log.isLoggable((String)TAG, (int)2)) {
            this.logWithTimeAndKey("Wrote source to cache", l2);
        }
        l2 = LogTime.getLogTime();
        Resource<T> resource = this.loadFromCache(this.resultKey.getOriginalKey());
        if (Log.isLoggable((String)TAG, (int)2) && resource != null) {
            this.logWithTimeAndKey("Decoded source from cache", l2);
        }
        return resource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Resource<T> loadFromCache(Key key) {
        File file = this.diskCacheProvider.getDiskCache().get(key);
        if (file == null) {
            return null;
        }
        Resource<T> resource = null;
        try {
            resource = this.loadProvider.getCacheDecoder().decode(file, this.width, this.height);
        }
        finally {
            if (resource == null) {
                this.diskCacheProvider.getDiskCache().delete(key);
            }
        }
        return resource;
    }

    private Resource<T> transform(Resource<T> resource) {
        if (resource == null) {
            return null;
        }
        Resource<T> resource2 = this.transformation.transform(resource, this.width, this.height);
        if (!resource.equals(resource2)) {
            resource.recycle();
        }
        return resource2;
    }

    private Resource<Z> transcode(Resource<T> resource) {
        if (resource == null) {
            return null;
        }
        return this.transcoder.transcode(resource);
    }

    private void logWithTimeAndKey(String string, long l2) {
        Log.v((String)TAG, (String)(string + " in " + LogTime.getElapsedMillis(l2) + ", key: " + this.resultKey));
    }

    static class FileOpener {
        FileOpener() {
        }

        public OutputStream open(File file) {
            return new BufferedOutputStream(new FileOutputStream(file));
        }
    }

    static interface DiskCacheProvider {
        public DiskCache getDiskCache();
    }

    class SourceWriter<DataType>
    implements DiskCache.Writer {
        private final Encoder<DataType> encoder;
        private final DataType data;

        public SourceWriter(Encoder<DataType> encoder, DataType DataType) {
            this.encoder = encoder;
            this.data = DataType;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean write(File file) {
            boolean bl = false;
            OutputStream outputStream = null;
            try {
                outputStream = DecodeJob.this.fileOpener.open(file);
                bl = this.encoder.encode(this.data, outputStream);
            }
            catch (FileNotFoundException fileNotFoundException) {
                if (Log.isLoggable((String)DecodeJob.TAG, (int)3)) {
                    Log.d((String)DecodeJob.TAG, (String)"Failed to find file to write to disk cache", (Throwable)fileNotFoundException);
                }
            }
            finally {
                if (outputStream != null) {
                    try {
                        outputStream.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            return bl;
        }
    }
}

