/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.glide.load.resource.bitmap;

import android.util.Log;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class RecyclableBufferedInputStream
extends FilterInputStream {
    private static final String TAG = "BufferedIs";
    private volatile byte[] buf;
    private int count;
    private int marklimit;
    private int markpos = -1;
    private int pos;

    public RecyclableBufferedInputStream(InputStream inputStream, byte[] byArray) {
        super(inputStream);
        if (byArray == null || byArray.length == 0) {
            throw new IllegalArgumentException("buffer is null or empty");
        }
        this.buf = byArray;
    }

    @Override
    public synchronized int available() {
        InputStream inputStream = this.in;
        if (this.buf == null || inputStream == null) {
            throw RecyclableBufferedInputStream.streamClosed();
        }
        return this.count - this.pos + inputStream.available();
    }

    private static IOException streamClosed() {
        throw new IOException("BufferedInputStream is closed");
    }

    public synchronized void fixMarkLimit() {
        this.marklimit = this.buf.length;
    }

    @Override
    public void close() {
        this.buf = null;
        InputStream inputStream = this.in;
        this.in = null;
        if (inputStream != null) {
            inputStream.close();
        }
    }

    private int fillbuf(InputStream inputStream, byte[] byArray) {
        int n2;
        if (this.markpos == -1 || this.pos - this.markpos >= this.marklimit) {
            int n3 = inputStream.read(byArray);
            if (n3 > 0) {
                this.markpos = -1;
                this.pos = 0;
                this.count = n3;
            }
            return n3;
        }
        if (this.markpos == 0 && this.marklimit > byArray.length && this.count == byArray.length) {
            n2 = byArray.length * 2;
            if (n2 > this.marklimit) {
                n2 = this.marklimit;
            }
            if (Log.isLoggable((String)TAG, (int)3)) {
                Log.d((String)TAG, (String)("allocate buffer of length: " + n2));
            }
            byte[] byArray2 = new byte[n2];
            System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
            this.buf = byArray2;
            byArray = byArray2;
        } else if (this.markpos > 0) {
            System.arraycopy(byArray, this.markpos, byArray, 0, byArray.length - this.markpos);
        }
        this.pos -= this.markpos;
        this.markpos = 0;
        this.count = 0;
        n2 = inputStream.read(byArray, this.pos, byArray.length - this.pos);
        this.count = n2 <= 0 ? this.pos : this.pos + n2;
        return n2;
    }

    @Override
    public synchronized void mark(int n2) {
        this.marklimit = Math.max(this.marklimit, n2);
        this.markpos = this.pos;
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public synchronized int read() {
        byte[] byArray = this.buf;
        InputStream inputStream = this.in;
        if (byArray == null || inputStream == null) {
            throw RecyclableBufferedInputStream.streamClosed();
        }
        if (this.pos >= this.count && this.fillbuf(inputStream, byArray) == -1) {
            return -1;
        }
        if (byArray != this.buf && (byArray = this.buf) == null) {
            throw RecyclableBufferedInputStream.streamClosed();
        }
        if (this.count - this.pos > 0) {
            return byArray[this.pos++] & 0xFF;
        }
        return -1;
    }

    @Override
    public synchronized int read(byte[] byArray, int n2, int n3) {
        int n4;
        int n5;
        byte[] byArray2 = this.buf;
        if (byArray2 == null) {
            throw RecyclableBufferedInputStream.streamClosed();
        }
        if (n3 == 0) {
            return 0;
        }
        InputStream inputStream = this.in;
        if (inputStream == null) {
            throw RecyclableBufferedInputStream.streamClosed();
        }
        if (this.pos < this.count) {
            n5 = this.count - this.pos >= n3 ? n3 : this.count - this.pos;
            System.arraycopy(byArray2, this.pos, byArray, n2, n5);
            this.pos += n5;
            if (n5 == n3 || inputStream.available() == 0) {
                return n5;
            }
            n2 += n5;
            n4 = n3 - n5;
        } else {
            n4 = n3;
        }
        while (true) {
            if (this.markpos == -1 && n4 >= byArray2.length) {
                n5 = inputStream.read(byArray, n2, n4);
                if (n5 == -1) {
                    return n4 == n3 ? -1 : n3 - n4;
                }
            } else {
                if (this.fillbuf(inputStream, byArray2) == -1) {
                    return n4 == n3 ? -1 : n3 - n4;
                }
                if (byArray2 != this.buf && (byArray2 = this.buf) == null) {
                    throw RecyclableBufferedInputStream.streamClosed();
                }
                n5 = this.count - this.pos >= n4 ? n4 : this.count - this.pos;
                System.arraycopy(byArray2, this.pos, byArray, n2, n5);
                this.pos += n5;
            }
            if ((n4 -= n5) == 0) {
                return n3;
            }
            if (inputStream.available() == 0) {
                return n3 - n4;
            }
            n2 += n5;
        }
    }

    @Override
    public synchronized void reset() {
        if (this.buf == null) {
            throw new IOException("Stream is closed");
        }
        if (-1 == this.markpos) {
            throw new InvalidMarkException("Mark has been invalidated");
        }
        this.pos = this.markpos;
    }

    @Override
    public synchronized long skip(long l2) {
        byte[] byArray = this.buf;
        InputStream inputStream = this.in;
        if (byArray == null) {
            throw RecyclableBufferedInputStream.streamClosed();
        }
        if (l2 < 1L) {
            return 0L;
        }
        if (inputStream == null) {
            throw RecyclableBufferedInputStream.streamClosed();
        }
        if ((long)(this.count - this.pos) >= l2) {
            this.pos = (int)((long)this.pos + l2);
            return l2;
        }
        long l3 = this.count - this.pos;
        this.pos = this.count;
        if (this.markpos != -1 && l2 <= (long)this.marklimit) {
            if (this.fillbuf(inputStream, byArray) == -1) {
                return l3;
            }
            if ((long)(this.count - this.pos) >= l2 - l3) {
                this.pos = (int)((long)this.pos + (l2 - l3));
                return l2;
            }
            l3 = l3 + (long)this.count - (long)this.pos;
            this.pos = this.count;
            return l3;
        }
        return l3 + inputStream.skip(l2 - l3);
    }

    public static class InvalidMarkException
    extends RuntimeException {
        private static final long serialVersionUID = -4338378848813561757L;

        public InvalidMarkException(String string) {
            super(string);
        }
    }
}

