/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.glide.request.target;

import android.annotation.TargetApi;
import android.graphics.Point;
import android.os.Build;
import android.util.Log;
import android.view.Display;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.view.WindowManager;
import com.hpplay.glide.request.Request;
import com.hpplay.glide.request.target.BaseTarget;
import com.hpplay.glide.request.target.SizeReadyCallback;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;

public abstract class ViewTarget<T extends View, Z>
extends BaseTarget<Z> {
    private static final String TAG = "ViewTarget";
    private static boolean isTagUsedAtLeastOnce = false;
    private static Integer tagId = null;
    protected final T view;
    private final SizeDeterminer sizeDeterminer;

    public static void setTagId(int n2) {
        if (tagId != null || isTagUsedAtLeastOnce) {
            throw new IllegalArgumentException("You cannot set the tag id more than once or change the tag id after the first request has been made");
        }
        tagId = n2;
    }

    public ViewTarget(T t2) {
        if (t2 == null) {
            throw new NullPointerException("View must not be null!");
        }
        this.view = t2;
        this.sizeDeterminer = new SizeDeterminer((View)t2);
    }

    public T getView() {
        return this.view;
    }

    @Override
    public void getSize(SizeReadyCallback sizeReadyCallback) {
        this.sizeDeterminer.getSize(sizeReadyCallback);
    }

    @Override
    public void setRequest(Request request) {
        this.setTag(request);
    }

    @Override
    public Request getRequest() {
        Object object = this.getTag();
        Request request = null;
        if (object != null) {
            if (object instanceof Request) {
                request = (Request)object;
            } else {
                throw new IllegalArgumentException("You must not call setTag() on a view Glide is targeting");
            }
        }
        return request;
    }

    private void setTag(Object object) {
        if (tagId == null) {
            isTagUsedAtLeastOnce = true;
            this.view.setTag(object);
        } else {
            this.view.setTag(tagId.intValue(), object);
        }
    }

    private Object getTag() {
        if (tagId == null) {
            return this.view.getTag();
        }
        return this.view.getTag(tagId.intValue());
    }

    public String toString() {
        return "Target for: " + this.view;
    }

    private static class SizeDeterminer {
        private static final int PENDING_SIZE = 0;
        private final View view;
        private final List<SizeReadyCallback> cbs = new ArrayList<SizeReadyCallback>();
        private SizeDeterminerLayoutListener layoutListener;
        private Point displayDimens;

        public SizeDeterminer(View view) {
            this.view = view;
        }

        private void notifyCbs(int n2, int n3) {
            for (SizeReadyCallback sizeReadyCallback : this.cbs) {
                sizeReadyCallback.onSizeReady(n2, n3);
            }
            this.cbs.clear();
        }

        private void checkCurrentDimens() {
            if (this.cbs.isEmpty()) {
                return;
            }
            int n2 = this.getViewWidthOrParam();
            int n3 = this.getViewHeightOrParam();
            if (!this.isSizeValid(n2) || !this.isSizeValid(n3)) {
                return;
            }
            this.notifyCbs(n2, n3);
            ViewTreeObserver viewTreeObserver = this.view.getViewTreeObserver();
            if (viewTreeObserver.isAlive()) {
                viewTreeObserver.removeOnPreDrawListener((ViewTreeObserver.OnPreDrawListener)this.layoutListener);
            }
            this.layoutListener = null;
        }

        public void getSize(SizeReadyCallback sizeReadyCallback) {
            int n2 = this.getViewWidthOrParam();
            int n3 = this.getViewHeightOrParam();
            if (this.isSizeValid(n2) && this.isSizeValid(n3)) {
                sizeReadyCallback.onSizeReady(n2, n3);
            } else {
                if (!this.cbs.contains(sizeReadyCallback)) {
                    this.cbs.add(sizeReadyCallback);
                }
                if (this.layoutListener == null) {
                    ViewTreeObserver viewTreeObserver = this.view.getViewTreeObserver();
                    this.layoutListener = new SizeDeterminerLayoutListener(this);
                    viewTreeObserver.addOnPreDrawListener((ViewTreeObserver.OnPreDrawListener)this.layoutListener);
                }
            }
        }

        private int getViewHeightOrParam() {
            ViewGroup.LayoutParams layoutParams = this.view.getLayoutParams();
            if (this.isSizeValid(this.view.getHeight())) {
                return this.view.getHeight();
            }
            if (layoutParams != null) {
                return this.getSizeForParam(layoutParams.height, true);
            }
            return 0;
        }

        private int getViewWidthOrParam() {
            ViewGroup.LayoutParams layoutParams = this.view.getLayoutParams();
            if (this.isSizeValid(this.view.getWidth())) {
                return this.view.getWidth();
            }
            if (layoutParams != null) {
                return this.getSizeForParam(layoutParams.width, false);
            }
            return 0;
        }

        private int getSizeForParam(int n2, boolean bl) {
            if (n2 == -2) {
                Point point = this.getDisplayDimens();
                return bl ? point.y : point.x;
            }
            return n2;
        }

        @TargetApi(value=13)
        private Point getDisplayDimens() {
            if (this.displayDimens != null) {
                return this.displayDimens;
            }
            WindowManager windowManager = (WindowManager)this.view.getContext().getSystemService("window");
            Display display = windowManager.getDefaultDisplay();
            if (Build.VERSION.SDK_INT >= 13) {
                this.displayDimens = new Point();
                display.getSize(this.displayDimens);
            } else {
                this.displayDimens = new Point(display.getWidth(), display.getHeight());
            }
            return this.displayDimens;
        }

        private boolean isSizeValid(int n2) {
            return n2 > 0 || n2 == -2;
        }

        private static class SizeDeterminerLayoutListener
        implements ViewTreeObserver.OnPreDrawListener {
            private final WeakReference<SizeDeterminer> sizeDeterminerRef;

            public SizeDeterminerLayoutListener(SizeDeterminer sizeDeterminer) {
                this.sizeDeterminerRef = new WeakReference<SizeDeterminer>(sizeDeterminer);
            }

            public boolean onPreDraw() {
                SizeDeterminer sizeDeterminer;
                if (Log.isLoggable((String)ViewTarget.TAG, (int)2)) {
                    Log.v((String)ViewTarget.TAG, (String)("OnGlobalLayoutListener called listener=" + this));
                }
                if ((sizeDeterminer = (SizeDeterminer)this.sizeDeterminerRef.get()) != null) {
                    sizeDeterminer.checkCurrentDimens();
                }
                return true;
            }
        }
    }
}

