/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.sdk.source.mdns;

import android.util.Log;
import com.hpplay.sdk.source.mdns.ElementHelper;
import com.hpplay.sdk.source.mdns.MonitorTask;
import com.hpplay.sdk.source.mdns.utils.Misc;
import com.hpplay.sdk.source.mdns.xbill.dns.Cache;
import com.hpplay.sdk.source.mdns.xbill.dns.Header;
import com.hpplay.sdk.source.mdns.xbill.dns.Message;
import com.hpplay.sdk.source.mdns.xbill.dns.MulticastDNSUtils;
import com.hpplay.sdk.source.mdns.xbill.dns.Name;
import com.hpplay.sdk.source.mdns.xbill.dns.Options;
import com.hpplay.sdk.source.mdns.xbill.dns.RRset;
import com.hpplay.sdk.source.mdns.xbill.dns.Record;
import com.hpplay.sdk.source.mdns.xbill.dns.SetResponse;
import java.io.Closeable;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MulticastDNSCache
extends Cache
implements Closeable {
    protected static final Logger logger = Misc.getLogger(MulticastDNSCache.class.getName(), Options.check("mdns_verbose") || Options.check("dns_verbose") || Options.check("verbose"));
    private static MulticastDNSCache multicastDNSCache;
    private CacheMonitor cacheMonitor = null;
    public LinkedHashMap dataCopy;
    private Field dataField = null;
    private Method findElement = null;
    private Method removeElement = null;
    private MonitorTask monitorTask;

    public static MulticastDNSCache getInstance() {
        if (multicastDNSCache == null) {
            try {
                multicastDNSCache = new MulticastDNSCache();
            }
            catch (Exception exception) {
                Log.w((String)"", (Throwable)exception);
            }
        }
        return multicastDNSCache;
    }

    public MulticastDNSCache() {
        this.populateReflectedFields();
    }

    public MulticastDNSCache(int n2) {
        super(n2);
        this.populateReflectedFields();
    }

    public MulticastDNSCache(String string) {
        super(string);
        this.populateReflectedFields();
    }

    MulticastDNSCache(Cache cache) {
        this();
        Field field = cache.getClass().getDeclaredField("data");
        field.setAccessible(true);
        Object object = field.get(cache);
        field = super.getClass().getDeclaredField("data");
        field.setAccessible(true);
        field.set(this, object);
        this.populateReflectedFields();
    }

    @Override
    public synchronized void addRecord(Record record, int n2, Object object) {
        super.addRecord(record, n2, object);
    }

    @Override
    public synchronized void addRRset(RRset rRset, int n2) {
        super.addRRset(rRset, n2);
    }

    @Override
    public synchronized void close() {
        if (this.monitorTask != null) {
            this.monitorTask.release();
        }
        this.release();
        this.cacheMonitor = null;
        multicastDNSCache = null;
    }

    public CacheMonitor getCacheMonitor() {
        return this.cacheMonitor;
    }

    public Message queryCache(Message message) {
        return this.queryCache(message, 1);
    }

    public Message queryCache(Message message, int n2) {
        if (message.getHeader().getOpcode() == 5) {
            Record[] recordArray;
            Message message2 = new Message(message.getHeader().getID());
            Header header = message2.getHeader();
            header.setRcode(3);
            Stack<Name> stack = new Stack<Name>();
            for (Record record : recordArray = MulticastDNSUtils.extractRecords(message, 2)) {
                stack.push(record.getName());
            }
            while (!stack.isEmpty()) {
                Record[] recordArray2;
                Name name = (Name)stack.pop();
                SetResponse setResponse = this.lookupRecords(name, 255, n2);
                if (!setResponse.isSuccessful()) continue;
                header.setRcode(0);
                header.setOpcode(0);
                header.setFlag(0);
                for (Record record : recordArray2 = MulticastDNSUtils.extractRecords(setResponse.answers())) {
                    Name name2;
                    if (!message2.findRecord(record)) {
                        message2.addRecord(record, 1);
                    }
                    if ((name2 = MulticastDNSUtils.getTargetFromRecord(record)) == null) continue;
                    stack.push(name2);
                }
            }
            return message2;
        }
        Message message3 = new Message(message.getHeader().getID());
        Header header = message3.getHeader();
        header.setRcode(3);
        Record[] recordArray = MulticastDNSUtils.extractRecords(message, 0);
        if (recordArray != null && recordArray.length > 0) {
            for (Record record : recordArray) {
                message3.addRecord(record, 0);
                MulticastDNSUtils.setDClassForRecord(record, record.getDClass() & Short.MAX_VALUE);
                SetResponse setResponse = this.lookupRecords(record.getName(), 255, n2);
                if (!setResponse.isSuccessful()) continue;
                header.setRcode(0);
                header.setOpcode(0);
                header.setFlag(0);
                Record[] recordArray3 = MulticastDNSUtils.extractRecords(setResponse.answers());
                if (recordArray3 == null || recordArray3.length <= 0) continue;
                for (Record record2 : recordArray3) {
                    Record[] recordArray4;
                    if (!message3.findRecord(record2)) {
                        message3.addRecord(record2, 1);
                    }
                    for (Record record3 : recordArray4 = this.queryCacheForAdditionalRecords(record2, n2)) {
                        if (message3.findRecord(record3)) continue;
                        message3.addRecord(record3, 3);
                    }
                }
            }
        }
        return message3;
    }

    public Record[] queryCacheForAdditionalRecords(Record record, int n2) {
        SetResponse setResponse;
        if (record == null) {
            return MulticastDNSUtils.EMPTY_RECORDS;
        }
        LinkedList<Record> linkedList = new LinkedList<Record>();
        Name name = MulticastDNSUtils.getTargetFromRecord(record);
        if (name != null && (setResponse = this.lookupRecords(name, 255, n2)).isSuccessful()) {
            Record[] recordArray;
            for (Record record2 : recordArray = MulticastDNSUtils.extractRecords(setResponse.answers())) {
                Record[] recordArray2;
                linkedList.add(record2);
                for (Record record3 : recordArray2 = this.queryCacheForAdditionalRecords(record2, n2)) {
                    linkedList.add(record3);
                }
            }
        }
        return linkedList.toArray(new Record[linkedList.size()]);
    }

    public void removeElementCopy(Name name, int n2) {
        try {
            this.removeElement.invoke((Object)this, name, new Integer(n2));
        }
        catch (Exception exception) {
            logger.log(Level.WARNING, exception.getMessage(), exception);
        }
    }

    public synchronized void setCacheMonitor(CacheMonitor cacheMonitor) {
        if (cacheMonitor != null) {
            this.cacheMonitor = cacheMonitor;
        }
    }

    synchronized void removeRRset(RRset rRset) {
        this.removeElementCopy(rRset.getName(), rRset.getType());
    }

    synchronized void updateRRset(Record record, int n2) {
        int n3;
        long l2 = record.getTTL();
        Name name = record.getName();
        ElementHelper elementHelper = this.findElementCopy(name, n3 = record.getType(), 0);
        if (elementHelper != null) {
            if (elementHelper.compareCredibility(n2) <= 0) {
                if (elementHelper.getElement() instanceof RRset) {
                    ((RRset)elementHelper.getElement()).addRR(record);
                    if (elementHelper.getTTL() == l2) {
                        elementHelper.resetExpire();
                    } else {
                        this.addRecord(record, n2, this);
                    }
                } else {
                    this.addRecord(record, n2, this);
                }
            }
        } else {
            this.addRecord(record, n2, this);
        }
    }

    protected void populateReflectedFields() {
        if (this.monitorTask == null) {
            this.monitorTask = new MonitorTask(this);
            this.monitorTask.start();
        }
        Class<?> clazz = this.getClass().getSuperclass();
        try {
            this.dataField = ElementHelper.findField(clazz, "data");
            AccessibleObject.setAccessible(new AccessibleObject[]{this.dataField}, true);
            this.dataCopy = (LinkedHashMap)this.dataField.get(this);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            logger.log(Level.WARNING, noSuchFieldException.getMessage(), noSuchFieldException);
            throw noSuchFieldException;
        }
        catch (Exception exception) {
            logger.log(Level.WARNING, exception.getMessage(), exception);
        }
        try {
            this.findElement = ElementHelper.findMethod(clazz, "findElement", new Class[]{Name.class, Integer.TYPE, Integer.TYPE});
            this.removeElement = ElementHelper.findMethod(clazz, "removeElement", new Class[]{Name.class, Integer.TYPE});
            AccessibleObject.setAccessible(new AccessibleObject[]{this.findElement, this.removeElement}, true);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            logger.log(Level.WARNING, noSuchMethodException.getMessage(), noSuchMethodException);
            throw noSuchMethodException;
        }
        catch (Exception exception) {
            logger.log(Level.WARNING, exception.getMessage(), exception);
        }
    }

    private ElementHelper findElementCopy(Name name, int n2, int n3) {
        Object object = this.findElement.invoke((Object)this, name, new Integer(n2), new Integer(n3));
        try {
            return object == null ? (ElementHelper)null : new ElementHelper(this, object);
        }
        catch (Exception exception) {
            logger.log(Level.WARNING, exception.getMessage(), exception);
            return null;
        }
    }

    public static interface CacheMonitor {
        public void begin();

        public void check(RRset var1, int var2, int var3);

        public void end();

        public void expired(RRset var1, int var2);

        public boolean isOperational();
    }
}

