/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.component.protocol.mirror.rtsp;

import com.hpplay.component.common.utils.CLog;
import java.nio.ByteBuffer;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RTSPPacket {
    private String rtspVersion;
    private Vector<String> headers = new Vector();
    private Vector<String> headerContent = new Vector();
    private String rawPacket;
    private int contentlenth = 0;
    private ByteBuffer bf = ByteBuffer.allocate(1024);

    public void parseRTSPPacket(String string, byte[] byArray, int n2) {
        Pattern pattern;
        Matcher matcher;
        this.headers.clear();
        this.headerContent.clear();
        this.rawPacket = string;
        if (byArray == null) {
            this.contentlenth = 0;
        }
        if ((matcher = (pattern = Pattern.compile("^(\\w+)\\W(.+)\\WRTSP/(.+)\r\n")).matcher(string)).find()) {
            this.rtspVersion = matcher.group(3).trim();
        }
        pattern = Pattern.compile("^([\\w-]+):\\W(.+)\r\n", 8);
        matcher = pattern.matcher(string);
        while (matcher.find()) {
            this.headers.add(matcher.group(1));
            this.headerContent.add(matcher.group(2));
        }
    }

    public String getContent() {
        if (this.contentlenth == 0) {
            return null;
        }
        try {
            return new String(this.bf.array(), 0, this.contentlenth);
        }
        catch (Exception exception) {
            CLog.w("rtspacket", exception);
            return "";
        }
    }

    public String getVersion() {
        return this.rtspVersion;
    }

    public int getCode() {
        return 200;
    }

    public String valueOfHeader(String string) {
        int n2 = this.headers.indexOf(string);
        if (n2 == -1) {
            return null;
        }
        return this.headerContent.elementAt(n2);
    }

    public String toString() {
        if (this.rawPacket == null) {
            return "";
        }
        String string = this.rawPacket.toString();
        return string;
    }
}

