/*
 * Decompiled with CFR 0.152.
 */
package com.macroyau.blue2serial;

import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothManager;
import android.content.Context;
import android.os.Build;
import android.os.Handler;
import android.os.Message;
import android.util.Log;
import com.macroyau.blue2serial.BluetoothSerialListener;
import com.macroyau.blue2serial.BluetoothSerialRawListener;
import com.macroyau.blue2serial.SPPService;
import java.util.Set;

public class BluetoothSerial {
    private static final String TAG = "BluetoothSerial";
    public static final int STATE_DISCONNECTED = 0;
    public static final int STATE_CONNECTING = 1;
    public static final int STATE_CONNECTED = 2;
    protected static final int MESSAGE_STATE_CHANGE = 1;
    protected static final int MESSAGE_READ = 2;
    protected static final int MESSAGE_WRITE = 3;
    protected static final int MESSAGE_DEVICE_INFO = 4;
    protected static final String KEY_DEVICE_NAME = "DEVICE_NAME";
    protected static final String KEY_DEVICE_ADDRESS = "DEVICE_ADDRESS";
    private static final byte[] CRLF = new byte[]{13, 10};
    private BluetoothAdapter mAdapter;
    private Set<BluetoothDevice> mPairedDevices;
    private BluetoothSerialListener mListener;
    private SPPService mService;
    private String mConnectedDeviceName;
    private String mConnectedDeviceAddress;
    private boolean isRaw;
    private final Handler mHandler = new Handler(){

        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    switch (msg.arg1) {
                        case 2: {
                            BluetoothSerial.this.mListener.onBluetoothDeviceConnected(BluetoothSerial.this.mConnectedDeviceName, BluetoothSerial.this.mConnectedDeviceAddress);
                            break;
                        }
                        case 1: {
                            BluetoothSerial.this.mListener.onConnectingBluetoothDevice();
                            break;
                        }
                        case 0: {
                            BluetoothSerial.this.mListener.onBluetoothDeviceDisconnected();
                        }
                    }
                    break;
                }
                case 3: {
                    byte[] bufferWrite = (byte[])msg.obj;
                    String messageWrite = new String(bufferWrite);
                    BluetoothSerial.this.mListener.onBluetoothSerialWrite(messageWrite);
                    if (!BluetoothSerial.this.isRaw) break;
                    ((BluetoothSerialRawListener)BluetoothSerial.this.mListener).onBluetoothSerialWriteRaw(bufferWrite);
                    break;
                }
                case 2: {
                    byte[] bufferRead = (byte[])msg.obj;
                    BluetoothSerial.this.mListener.onBluetoothSerialRead(bufferRead);
                    if (!BluetoothSerial.this.isRaw) break;
                    ((BluetoothSerialRawListener)BluetoothSerial.this.mListener).onBluetoothSerialReadRaw(bufferRead);
                    break;
                }
                case 4: {
                    BluetoothSerial.this.mConnectedDeviceName = msg.getData().getString(BluetoothSerial.KEY_DEVICE_NAME);
                    BluetoothSerial.this.mConnectedDeviceAddress = msg.getData().getString(BluetoothSerial.KEY_DEVICE_ADDRESS);
                }
            }
        }
    };

    public BluetoothSerial(Context context, BluetoothSerialListener listener) {
        this.mAdapter = BluetoothSerial.getAdapter(context);
        this.mListener = listener;
        this.isRaw = this.mListener instanceof BluetoothSerialRawListener;
    }

    public static BluetoothAdapter getAdapter(Context context) {
        BluetoothAdapter bluetoothAdapter = null;
        if (Build.VERSION.SDK_INT >= 18) {
            BluetoothManager bluetoothManager = (BluetoothManager)context.getSystemService("bluetooth");
            if (bluetoothManager != null) {
                bluetoothAdapter = bluetoothManager.getAdapter();
            }
        } else {
            bluetoothAdapter = BluetoothAdapter.getDefaultAdapter();
        }
        return bluetoothAdapter;
    }

    public void setup() {
        if (this.checkBluetooth()) {
            this.mPairedDevices = this.mAdapter.getBondedDevices();
            this.mService = new SPPService(this.mHandler);
        }
    }

    public boolean isBluetoothEnabled() {
        return this.mAdapter.isEnabled();
    }

    public boolean checkBluetooth() {
        if (this.mAdapter == null) {
            this.mListener.onBluetoothNotSupported();
            return false;
        }
        if (!this.mAdapter.isEnabled()) {
            this.mListener.onBluetoothDisabled();
            return false;
        }
        return true;
    }

    public void start() {
        if (this.mService != null && this.mService.getState() == 0) {
            this.mService.start();
        }
    }

    public void connect(String address) {
        BluetoothDevice device = null;
        try {
            device = this.mAdapter.getRemoteDevice(address);
        }
        catch (IllegalArgumentException e) {
            Log.e((String)TAG, (String)"Device not found!");
        }
        if (device != null) {
            this.connect(device);
        }
    }

    public void connect(BluetoothDevice device) {
        if (this.mService != null) {
            this.mService.connect(device);
        }
    }

    public void connectServer() {
        if (this.mService != null) {
            this.mService.connect(this.mAdapter);
        }
    }

    public void write(byte[] data) {
        if (this.mService.getState() == 2) {
            this.mService.write(data);
        }
    }

    public void write(byte[] data, int offset, int len) {
        if (this.mService.getState() == 2) {
            this.mService.write(data, offset, len);
        }
    }

    public void write(String data, boolean crlf) {
        this.write(data.getBytes());
        if (crlf) {
            this.write(CRLF);
        }
    }

    public void write(String data) {
        this.write(data.getBytes());
    }

    public void writeln(String data) {
        this.write(data.getBytes());
        this.write(CRLF);
    }

    public void stop() {
        if (this.mService != null) {
            this.mService.stop();
        }
    }

    public int getState() {
        return this.mService.getState();
    }

    public boolean isConnected() {
        return this.mService.getState() == 2;
    }

    public String getConnectedDeviceName() {
        return this.mConnectedDeviceName;
    }

    public String getConnectedDeviceAddress() {
        return this.mConnectedDeviceAddress;
    }

    public Set<BluetoothDevice> getPairedDevices() {
        return this.mPairedDevices;
    }

    public String[] getPairedDevicesName() {
        if (this.mPairedDevices != null) {
            String[] name = new String[this.mPairedDevices.size()];
            int i = 0;
            for (BluetoothDevice d : this.mPairedDevices) {
                name[i] = d.getName();
                ++i;
            }
            return name;
        }
        return null;
    }

    public String[] getPairedDevicesAddress() {
        if (this.mPairedDevices != null) {
            String[] address = new String[this.mPairedDevices.size()];
            int i = 0;
            for (BluetoothDevice d : this.mPairedDevices) {
                address[i] = d.getAddress();
                ++i;
            }
            return address;
        }
        return null;
    }

    public String getLocalAdapterName() {
        return this.mAdapter.getName();
    }

    public String getLocalAdapterAddress() {
        return this.mAdapter.getAddress();
    }
}

