/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.glide.load.engine.cache;

import android.annotation.SuppressLint;
import com.hpplay.glide.load.Key;
import com.hpplay.glide.load.engine.Resource;
import com.hpplay.glide.load.engine.cache.MemoryCache;
import com.hpplay.glide.util.LruCache;

public class LruResourceCache
extends LruCache<Key, Resource<?>>
implements MemoryCache {
    private MemoryCache.ResourceRemovedListener listener;

    public LruResourceCache(int n2) {
        super(n2);
    }

    @Override
    public void setResourceRemovedListener(MemoryCache.ResourceRemovedListener resourceRemovedListener) {
        this.listener = resourceRemovedListener;
    }

    @Override
    protected void onItemEvicted(Key key, Resource<?> resource) {
        if (this.listener != null) {
            this.listener.onResourceRemoved(resource);
        }
    }

    @Override
    protected int getSize(Resource<?> resource) {
        return resource.getSize();
    }

    @Override
    @SuppressLint(value={"InlinedApi"})
    public void trimMemory(int n2) {
        if (n2 >= 60) {
            this.clearMemory();
        } else if (n2 >= 40) {
            this.trimToSize(this.getCurrentSize() / 2);
        }
    }
}

