/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.glide.load.data;

import java.io.FilterInputStream;
import java.io.InputStream;

public class ExifOrientationStream
extends FilterInputStream {
    private static final int SEGMENT_START_POSITION = 2;
    private static final byte[] EXIF_SEGMENT = new byte[]{-1, -31, 0, 28, 69, 120, 105, 102, 0, 0, 77, 77, 0, 0, 0, 0, 0, 8, 0, 1, 1, 18, 0, 2, 0, 0, 0, 1, 0};
    private static final int SEGMENT_LENGTH = EXIF_SEGMENT.length;
    private static final int ORIENTATION_POSITION = SEGMENT_LENGTH + 2;
    private final byte orientation;
    private int position;

    public ExifOrientationStream(InputStream inputStream, int n2) {
        super(inputStream);
        if (n2 < -1 || n2 > 8) {
            throw new IllegalArgumentException("Cannot add invalid orientation: " + n2);
        }
        this.orientation = (byte)n2;
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public void mark(int n2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int read() {
        int n2 = this.position < 2 || this.position > ORIENTATION_POSITION ? super.read() : (this.position == ORIENTATION_POSITION ? (int)this.orientation : EXIF_SEGMENT[this.position - 2] & 0xFF);
        if (n2 != -1) {
            ++this.position;
        }
        return n2;
    }

    @Override
    public int read(byte[] byArray, int n2, int n3) {
        int n4;
        if (this.position > ORIENTATION_POSITION) {
            n4 = super.read(byArray, n2, n3);
        } else if (this.position == ORIENTATION_POSITION) {
            byArray[n2] = this.orientation;
            n4 = 1;
        } else if (this.position < 2) {
            n4 = super.read(byArray, n2, 2 - this.position);
        } else {
            n4 = Math.min(ORIENTATION_POSITION - this.position, n3);
            System.arraycopy(EXIF_SEGMENT, this.position - 2, byArray, n2, n4);
        }
        if (n4 > 0) {
            this.position += n4;
        }
        return n4;
    }

    @Override
    public long skip(long l2) {
        long l3 = super.skip(l2);
        if (l3 > 0L) {
            this.position = (int)((long)this.position + l3);
        }
        return l3;
    }

    @Override
    public void reset() {
        throw new UnsupportedOperationException();
    }
}

