/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.common.utils;

import android.text.TextUtils;
import android.util.Base64;
import com.hpplay.common.log.LeLog;
import java.security.MessageDigest;

public class EncryptUtil {
    private static final String TAG = "EncryptUtil";
    private static final char[] HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    private EncryptUtil() {
        throw new UnsupportedOperationException("u can't instantiate me...");
    }

    public static int fnvHash(String string) {
        int n2 = 16777619;
        int n3 = -2128831035;
        for (int i2 = 0; i2 < string.length(); ++i2) {
            n3 = (n3 ^ string.charAt(i2)) * 16777619;
        }
        n3 += n3 << 13;
        n3 ^= n3 >> 7;
        n3 += n3 << 3;
        n3 ^= n3 >> 17;
        n3 += n3 << 5;
        return n3;
    }

    public static long parseMd5L16ToLong(String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            LeLog.e(TAG, "parseMd5L16ToLong error, invalid input");
            return -1L;
        }
        string = string.toLowerCase();
        byte[] byArray = string.getBytes();
        long l2 = 0L;
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            l2 <<= 4;
            byte by = (byte)(byArray[i2] - 48);
            if (by > 9) {
                by = (byte)(by - 39);
            }
            if (by > 15 || by < 0) {
                LeLog.e(TAG, "parseMd5L16ToLong error,For input string: " + string);
                return -1L;
            }
            l2 += (long)by;
        }
        return l2;
    }

    public static String md5EncryData16(String string) {
        String string2 = EncryptUtil.md5EncryData(string);
        if (string2.length() >= 24) {
            return string2.substring(8, 24);
        }
        return "";
    }

    public static String md5EncryData(String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return "";
        }
        MessageDigest messageDigest = null;
        try {
            messageDigest = MessageDigest.getInstance("MD5");
            byte[] byArray = messageDigest.digest(string.getBytes());
            String string2 = "";
            for (byte by : byArray) {
                String string3 = Integer.toHexString(by & 0xFF);
                if (string3.length() == 1) {
                    string3 = "0" + string3;
                }
                string2 = string2 + string3;
            }
            return string2;
        }
        catch (Exception exception) {
            LeLog.w(TAG, exception);
            return "";
        }
    }

    public static String encryptMD5ToString(String string) {
        if (string == null || string.length() == 0) {
            return "";
        }
        return EncryptUtil.encryptMD5ToString(string.getBytes());
    }

    public static String encryptMD5ToString(byte[] byArray) {
        return EncryptUtil.bytes2HexString(EncryptUtil.encryptMD5(byArray));
    }

    public static byte[] encryptMD5(byte[] byArray) {
        return EncryptUtil.hashTemplate(byArray, "MD5");
    }

    public static String encryptSHA256ToString(String string) {
        if (string == null || string.length() == 0) {
            return "";
        }
        return EncryptUtil.encryptSHA256ToString(string.getBytes());
    }

    public static String encryptSHA256ToString(byte[] byArray) {
        return EncryptUtil.bytes2HexString(EncryptUtil.encryptSHA256(byArray));
    }

    public static byte[] encryptSHA256(byte[] byArray) {
        return EncryptUtil.hashTemplate(byArray, "SHA-256");
    }

    private static byte[] hashTemplate(byte[] byArray, String string) {
        if (byArray == null || byArray.length <= 0) {
            return null;
        }
        try {
            MessageDigest messageDigest = MessageDigest.getInstance(string);
            messageDigest.update(byArray);
            return messageDigest.digest();
        }
        catch (Exception exception) {
            LeLog.w(TAG, exception);
            return null;
        }
    }

    private static String bytes2HexString(byte[] byArray) {
        if (byArray == null) {
            return "";
        }
        int n2 = byArray.length;
        if (n2 <= 0) {
            return "";
        }
        char[] cArray = new char[n2 << 1];
        int n3 = 0;
        for (int i2 = 0; i2 < n2; ++i2) {
            cArray[n3++] = HEX_DIGITS[byArray[i2] >> 4 & 0xF];
            cArray[n3++] = HEX_DIGITS[byArray[i2] & 0xF];
        }
        return new String(cArray);
    }

    private static byte[] hexString2Bytes(String string) {
        if (EncryptUtil.isSpace(string)) {
            return null;
        }
        int n2 = string.length();
        if (n2 % 2 != 0) {
            string = "0" + string;
            ++n2;
        }
        char[] cArray = string.toUpperCase().toCharArray();
        byte[] byArray = new byte[n2 >> 1];
        for (int i2 = 0; i2 < n2; i2 += 2) {
            byArray[i2 >> 1] = (byte)(EncryptUtil.hex2Dec(cArray[i2]) << 4 | EncryptUtil.hex2Dec(cArray[i2 + 1]));
        }
        return byArray;
    }

    private static int hex2Dec(char c2) {
        if (c2 >= '0' && c2 <= '9') {
            return c2 - 48;
        }
        if (c2 >= 'A' && c2 <= 'F') {
            return c2 - 65 + 10;
        }
        throw new IllegalArgumentException();
    }

    private static byte[] base64Encode(byte[] byArray) {
        return Base64.encode((byte[])byArray, (int)2);
    }

    private static byte[] base64Decode(byte[] byArray) {
        return Base64.decode((byte[])byArray, (int)2);
    }

    private static boolean isSpace(String string) {
        if (string == null) {
            return true;
        }
        int n2 = string.length();
        for (int i2 = 0; i2 < n2; ++i2) {
            if (Character.isWhitespace(string.charAt(i2))) continue;
            return false;
        }
        return true;
    }
}

