/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.glide.request.animation;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.view.animation.AlphaAnimation;
import android.view.animation.Animation;
import com.hpplay.glide.request.animation.DrawableCrossFadeViewAnimation;
import com.hpplay.glide.request.animation.GlideAnimation;
import com.hpplay.glide.request.animation.GlideAnimationFactory;
import com.hpplay.glide.request.animation.NoAnimation;
import com.hpplay.glide.request.animation.ViewAnimation;
import com.hpplay.glide.request.animation.ViewAnimationFactory;

public class DrawableCrossFadeFactory<T extends Drawable>
implements GlideAnimationFactory<T> {
    private static final int DEFAULT_DURATION_MS = 300;
    private final ViewAnimationFactory<T> animationFactory;
    private final int duration;
    private DrawableCrossFadeViewAnimation<T> firstResourceAnimation;
    private DrawableCrossFadeViewAnimation<T> secondResourceAnimation;

    public DrawableCrossFadeFactory() {
        this(300);
    }

    public DrawableCrossFadeFactory(int n2) {
        this(new ViewAnimationFactory(new DefaultAnimationFactory(n2)), n2);
    }

    public DrawableCrossFadeFactory(Context context, int n2, int n3) {
        this(new ViewAnimationFactory(context, n2), n3);
    }

    public DrawableCrossFadeFactory(Animation animation, int n2) {
        this(new ViewAnimationFactory(animation), n2);
    }

    DrawableCrossFadeFactory(ViewAnimationFactory<T> viewAnimationFactory, int n2) {
        this.animationFactory = viewAnimationFactory;
        this.duration = n2;
    }

    @Override
    public GlideAnimation<T> build(boolean bl, boolean bl2) {
        if (bl) {
            return NoAnimation.get();
        }
        if (bl2) {
            return this.getFirstResourceAnimation();
        }
        return this.getSecondResourceAnimation();
    }

    private GlideAnimation<T> getFirstResourceAnimation() {
        if (this.firstResourceAnimation == null) {
            GlideAnimation<T> glideAnimation = this.animationFactory.build(false, true);
            this.firstResourceAnimation = new DrawableCrossFadeViewAnimation<T>(glideAnimation, this.duration);
        }
        return this.firstResourceAnimation;
    }

    private GlideAnimation<T> getSecondResourceAnimation() {
        if (this.secondResourceAnimation == null) {
            GlideAnimation<T> glideAnimation = this.animationFactory.build(false, false);
            this.secondResourceAnimation = new DrawableCrossFadeViewAnimation<T>(glideAnimation, this.duration);
        }
        return this.secondResourceAnimation;
    }

    private static class DefaultAnimationFactory
    implements ViewAnimation.AnimationFactory {
        private final int duration;

        DefaultAnimationFactory(int n2) {
            this.duration = n2;
        }

        @Override
        public Animation build() {
            AlphaAnimation alphaAnimation = new AlphaAnimation(0.0f, 1.0f);
            alphaAnimation.setDuration((long)this.duration);
            return alphaAnimation;
        }
    }
}

