/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.sdk.source.process;

import android.content.Context;
import android.net.wifi.ScanResult;
import android.net.wifi.WifiManager;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import com.hpplay.sdk.source.bean.BrowserTypeBean;
import com.hpplay.sdk.source.browse.api.LelinkServiceInfo;
import com.hpplay.sdk.source.browse.data.BrowserInfo;
import com.hpplay.sdk.source.business.cloud.SDKConfig;
import com.hpplay.sdk.source.business.cloud.SourceDataReport;
import com.hpplay.sdk.source.log.SourceLog;
import com.hpplay.sdk.source.process.LelinkSdkManager;
import com.hpplay.sdk.source.protocol.browser.BrowserHistory;
import com.hpplay.sdk.source.utils.CastUtil;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;

public class RelationReportTask {
    private static final String TAG = "RelationReportTask";
    private static RelationReportTask sInstance = null;
    private static final int WHAT_REPORT = 1;
    private long mStartTimeStamp = -1L;
    private long mStopTimeStamp = -1L;
    private boolean isReport = false;
    private Handler mHandler = new Handler(Looper.getMainLooper(), new Handler.Callback(){

        public boolean handleMessage(Message message) {
            switch (message.what) {
                case 1: {
                    try {
                        RelationReportTask.this.reportRelation((Context)message.obj);
                        break;
                    }
                    catch (Exception exception) {
                        SourceLog.w(RelationReportTask.TAG, exception);
                    }
                }
            }
            return false;
        }
    });

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized RelationReportTask getInstance() {
        Class<RelationReportTask> clazz = RelationReportTask.class;
        synchronized (RelationReportTask.class) {
            if (sInstance == null) {
                sInstance = new RelationReportTask();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return sInstance;
        }
    }

    private RelationReportTask() {
    }

    public void report(Context context, long l2, long l3, long l4) {
        if (this.isReport || this.mHandler == null) {
            return;
        }
        if (SDKConfig.getInstance().getSearchEnable() != 1) {
            SourceLog.w(TAG, "relation ignore");
            return;
        }
        this.mStartTimeStamp = l2;
        this.mStopTimeStamp = l3;
        this.mHandler.removeMessages(1);
        this.mHandler.sendMessageDelayed(this.mHandler.obtainMessage(1, (Object)context), l4);
    }

    public void reportSinkDevice(long l2, String string) {
        SourceDataReport.getInstance().relation(this.mStartTimeStamp, l2, null, null, null, null, string);
    }

    private void reportRelation(Context context) {
        Object object;
        this.isReport = true;
        List<LelinkServiceInfo> list = LelinkSdkManager.getInstance().getBrowserList();
        if (list == null || list.isEmpty()) {
            SourceDataReport.getInstance().relation(this.mStartTimeStamp, this.mStopTimeStamp, "", "", "", this.getScanTypes());
            return;
        }
        StringBuilder stringBuilder = new StringBuilder();
        StringBuilder stringBuilder2 = new StringBuilder();
        for (LelinkServiceInfo object22 : list) {
            BrowserInfo browserInfo;
            object = CastUtil.getBrowserInfo(object22, 1);
            if (object != null) {
                stringBuilder.append(((BrowserInfo)object).getUid()).append(",");
            }
            if ((browserInfo = CastUtil.getBrowserInfo(object22, 3)) == null) continue;
            String string = browserInfo.getExtras().get("manufacturer");
            String string2 = browserInfo.getName();
            stringBuilder2.append(string).append("|").append(string2).append("|").append(System.currentTimeMillis()).append(",");
        }
        Object object3 = stringBuilder2.toString();
        if (((String)object3).endsWith(",")) {
            object3 = ((String)object3).substring(0, ((String)object3).length() - 1);
        }
        String string = this.getScanBody(list);
        SourceLog.debug(TAG, "reportRelation s:" + string);
        object = RelationReportTask.getWifiScanResults(context);
        SourceLog.debug(TAG, "reportRelation w:" + (String)object);
        SourceDataReport.getInstance().relation(this.mStartTimeStamp, this.mStopTimeStamp, (String)object3, string, (String)object, this.getScanTypes());
    }

    private String getScanTypes() {
        StringBuilder stringBuilder = new StringBuilder();
        BrowserHistory browserHistory = BrowserHistory.getInstance();
        if (browserHistory.isUseMdns()) {
            stringBuilder.append("1,");
        }
        if (browserHistory.isUseUPnP()) {
            stringBuilder.append("2,");
        }
        if (browserHistory.isUseQR()) {
            stringBuilder.append("3,");
        }
        if (browserHistory.isUsePinCode()) {
            stringBuilder.append("4,");
        }
        if (browserHistory.isUseSonic()) {
            stringBuilder.append("5,");
        }
        if (browserHistory.isUseBLE()) {
            stringBuilder.append("6,");
        }
        return stringBuilder.toString();
    }

    private String getScanBody(List<LelinkServiceInfo> list) {
        JSONArray jSONArray = new JSONArray();
        for (LelinkServiceInfo lelinkServiceInfo : list) {
            BrowserTypeBean browserTypeBean;
            if (lelinkServiceInfo == null || (browserTypeBean = BrowserHistory.getInstance().getBrowserTypeBean(lelinkServiceInfo.getName())) == null) continue;
            try {
                JSONObject jSONObject;
                if (browserTypeBean.isMDns) {
                    jSONObject = new JSONObject();
                    jSONObject.put("uid", (Object)lelinkServiceInfo.getUid());
                    jSONObject.put("pt", 1);
                    jSONObject.put("mt", browserTypeBean.mDnsTime);
                    jSONObject.put("wmt", 0);
                    jSONArray.put((Object)jSONObject);
                }
                if (browserTypeBean.isUPnP) {
                    jSONObject = new JSONObject();
                    BrowserInfo browserInfo = CastUtil.getBrowserInfo(lelinkServiceInfo, 3);
                    if (browserInfo != null) {
                        jSONObject.put("uid", (Object)browserInfo.getExtras().get("dln_UUID"));
                        jSONObject.put("pt", 2);
                        jSONObject.put("mt", browserTypeBean.UPnPTime);
                        jSONObject.put("wmt", 0);
                    }
                    jSONArray.put((Object)jSONObject);
                }
                if (browserTypeBean.isQRCode) {
                    jSONObject = new JSONObject();
                    jSONObject.put("uid", (Object)lelinkServiceInfo.getUid());
                    jSONObject.put("pt", 3);
                    jSONObject.put("mt", browserTypeBean.qrCodeCloudTime);
                    jSONObject.put("wmt", browserTypeBean.qrCodeCloudTime);
                    jSONArray.put((Object)jSONObject);
                }
                if (browserTypeBean.isPinCode) {
                    jSONObject = new JSONObject();
                    jSONObject.put("uid", (Object)lelinkServiceInfo.getUid());
                    jSONObject.put("pt", 4);
                    jSONObject.put("mt", browserTypeBean.pinCodeCloudTime);
                    jSONObject.put("wmt", browserTypeBean.pinCodeCloudTime);
                    jSONArray.put((Object)jSONObject);
                }
                if (browserTypeBean.isSonic) {
                    jSONObject = new JSONObject();
                    jSONObject.put("uid", (Object)lelinkServiceInfo.getUid());
                    jSONObject.put("pt", 5);
                    jSONObject.put("mt", browserTypeBean.sonicTime);
                    jSONObject.put("wmt", browserTypeBean.sonicCloudTime);
                    jSONArray.put((Object)jSONObject);
                }
                if (!browserTypeBean.isBle) continue;
                jSONObject = new JSONObject();
                jSONObject.put("uid", (Object)lelinkServiceInfo.getUid());
                jSONObject.put("pt", 6);
                jSONObject.put("mt", browserTypeBean.bleTime);
                jSONObject.put("wmt", browserTypeBean.bleCloudTime);
                jSONArray.put((Object)jSONObject);
            }
            catch (Exception exception) {}
        }
        return jSONArray.toString();
    }

    public static String getWifiScanResults(Context context) {
        WifiManager wifiManager = (WifiManager)context.getSystemService("wifi");
        if (wifiManager != null) {
            List list = wifiManager.getScanResults();
            if (list == null || list.size() == 0) {
                SourceLog.i(TAG, "the wifi result is null");
                return null;
            }
            JSONArray jSONArray = new JSONArray();
            for (int i2 = 0; i2 < list.size(); ++i2) {
                ScanResult scanResult = (ScanResult)list.get(i2);
                if (scanResult == null) continue;
                try {
                    JSONObject jSONObject = new JSONObject();
                    jSONObject.put("bid", (Object)scanResult.BSSID);
                    jSONObject.put("wn", (Object)scanResult.SSID);
                    jSONObject.put("wr", scanResult.level);
                    jSONObject.put("wlt", (Object)(System.currentTimeMillis() + ""));
                    jSONArray.put((Object)jSONObject);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return jSONArray.toString();
        }
        return null;
    }

    public void clear() {
        this.isReport = false;
    }

    public void stopBrowser() {
        if (this.mHandler != null) {
            this.mHandler.removeMessages(1);
        }
    }

    private void release() {
        if (this.mHandler != null) {
            this.mHandler.removeMessages(1);
        }
        this.mHandler = null;
    }

    public static void unInit() {
        if (sInstance == null) {
            return;
        }
        sInstance.release();
        sInstance = null;
    }
}

