/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.sdk.source.mdns.xbill.dns;

import com.hpplay.sdk.source.mdns.xbill.dns.CNAMERecord;
import com.hpplay.sdk.source.mdns.xbill.dns.Cache;
import com.hpplay.sdk.source.mdns.xbill.dns.DClass;
import com.hpplay.sdk.source.mdns.xbill.dns.DNAMERecord;
import com.hpplay.sdk.source.mdns.xbill.dns.ExtendedResolver;
import com.hpplay.sdk.source.mdns.xbill.dns.Message;
import com.hpplay.sdk.source.mdns.xbill.dns.Mnemonic;
import com.hpplay.sdk.source.mdns.xbill.dns.Name;
import com.hpplay.sdk.source.mdns.xbill.dns.Options;
import com.hpplay.sdk.source.mdns.xbill.dns.RRset;
import com.hpplay.sdk.source.mdns.xbill.dns.Rcode;
import com.hpplay.sdk.source.mdns.xbill.dns.Record;
import com.hpplay.sdk.source.mdns.xbill.dns.Resolver;
import com.hpplay.sdk.source.mdns.xbill.dns.ResolverConfig;
import com.hpplay.sdk.source.mdns.xbill.dns.SetResponse;
import com.hpplay.sdk.source.mdns.xbill.dns.Type;
import java.io.InterruptedIOException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public final class Lookup {
    private static Resolver defaultResolver;
    private static Name[] defaultSearchPath;
    private static Map defaultCaches;
    private static int defaultNdots;
    private Resolver resolver;
    private Name[] searchPath;
    private Cache cache;
    private boolean temporary_cache;
    private int credibility;
    private Name name;
    private int type;
    private int dclass;
    private boolean verbose;
    private int iterations;
    private boolean foundAlias;
    private boolean done;
    private boolean doneCurrent;
    private List aliases;
    private Record[] answers;
    private int result;
    private String error;
    private boolean nxdomain;
    private boolean badresponse;
    private String badresponse_error;
    private boolean networkerror;
    private boolean timedout;
    private boolean nametoolong;
    private boolean referral;
    private static final Name[] noAliases;
    public static final int SUCCESSFUL = 0;
    public static final int UNRECOVERABLE = 1;
    public static final int TRY_AGAIN = 2;
    public static final int HOST_NOT_FOUND = 3;
    public static final int TYPE_NOT_FOUND = 4;

    public static synchronized void refreshDefault() {
        try {
            defaultResolver = new ExtendedResolver();
        }
        catch (UnknownHostException unknownHostException) {
            throw new RuntimeException("Failed to initialize resolver");
        }
        defaultSearchPath = ResolverConfig.getCurrentConfig().searchPath();
        defaultCaches = new HashMap();
        defaultNdots = ResolverConfig.getCurrentConfig().ndots();
    }

    public static synchronized Resolver getDefaultResolver() {
        return defaultResolver;
    }

    public static synchronized void setDefaultResolver(Resolver resolver) {
        defaultResolver = resolver;
    }

    public static synchronized Cache getDefaultCache(int n2) {
        DClass.check(n2);
        Cache cache = (Cache)defaultCaches.get(Mnemonic.toInteger(n2));
        if (cache == null) {
            cache = new Cache(n2);
            defaultCaches.put(Mnemonic.toInteger(n2), cache);
        }
        return cache;
    }

    public static synchronized void setDefaultCache(Cache cache, int n2) {
        DClass.check(n2);
        defaultCaches.put(Mnemonic.toInteger(n2), cache);
    }

    public static synchronized Name[] getDefaultSearchPath() {
        return defaultSearchPath;
    }

    public static synchronized void setDefaultSearchPath(Name[] nameArray) {
        defaultSearchPath = nameArray;
    }

    public static synchronized void setDefaultSearchPath(String[] stringArray) {
        if (stringArray == null) {
            defaultSearchPath = null;
            return;
        }
        Name[] nameArray = new Name[stringArray.length];
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            nameArray[i2] = Name.fromString(stringArray[i2], Name.root);
        }
        defaultSearchPath = nameArray;
    }

    private final void reset() {
        this.iterations = 0;
        this.foundAlias = false;
        this.done = false;
        this.doneCurrent = false;
        this.aliases = null;
        this.answers = null;
        this.result = -1;
        this.error = null;
        this.nxdomain = false;
        this.badresponse = false;
        this.badresponse_error = null;
        this.networkerror = false;
        this.timedout = false;
        this.nametoolong = false;
        this.referral = false;
        if (this.temporary_cache) {
            this.cache.clearCache();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Lookup(Name name, int n2, int n3) {
        Type.check(n2);
        DClass.check(n3);
        if (!Type.isRR(n2) && n2 != 255) {
            throw new IllegalArgumentException("Cannot query for meta-types other than ANY");
        }
        this.name = name;
        this.type = n2;
        this.dclass = n3;
        Class<Lookup> clazz = Lookup.class;
        synchronized (Lookup.class) {
            this.resolver = Lookup.getDefaultResolver();
            this.searchPath = Lookup.getDefaultSearchPath();
            this.cache = Lookup.getDefaultCache(n3);
            // ** MonitorExit[var4_4] (shouldn't be in output)
            this.credibility = 3;
            this.verbose = Options.check("verbose");
            this.result = -1;
            return;
        }
    }

    public Lookup(Name name, int n2) {
        this(name, n2, 1);
    }

    public Lookup(Name name) {
        this(name, 1, 1);
    }

    public Lookup(String string, int n2, int n3) {
        this(Name.fromString(string), n2, n3);
    }

    public Lookup(String string, int n2) {
        this(Name.fromString(string), n2, 1);
    }

    public Lookup(String string) {
        this(Name.fromString(string), 1, 1);
    }

    public void setResolver(Resolver resolver) {
        this.resolver = resolver;
    }

    public void setSearchPath(Name[] nameArray) {
        this.searchPath = nameArray;
    }

    public void setSearchPath(String[] stringArray) {
        if (stringArray == null) {
            this.searchPath = null;
            return;
        }
        Name[] nameArray = new Name[stringArray.length];
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            nameArray[i2] = Name.fromString(stringArray[i2], Name.root);
        }
        this.searchPath = nameArray;
    }

    public void setCache(Cache cache) {
        if (cache == null) {
            this.cache = new Cache(this.dclass);
            this.temporary_cache = true;
        } else {
            this.cache = cache;
            this.temporary_cache = false;
        }
    }

    public void setNdots(int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("Illegal ndots value: " + n2);
        }
        defaultNdots = n2;
    }

    public void setCredibility(int n2) {
        this.credibility = n2;
    }

    private void follow(Name name, Name name2) {
        this.foundAlias = true;
        this.badresponse = false;
        this.networkerror = false;
        this.timedout = false;
        this.nxdomain = false;
        this.referral = false;
        ++this.iterations;
        if (this.iterations >= 6 || name.equals(name2)) {
            this.result = 1;
            this.error = "CNAME loop";
            this.done = true;
            return;
        }
        if (this.aliases == null) {
            this.aliases = new ArrayList();
        }
        this.aliases.add(name2);
        this.lookup(name);
    }

    private void processResponse(Name name, SetResponse setResponse) {
        if (setResponse.isSuccessful()) {
            RRset[] rRsetArray = setResponse.answers();
            ArrayList arrayList = new ArrayList();
            for (int i2 = 0; i2 < rRsetArray.length; ++i2) {
                Iterator iterator = rRsetArray[i2].rrs();
                while (iterator.hasNext()) {
                    arrayList.add(iterator.next());
                }
            }
            this.result = 0;
            this.answers = arrayList.toArray(new Record[arrayList.size()]);
            this.done = true;
        } else if (setResponse.isNXDOMAIN()) {
            this.nxdomain = true;
            this.doneCurrent = true;
            if (this.iterations > 0) {
                this.result = 3;
                this.done = true;
            }
        } else if (setResponse.isNXRRSET()) {
            this.result = 4;
            this.answers = null;
            this.done = true;
        } else if (setResponse.isCNAME()) {
            CNAMERecord cNAMERecord = setResponse.getCNAME();
            this.follow(cNAMERecord.getTarget(), name);
        } else if (setResponse.isDNAME()) {
            DNAMERecord dNAMERecord = setResponse.getDNAME();
            try {
                this.follow(name.fromDNAME(dNAMERecord), name);
            }
            catch (Exception exception) {
                this.result = 1;
                this.error = "Invalid DNAME target";
                this.done = true;
            }
        } else if (setResponse.isDelegation()) {
            this.referral = true;
        }
    }

    private void lookup(Name name) {
        SetResponse setResponse = this.cache.lookupRecords(name, this.type, this.credibility);
        if (this.verbose) {
            System.err.println("lookup " + name + " " + Type.string(this.type));
            System.err.println(setResponse);
        }
        this.processResponse(name, setResponse);
        if (this.done || this.doneCurrent) {
            return;
        }
        Record record = Record.newRecord(name, this.type, this.dclass);
        Message message = Message.newQuery(record);
        Message message2 = null;
        try {
            message2 = this.resolver.send(message);
        }
        catch (Exception exception) {
            if (exception instanceof InterruptedIOException) {
                this.timedout = true;
            } else {
                this.networkerror = true;
            }
            return;
        }
        int n2 = message2.getHeader().getRcode();
        if (n2 != 0 && n2 != 3) {
            this.badresponse = true;
            this.badresponse_error = Rcode.string(n2);
            return;
        }
        if (!message.getQuestion().equals(message2.getQuestion())) {
            this.badresponse = true;
            this.badresponse_error = "response does not match query";
            return;
        }
        setResponse = this.cache.addMessage(message2);
        if (setResponse == null) {
            setResponse = this.cache.lookupRecords(name, this.type, this.credibility);
        }
        if (this.verbose) {
            System.err.println("queried " + name + " " + Type.string(this.type));
            System.err.println(setResponse);
        }
        this.processResponse(name, setResponse);
    }

    private void resolve(Name name, Name name2) {
        this.doneCurrent = false;
        Name name3 = null;
        if (name2 == null) {
            name3 = name;
        } else {
            try {
                name3 = Name.concatenate(name, name2);
            }
            catch (Exception exception) {
                this.nametoolong = true;
                return;
            }
        }
        this.lookup(name3);
    }

    public Record[] run() {
        if (this.done) {
            this.reset();
        }
        if (this.name.isAbsolute()) {
            this.resolve(this.name, null);
        } else if (this.searchPath == null) {
            this.resolve(this.name, Name.root);
        } else {
            if (this.name.labels() > defaultNdots) {
                this.resolve(this.name, Name.root);
            }
            if (this.done) {
                return this.answers;
            }
            for (int i2 = 0; i2 < this.searchPath.length; ++i2) {
                this.resolve(this.name, this.searchPath[i2]);
                if (this.done) {
                    return this.answers;
                }
                if (this.foundAlias) break;
            }
        }
        if (!this.done) {
            if (this.badresponse) {
                this.result = 2;
                this.error = this.badresponse_error;
                this.done = true;
            } else if (this.timedout) {
                this.result = 2;
                this.error = "timed out";
                this.done = true;
            } else if (this.networkerror) {
                this.result = 2;
                this.error = "network error";
                this.done = true;
            } else if (this.nxdomain) {
                this.result = 3;
                this.done = true;
            } else if (this.referral) {
                this.result = 1;
                this.error = "referral";
                this.done = true;
            } else if (this.nametoolong) {
                this.result = 1;
                this.error = "name too long";
                this.done = true;
            }
        }
        return this.answers;
    }

    private void checkDone() {
        if (this.done && this.result != -1) {
            return;
        }
        StringBuffer stringBuffer = new StringBuffer("Lookup of " + this.name + " ");
        if (this.dclass != 1) {
            stringBuffer.append(DClass.string(this.dclass) + " ");
        }
        stringBuffer.append(Type.string(this.type) + " isn't done");
        throw new IllegalStateException(stringBuffer.toString());
    }

    public Record[] getAnswers() {
        this.checkDone();
        return this.answers;
    }

    public Name[] getAliases() {
        this.checkDone();
        if (this.aliases == null) {
            return noAliases;
        }
        return this.aliases.toArray(new Name[this.aliases.size()]);
    }

    public int getResult() {
        this.checkDone();
        return this.result;
    }

    public String getErrorString() {
        this.checkDone();
        if (this.error != null) {
            return this.error;
        }
        switch (this.result) {
            case 0: {
                return "successful";
            }
            case 1: {
                return "unrecoverable error";
            }
            case 2: {
                return "try again";
            }
            case 3: {
                return "host not found";
            }
            case 4: {
                return "type not found";
            }
        }
        throw new IllegalStateException("unknown result");
    }

    static {
        noAliases = new Name[0];
        Lookup.refreshDefault();
    }
}

