/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.sdk.source.utils;

import android.content.Context;
import android.net.wifi.WifiManager;
import android.text.TextUtils;
import com.hpplay.common.utils.EncryptUtil;
import com.hpplay.sdk.source.common.store.Session;
import com.hpplay.sdk.source.log.SourceLog;
import com.hpplay.sdk.source.utils.JSONUtil;
import java.lang.reflect.Method;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class HpplayUtil {
    private static final String TAG = "CastUtil";

    public static String secToTime(long l2) {
        String string;
        if (l2 <= 0L) {
            return "00:00:00";
        }
        int n2 = (int)(l2 / 60L);
        if (n2 < 60) {
            int n3 = (int)(l2 % 60L);
            string = "00:" + HpplayUtil.unitFormat(n2) + ":" + HpplayUtil.unitFormat(n3);
        } else {
            int n4 = n2 / 60;
            if (n4 > 99) {
                return "99:59:59";
            }
            int n5 = (int)(l2 - (long)(n4 * 3600) - (long)((n2 %= 60) * 60));
            string = HpplayUtil.unitFormat(n4) + ":" + HpplayUtil.unitFormat(n2) + ":" + HpplayUtil.unitFormat(n5);
        }
        return string;
    }

    public static String unitFormat(int n2) {
        String string = n2 >= 0 && n2 < 10 ? "0" + n2 : "" + n2;
        return string;
    }

    public static String getVipAuthInfoSign(Context context, String string, String string2) {
        if (context != null && !TextUtils.isEmpty((CharSequence)string2)) {
            try {
                String string3;
                JSONObject jSONObject = new JSONObject(string2);
                JSONObject jSONObject2 = jSONObject.optJSONObject("data");
                JSONArray jSONArray = jSONObject2.optJSONArray("authinfo");
                if (jSONArray != null && jSONArray.length() > 0 && !TextUtils.isEmpty((CharSequence)(string3 = (jSONArray = JSONUtil.getSortJsonArray(jSONArray, false)).toString()))) {
                    String string4 = string3 + context.getPackageName() + string + Session.getInstance().appSecret;
                    return EncryptUtil.md5EncryData(string4);
                }
            }
            catch (JSONException jSONException) {
                SourceLog.w(TAG, "getVipAuthInfoSign JSONException: " + (Object)((Object)jSONException));
            }
        }
        return "";
    }

    public static String getVipAuthInfoLeBoSign(Context context, String string, String string2) {
        if (context != null && !TextUtils.isEmpty((CharSequence)string2)) {
            try {
                JSONObject jSONObject = new JSONObject(string2);
                JSONObject jSONObject2 = jSONObject.optJSONObject("data");
                JSONArray jSONArray = jSONObject2.optJSONArray("authinfo");
                if (jSONArray != null && jSONArray.length() > 0) {
                    String string3;
                    jSONArray = JSONUtil.getSortJsonArray(jSONArray, true);
                    int n2 = jSONArray.length();
                    StringBuilder stringBuilder = new StringBuilder();
                    for (int i2 = 0; i2 < n2; ++i2) {
                        string3 = jSONArray.get(i2).toString();
                        if (i2 == 0) {
                            stringBuilder.append("[").append(string3);
                            continue;
                        }
                        if (i2 == jSONArray.length() - 1) {
                            stringBuilder.append(",").append(string3).append("]");
                            continue;
                        }
                        stringBuilder.append(",").append(string3);
                    }
                    String string4 = stringBuilder.toString();
                    if (!TextUtils.isEmpty((CharSequence)string4)) {
                        string3 = string4 + context.getPackageName() + string + Session.getInstance().appSecret;
                        return EncryptUtil.md5EncryData(string3);
                    }
                }
            }
            catch (Exception exception) {
                SourceLog.w(TAG, "getVipAuthInfoLeBoSign Exception: " + exception);
            }
        }
        return "";
    }

    public static boolean isDigitsOnly(String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return false;
        }
        if (TextUtils.isDigitsOnly((CharSequence)string)) {
            return true;
        }
        return TextUtils.isDigitsOnly((CharSequence)string.replaceFirst("-", ""));
    }

    public static boolean isWifiApOpen(Context context) {
        try {
            WifiManager wifiManager = (WifiManager)context.getSystemService("wifi");
            Method method = wifiManager.getClass().getDeclaredMethod("isWifiApEnabled", new Class[0]);
            return (Boolean)method.invoke((Object)wifiManager, new Object[0]);
        }
        catch (Exception exception) {
            SourceLog.w(TAG, " getWifiApState  check wifi ip error ");
            return false;
        }
    }
}

