/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.sdk.source.utils;

import android.content.Context;
import android.content.res.AssetManager;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Rect;
import com.hpplay.common.log.LeLog;
import java.io.FileInputStream;
import java.io.InputStream;

public class BitmapUtils {
    public static final String TAG = "BitmapUtils";

    public static Bitmap getBitmapByPath(Context context, Rect rect, String string) {
        Bitmap bitmap = null;
        bitmap = string.contains("file:///android_asset/") ? BitmapUtils.getBitmapFromAssets(context, rect, string.substring("file:///android_asset/".length())) : BitmapUtils.getBitmapFromAbsolutePath(context, rect, string);
        return bitmap;
    }

    public static Bitmap getBitmapFromAssets(Context context, Rect rect, String string) {
        AssetManager assetManager = context.getAssets();
        Bitmap bitmap = null;
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = false;
        try {
            InputStream inputStream = assetManager.open(string);
            bitmap = BitmapFactory.decodeStream((InputStream)inputStream, (Rect)rect, (BitmapFactory.Options)options);
            rect.left = options.outWidth / 2;
            rect.top = options.outHeight / 2;
            inputStream.close();
        }
        catch (Exception exception) {
            LeLog.w(TAG, exception);
        }
        return bitmap;
    }

    public static Bitmap getBitmapFromAbsolutePath(Context context, Rect rect, String string) {
        Bitmap bitmap = null;
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = false;
        try {
            FileInputStream fileInputStream = new FileInputStream(string);
            bitmap = BitmapFactory.decodeStream((InputStream)fileInputStream, (Rect)rect, (BitmapFactory.Options)options);
            rect.left = options.outWidth / 2;
            rect.top = options.outHeight / 2;
            ((InputStream)fileInputStream).close();
        }
        catch (Exception exception) {
            LeLog.w(TAG, exception);
        }
        return bitmap;
    }

    public static Bitmap getBitmapById(Context context, Rect rect, int n2) {
        Bitmap bitmap = null;
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = false;
        try {
            Resources resources = context.getResources();
            InputStream inputStream = resources.openRawResource(n2);
            bitmap = BitmapFactory.decodeStream((InputStream)inputStream, (Rect)rect, (BitmapFactory.Options)options);
            rect.left = options.outWidth / 2;
            rect.top = options.outHeight / 2;
            inputStream.close();
        }
        catch (Exception exception) {
            LeLog.w(TAG, exception);
        }
        return bitmap;
    }

    public static Bitmap getNullBitmap(int n2, int n3) {
        return Bitmap.createBitmap((int)n2, (int)n3, (Bitmap.Config)Bitmap.Config.RGB_565);
    }
}

