/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.sdk.source.mdns.xbill.dns;

import com.hpplay.sdk.source.mdns.xbill.dns.DNSOutput;
import com.hpplay.sdk.source.mdns.xbill.dns.Message;
import com.hpplay.sdk.source.mdns.xbill.dns.Name;
import com.hpplay.sdk.source.mdns.xbill.dns.Options;
import com.hpplay.sdk.source.mdns.xbill.dns.TSIGRecord;
import com.hpplay.sdk.source.mdns.xbill.dns.utils.HMAC;
import com.hpplay.sdk.source.mdns.xbill.dns.utils.base64;
import java.util.Date;

public class TSIG {
    public static final Name HMAC_MD5;
    public static final Name HMAC;
    public static final Name HMAC_SHA1;
    public static final Name HMAC_SHA224;
    public static final Name HMAC_SHA256;
    public static final Name HMAC_SHA384;
    public static final Name HMAC_SHA512;
    public static final short FUDGE = 300;
    private Name name;
    private Name alg;
    private String digest;
    private int digestBlockLength;
    private byte[] key;

    private void getDigest() {
        if (this.alg.equals(HMAC_MD5)) {
            this.digest = "md5";
            this.digestBlockLength = 64;
        } else if (this.alg.equals(HMAC_SHA1)) {
            this.digest = "sha-1";
            this.digestBlockLength = 64;
        } else if (this.alg.equals(HMAC_SHA224)) {
            this.digest = "sha-224";
            this.digestBlockLength = 64;
        } else if (this.alg.equals(HMAC_SHA256)) {
            this.digest = "sha-256";
            this.digestBlockLength = 64;
        } else if (this.alg.equals(HMAC_SHA512)) {
            this.digest = "sha-512";
            this.digestBlockLength = 128;
        } else {
            if (!this.alg.equals(HMAC_SHA384)) {
                throw new IllegalArgumentException("Invalid algorithm");
            }
            this.digest = "sha-384";
            this.digestBlockLength = 128;
        }
    }

    public TSIG(Name name, Name name2, byte[] byArray) {
        this.name = name2;
        this.alg = name;
        this.key = byArray;
        this.getDigest();
    }

    public TSIG(Name name, byte[] byArray) {
        this(HMAC_MD5, name, byArray);
    }

    public TSIG(Name name, String string, String string2) {
        this.key = base64.fromString(string2);
        if (this.key == null) {
            throw new IllegalArgumentException("Invalid TSIG key string");
        }
        try {
            this.name = Name.fromString(string, Name.root);
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("Invalid TSIG key name");
        }
        this.alg = name;
        this.getDigest();
    }

    public TSIG(String string, String string2, String string3) {
        this(HMAC_MD5, string2, string3);
        if (string.equalsIgnoreCase("hmac-md5")) {
            this.alg = HMAC_MD5;
        } else if (string.equalsIgnoreCase("hmac-sha1")) {
            this.alg = HMAC_SHA1;
        } else if (string.equalsIgnoreCase("hmac-sha224")) {
            this.alg = HMAC_SHA224;
        } else if (string.equalsIgnoreCase("hmac-sha256")) {
            this.alg = HMAC_SHA256;
        } else if (string.equalsIgnoreCase("hmac-sha384")) {
            this.alg = HMAC_SHA384;
        } else {
            if (!string.equalsIgnoreCase("hmac-sha512")) {
                throw new IllegalArgumentException("Invalid TSIG algorithm");
            }
            this.alg = HMAC_SHA512;
        }
        this.getDigest();
    }

    public TSIG(String string, String string2) {
        this(HMAC_MD5, string, string2);
    }

    public static TSIG fromString(String string) {
        String[] stringArray = string.split("[:/]", 3);
        if (stringArray.length < 2) {
            throw new IllegalArgumentException("Invalid TSIG key specification");
        }
        if (stringArray.length == 3) {
            try {
                return new TSIG(stringArray[0], stringArray[1], stringArray[2]);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                stringArray = string.split("[:/]", 2);
            }
        }
        return new TSIG(HMAC_MD5, stringArray[0], stringArray[1]);
    }

    public TSIGRecord generate(Message message, byte[] byArray, int n2, TSIGRecord tSIGRecord) {
        DNSOutput dNSOutput;
        int n3;
        Date date = n2 != 18 ? new Date() : tSIGRecord.getTimeSigned();
        HMAC hMAC = null;
        if (n2 == 0 || n2 == 18) {
            hMAC = new HMAC(this.digest, this.digestBlockLength, this.key);
        }
        if ((n3 = Options.intValue("tsigfudge")) < 0 || n3 > Short.MAX_VALUE) {
            n3 = 300;
        }
        if (tSIGRecord != null) {
            dNSOutput = new DNSOutput();
            dNSOutput.writeU16(tSIGRecord.getSignature().length);
            if (hMAC != null) {
                hMAC.update(dNSOutput.toByteArray());
                hMAC.update(tSIGRecord.getSignature());
            }
        }
        if (hMAC != null) {
            hMAC.update(byArray);
        }
        dNSOutput = new DNSOutput();
        this.name.toWireCanonical(dNSOutput);
        dNSOutput.writeU16(255);
        dNSOutput.writeU32(0L);
        this.alg.toWireCanonical(dNSOutput);
        long l2 = date.getTime() / 1000L;
        int n4 = (int)(l2 >> 32);
        long l3 = l2 & 0xFFFFFFFFL;
        dNSOutput.writeU16(n4);
        dNSOutput.writeU32(l3);
        dNSOutput.writeU16(n3);
        dNSOutput.writeU16(n2);
        dNSOutput.writeU16(0);
        if (hMAC != null) {
            hMAC.update(dNSOutput.toByteArray());
        }
        byte[] byArray2 = hMAC != null ? hMAC.sign() : new byte[]{};
        byte[] byArray3 = null;
        if (n2 == 18) {
            dNSOutput = new DNSOutput();
            l2 = new Date().getTime() / 1000L;
            n4 = (int)(l2 >> 32);
            l3 = l2 & 0xFFFFFFFFL;
            dNSOutput.writeU16(n4);
            dNSOutput.writeU32(l3);
            byArray3 = dNSOutput.toByteArray();
        }
        return new TSIGRecord(this.name, 255, 0L, this.alg, date, n3, byArray2, message.getHeader().getID(), n2, byArray3);
    }

    public void apply(Message message, int n2, TSIGRecord tSIGRecord) {
        TSIGRecord tSIGRecord2 = this.generate(message, message.toWire(), n2, tSIGRecord);
        message.addRecord(tSIGRecord2, 3);
        message.tsigState = 3;
    }

    public void apply(Message message, TSIGRecord tSIGRecord) {
        this.apply(message, 0, tSIGRecord);
    }

    public byte verify(Message message, byte[] byArray, int n2, TSIGRecord tSIGRecord) {
        message.tsigState = 4;
        TSIGRecord tSIGRecord2 = message.getTSIG();
        HMAC hMAC = new HMAC(this.digest, this.digestBlockLength, this.key);
        if (tSIGRecord2 == null) {
            return 1;
        }
        if (tSIGRecord2.getName().equals(this.name) && tSIGRecord2.getAlgorithm().equals(this.alg)) {
            int n3;
            Object object;
            long l2 = System.currentTimeMillis();
            long l3 = tSIGRecord2.getTimeSigned().getTime();
            long l4 = tSIGRecord2.getFudge();
            if (Math.abs(l2 - l3) > l4 * 1000L) {
                if (Options.check("verbose")) {
                    System.err.println("BADTIME failure");
                }
                return 18;
            }
            if (tSIGRecord != null && tSIGRecord2.getError() != 17 && tSIGRecord2.getError() != 16) {
                object = new DNSOutput();
                ((DNSOutput)object).writeU16(tSIGRecord.getSignature().length);
                hMAC.update(((DNSOutput)object).toByteArray());
                hMAC.update(tSIGRecord.getSignature());
            }
            message.getHeader().decCount(3);
            object = message.getHeader().toWire();
            message.getHeader().incCount(3);
            hMAC.update((byte[])object);
            int n4 = message.tsigstart - ((Object)object).length;
            hMAC.update(byArray, ((Object)object).length, n4);
            DNSOutput dNSOutput = new DNSOutput();
            tSIGRecord2.getName().toWireCanonical(dNSOutput);
            dNSOutput.writeU16(tSIGRecord2.dclass);
            dNSOutput.writeU32(tSIGRecord2.ttl);
            tSIGRecord2.getAlgorithm().toWireCanonical(dNSOutput);
            long l5 = tSIGRecord2.getTimeSigned().getTime() / 1000L;
            int n5 = (int)(l5 >> 32);
            long l6 = l5 & 0xFFFFFFFFL;
            dNSOutput.writeU16(n5);
            dNSOutput.writeU32(l6);
            dNSOutput.writeU16(tSIGRecord2.getFudge());
            dNSOutput.writeU16(tSIGRecord2.getError());
            if (tSIGRecord2.getOther() != null) {
                dNSOutput.writeU16(tSIGRecord2.getOther().length);
                dNSOutput.writeByteArray(tSIGRecord2.getOther());
            } else {
                dNSOutput.writeU16(0);
            }
            hMAC.update(dNSOutput.toByteArray());
            byte[] byArray2 = tSIGRecord2.getSignature();
            int n6 = hMAC.digestLength();
            int n7 = n3 = this.digest.equals("md5") ? 10 : n6 / 2;
            if (byArray2.length > n6) {
                if (Options.check("verbose")) {
                    System.err.println("BADSIG: signature too long");
                }
                return 16;
            }
            if (byArray2.length < n3) {
                if (Options.check("verbose")) {
                    System.err.println("BADSIG: signature too short");
                }
                return 16;
            }
            if (!hMAC.verify(byArray2, true)) {
                if (Options.check("verbose")) {
                    System.err.println("BADSIG: signature verification");
                }
                return 16;
            }
            message.tsigState = 1;
            return 0;
        }
        if (Options.check("verbose")) {
            System.err.println("BADKEY failure");
        }
        return 17;
    }

    public int verify(Message message, byte[] byArray, TSIGRecord tSIGRecord) {
        return this.verify(message, byArray, byArray.length, tSIGRecord);
    }

    public int recordLength() {
        return this.name.length() + 10 + this.alg.length() + 8 + 18 + 4 + 8;
    }

    static {
        HMAC = HMAC_MD5 = Name.fromConstantString("HMAC-MD5.SIG-ALG.REG.INT.");
        HMAC_SHA1 = Name.fromConstantString("hmac-sha1.");
        HMAC_SHA224 = Name.fromConstantString("hmac-sha224.");
        HMAC_SHA256 = Name.fromConstantString("hmac-sha256.");
        HMAC_SHA384 = Name.fromConstantString("hmac-sha384.");
        HMAC_SHA512 = Name.fromConstantString("hmac-sha512.");
    }

    public static class StreamVerifier {
        private TSIG key;
        private HMAC verifier;
        private int nresponses;
        private int lastsigned;
        private TSIGRecord lastTSIG;

        public StreamVerifier(TSIG tSIG, TSIGRecord tSIGRecord) {
            this.key = tSIG;
            this.verifier = new HMAC(this.key.digest, this.key.digestBlockLength, this.key.key);
            this.nresponses = 0;
            this.lastTSIG = tSIGRecord;
        }

        public int verify(Message message, byte[] byArray) {
            boolean bl;
            TSIGRecord tSIGRecord = message.getTSIG();
            ++this.nresponses;
            if (this.nresponses == 1) {
                int n2 = this.key.verify(message, byArray, this.lastTSIG);
                if (n2 == 0) {
                    byte[] byArray2 = tSIGRecord.getSignature();
                    DNSOutput dNSOutput = new DNSOutput();
                    dNSOutput.writeU16(byArray2.length);
                    this.verifier.update(dNSOutput.toByteArray());
                    this.verifier.update(byArray2);
                }
                this.lastTSIG = tSIGRecord;
                return n2;
            }
            if (tSIGRecord != null) {
                message.getHeader().decCount(3);
            }
            byte[] byArray3 = message.getHeader().toWire();
            if (tSIGRecord != null) {
                message.getHeader().incCount(3);
            }
            this.verifier.update(byArray3);
            int n3 = tSIGRecord == null ? byArray.length - byArray3.length : message.tsigstart - byArray3.length;
            this.verifier.update(byArray, byArray3.length, n3);
            if (tSIGRecord != null) {
                this.lastsigned = this.nresponses;
                this.lastTSIG = tSIGRecord;
                if (tSIGRecord.getName().equals(this.key.name) && tSIGRecord.getAlgorithm().equals(this.key.alg)) {
                    DNSOutput dNSOutput = new DNSOutput();
                    long l2 = tSIGRecord.getTimeSigned().getTime() / 1000L;
                    int n4 = (int)(l2 >> 32);
                    long l3 = l2 & 0xFFFFFFFFL;
                    dNSOutput.writeU16(n4);
                    dNSOutput.writeU32(l3);
                    dNSOutput.writeU16(tSIGRecord.getFudge());
                    this.verifier.update(dNSOutput.toByteArray());
                    if (!this.verifier.verify(tSIGRecord.getSignature())) {
                        if (Options.check("verbose")) {
                            System.err.println("BADSIG failure");
                        }
                        message.tsigState = 4;
                        return 16;
                    }
                    this.verifier.clear();
                    dNSOutput = new DNSOutput();
                    dNSOutput.writeU16(tSIGRecord.getSignature().length);
                    this.verifier.update(dNSOutput.toByteArray());
                    this.verifier.update(tSIGRecord.getSignature());
                    message.tsigState = 1;
                    return 0;
                }
                if (Options.check("verbose")) {
                    System.err.println("BADKEY failure");
                }
                message.tsigState = 4;
                return 17;
            }
            boolean bl2 = bl = this.nresponses - this.lastsigned >= 100;
            if (bl) {
                message.tsigState = 4;
                return 1;
            }
            message.tsigState = 2;
            return 0;
        }
    }
}

