/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.glide.load.engine.bitmap_recycle;

import android.annotation.TargetApi;
import android.graphics.Bitmap;
import com.hpplay.glide.load.engine.bitmap_recycle.BaseKeyPool;
import com.hpplay.glide.load.engine.bitmap_recycle.GroupedLinkedMap;
import com.hpplay.glide.load.engine.bitmap_recycle.LruPoolStrategy;
import com.hpplay.glide.load.engine.bitmap_recycle.Poolable;
import com.hpplay.glide.util.Util;
import java.util.HashMap;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;

@TargetApi(value=19)
public class SizeConfigStrategy
implements LruPoolStrategy {
    private static final int MAX_SIZE_MULTIPLE = 8;
    private static final Bitmap.Config[] ARGB_8888_IN_CONFIGS = new Bitmap.Config[]{Bitmap.Config.ARGB_8888, null};
    private static final Bitmap.Config[] RGB_565_IN_CONFIGS = new Bitmap.Config[]{Bitmap.Config.RGB_565};
    private static final Bitmap.Config[] ARGB_4444_IN_CONFIGS = new Bitmap.Config[]{Bitmap.Config.ARGB_4444};
    private static final Bitmap.Config[] ALPHA_8_IN_CONFIGS = new Bitmap.Config[]{Bitmap.Config.ALPHA_8};
    private final KeyPool keyPool = new KeyPool();
    private final GroupedLinkedMap<Key, Bitmap> groupedMap = new GroupedLinkedMap();
    private final Map<Bitmap.Config, NavigableMap<Integer, Integer>> sortedSizes = new HashMap<Bitmap.Config, NavigableMap<Integer, Integer>>();

    @Override
    public void put(Bitmap bitmap) {
        int n2 = Util.getBitmapByteSize(bitmap);
        Key key = this.keyPool.get(n2, bitmap.getConfig());
        this.groupedMap.put(key, bitmap);
        NavigableMap<Integer, Integer> navigableMap = this.getSizesForConfig(bitmap.getConfig());
        Integer n3 = (Integer)navigableMap.get(key.size);
        navigableMap.put(key.size, n3 == null ? 1 : n3 + 1);
    }

    @Override
    public Bitmap get(int n2, int n3, Bitmap.Config config) {
        int n4 = Util.getBitmapByteSize(n2, n3, config);
        Key key = this.keyPool.get(n4, config);
        Key key2 = this.findBestKey(key, n4, config);
        Bitmap bitmap = this.groupedMap.get(key2);
        if (bitmap != null) {
            this.decrementBitmapOfSize(Util.getBitmapByteSize(bitmap), bitmap.getConfig());
            bitmap.reconfigure(n2, n3, bitmap.getConfig() != null ? bitmap.getConfig() : Bitmap.Config.ARGB_8888);
        }
        return bitmap;
    }

    private Key findBestKey(Key key, int n2, Bitmap.Config config) {
        Key key2 = key;
        for (Bitmap.Config config2 : SizeConfigStrategy.getInConfigs(config)) {
            NavigableMap<Integer, Integer> navigableMap = this.getSizesForConfig(config2);
            Integer n3 = navigableMap.ceilingKey(n2);
            if (n3 == null || n3 > n2 * 8) continue;
            if (n3 == n2 && !(config2 == null ? config != null : !config2.equals((Object)config))) break;
            this.keyPool.offer(key);
            key2 = this.keyPool.get(n3, config2);
            break;
        }
        return key2;
    }

    @Override
    public Bitmap removeLast() {
        Bitmap bitmap = this.groupedMap.removeLast();
        if (bitmap != null) {
            int n2 = Util.getBitmapByteSize(bitmap);
            this.decrementBitmapOfSize(n2, bitmap.getConfig());
        }
        return bitmap;
    }

    private void decrementBitmapOfSize(Integer n2, Bitmap.Config config) {
        NavigableMap<Integer, Integer> navigableMap = this.getSizesForConfig(config);
        Integer n3 = (Integer)navigableMap.get(n2);
        if (n3 == 1) {
            navigableMap.remove(n2);
        } else {
            navigableMap.put(n2, n3 - 1);
        }
    }

    private NavigableMap<Integer, Integer> getSizesForConfig(Bitmap.Config config) {
        NavigableMap<Integer, Integer> navigableMap = this.sortedSizes.get(config);
        if (navigableMap == null) {
            navigableMap = new TreeMap<Integer, Integer>();
            this.sortedSizes.put(config, navigableMap);
        }
        return navigableMap;
    }

    @Override
    public String logBitmap(Bitmap bitmap) {
        int n2 = Util.getBitmapByteSize(bitmap);
        return SizeConfigStrategy.getBitmapString(n2, bitmap.getConfig());
    }

    @Override
    public String logBitmap(int n2, int n3, Bitmap.Config config) {
        int n4 = Util.getBitmapByteSize(n2, n3, config);
        return SizeConfigStrategy.getBitmapString(n4, config);
    }

    @Override
    public int getSize(Bitmap bitmap) {
        return Util.getBitmapByteSize(bitmap);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder().append("SizeConfigStrategy{groupedMap=").append(this.groupedMap).append(", sortedSizes=(");
        for (Map.Entry<Bitmap.Config, NavigableMap<Integer, Integer>> entry : this.sortedSizes.entrySet()) {
            stringBuilder.append(entry.getKey()).append('[').append(entry.getValue()).append("], ");
        }
        if (!this.sortedSizes.isEmpty()) {
            stringBuilder.replace(stringBuilder.length() - 2, stringBuilder.length(), "");
        }
        return stringBuilder.append(")}").toString();
    }

    private static String getBitmapString(int n2, Bitmap.Config config) {
        return "[" + n2 + "](" + config + ")";
    }

    private static Bitmap.Config[] getInConfigs(Bitmap.Config config) {
        switch (config) {
            case ARGB_8888: {
                return ARGB_8888_IN_CONFIGS;
            }
            case RGB_565: {
                return RGB_565_IN_CONFIGS;
            }
            case ARGB_4444: {
                return ARGB_4444_IN_CONFIGS;
            }
            case ALPHA_8: {
                return ALPHA_8_IN_CONFIGS;
            }
        }
        return new Bitmap.Config[]{config};
    }

    static final class Key
    implements Poolable {
        private final KeyPool pool;
        private int size;
        private Bitmap.Config config;

        public Key(KeyPool keyPool) {
            this.pool = keyPool;
        }

        Key(KeyPool keyPool, int n2, Bitmap.Config config) {
            this(keyPool);
            this.init(n2, config);
        }

        public void init(int n2, Bitmap.Config config) {
            this.size = n2;
            this.config = config;
        }

        @Override
        public void offer() {
            this.pool.offer(this);
        }

        public String toString() {
            return SizeConfigStrategy.getBitmapString(this.size, this.config);
        }

        public boolean equals(Object object) {
            if (object instanceof Key) {
                Key key = (Key)object;
                return this.size == key.size && (this.config == null ? key.config == null : this.config.equals((Object)key.config));
            }
            return false;
        }

        public int hashCode() {
            int n2 = this.size;
            n2 = 31 * n2 + (this.config != null ? this.config.hashCode() : 0);
            return n2;
        }
    }

    static class KeyPool
    extends BaseKeyPool<Key> {
        KeyPool() {
        }

        public Key get(int n2, Bitmap.Config config) {
            Key key = (Key)this.get();
            key.init(n2, config);
            return key;
        }

        @Override
        protected Key create() {
            return new Key(this);
        }
    }
}

