/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.cybergarage.http;

import java.util.Calendar;
import java.util.TimeZone;

public class Date {
    private Calendar cal;
    private static final String[] MONTH_STRING = new String[]{"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"};
    private static final String[] WEEK_STRING = new String[]{"Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"};

    public Date(Calendar calendar) {
        this.cal = calendar;
    }

    public Calendar getCalendar() {
        return this.cal;
    }

    public int getHour() {
        return this.getCalendar().get(11);
    }

    public int getMinute() {
        return this.getCalendar().get(12);
    }

    public int getSecond() {
        return this.getCalendar().get(13);
    }

    public static final Date getLocalInstance() {
        return new Date(Calendar.getInstance());
    }

    public static final Date getInstance() {
        return new Date(Calendar.getInstance(TimeZone.getTimeZone("GMT")));
    }

    public static final String toDateString(int n2) {
        if (n2 < 10) {
            return "0" + Integer.toString(n2);
        }
        return Integer.toString(n2);
    }

    public static final String toMonthString(int n2) {
        if (0 <= (n2 += 0) && n2 < 12) {
            return MONTH_STRING[n2];
        }
        return "";
    }

    public static final String toWeekString(int n2) {
        if (0 <= --n2 && n2 < 7) {
            return WEEK_STRING[n2];
        }
        return "";
    }

    public static final String toTimeString(int n2) {
        String string = "";
        if (n2 < 10) {
            string = string + "0";
        }
        string = string + Integer.toString(n2);
        return string;
    }

    public String getDateString() {
        Calendar calendar = this.getCalendar();
        return Date.toWeekString(calendar.get(7)) + ", " + Date.toTimeString(calendar.get(5)) + " " + Date.toMonthString(calendar.get(2)) + " " + Integer.toString(calendar.get(1)) + " " + Date.toTimeString(calendar.get(11)) + ":" + Date.toTimeString(calendar.get(12)) + ":" + Date.toTimeString(calendar.get(13)) + " GMT";
    }

    public String getTimeString() {
        Calendar calendar = this.getCalendar();
        return Date.toDateString(calendar.get(11)) + (calendar.get(13) % 2 == 0 ? ":" : " ") + Date.toDateString(calendar.get(12));
    }
}

