/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.component.protocol.plist;

import com.hpplay.component.protocol.plist.BinaryPropertyListParser;
import com.hpplay.component.protocol.plist.BinaryPropertyListWriter;
import com.hpplay.component.protocol.plist.NSObject;

public class NSNumber
extends NSObject
implements Comparable<Object> {
    public static final int INTEGER = 0;
    public static final int REAL = 1;
    public static final int BOOLEAN = 2;
    private int type;
    private long longValue;
    private double doubleValue;
    private boolean boolValue;

    public NSNumber(byte[] byArray, int n2) {
        this(byArray, 0, byArray.length, n2);
    }

    public NSNumber(byte[] byArray, int n2, int n3, int n4) {
        switch (n4) {
            case 0: {
                this.longValue = BinaryPropertyListParser.parseLong(byArray, n2, n3);
                this.doubleValue = this.longValue;
                break;
            }
            case 1: {
                this.doubleValue = BinaryPropertyListParser.parseDouble(byArray, n2, n3);
                this.longValue = Math.round(this.doubleValue);
                break;
            }
            default: {
                throw new IllegalArgumentException("Type argument is not valid.");
            }
        }
        this.type = n4;
    }

    public NSNumber(String string) {
        if (string == null) {
            throw new IllegalArgumentException("The given string is null and cannot be parsed as number.");
        }
        try {
            long l2 = string.startsWith("0x") ? Long.parseLong(string.substring(2), 16) : Long.parseLong(string);
            this.longValue = l2;
            this.doubleValue = this.longValue;
            this.type = 0;
        }
        catch (Exception exception) {
            try {
                this.doubleValue = Double.parseDouble(string);
                this.longValue = Math.round(this.doubleValue);
                this.type = 1;
            }
            catch (Exception exception2) {
                try {
                    boolean bl = this.boolValue = string.equalsIgnoreCase("true") || string.equalsIgnoreCase("yes");
                    if (!(this.boolValue || string.equalsIgnoreCase("false") || string.equalsIgnoreCase("no"))) {
                        throw new Exception("not a boolean");
                    }
                    this.type = 2;
                    this.longValue = this.boolValue ? 1L : 0L;
                    this.doubleValue = this.longValue;
                }
                catch (Exception exception3) {
                    throw new IllegalArgumentException("The given string neither represents a double, an int nor a boolean value.");
                }
            }
        }
    }

    public NSNumber(int n2) {
        this.longValue = n2;
        this.doubleValue = this.longValue;
        this.type = 0;
    }

    public NSNumber(long l2) {
        this.longValue = l2;
        this.doubleValue = this.longValue;
        this.type = 0;
    }

    public NSNumber(double d2) {
        this.doubleValue = d2;
        this.longValue = (long)this.doubleValue;
        this.type = 1;
    }

    public NSNumber(boolean bl) {
        this.boolValue = bl;
        this.longValue = bl ? 1L : 0L;
        this.doubleValue = this.longValue;
        this.type = 2;
    }

    public int type() {
        return this.type;
    }

    public boolean isBoolean() {
        return this.type == 2;
    }

    public boolean isInteger() {
        return this.type == 0;
    }

    public boolean isReal() {
        return this.type == 1;
    }

    public boolean boolValue() {
        if (this.type == 2) {
            return this.boolValue;
        }
        return this.doubleValue() != 0.0;
    }

    public long longValue() {
        return this.longValue;
    }

    public int intValue() {
        return (int)this.longValue;
    }

    public double doubleValue() {
        return this.doubleValue;
    }

    public float floatValue() {
        return (float)this.doubleValue;
    }

    public String stringValue() {
        switch (this.type) {
            case 0: {
                return String.valueOf(this.longValue());
            }
            case 1: {
                return String.valueOf(this.doubleValue());
            }
            case 2: {
                return String.valueOf(this.boolValue());
            }
        }
        throw new IllegalStateException("The NSNumber instance has an invalid type: " + this.type);
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        NSNumber nSNumber = (NSNumber)object;
        return this.type == nSNumber.type && this.longValue == nSNumber.longValue && this.doubleValue == nSNumber.doubleValue && this.boolValue == nSNumber.boolValue;
    }

    public int hashCode() {
        int n2 = this.type;
        n2 = 37 * n2 + (int)(this.longValue ^ this.longValue >>> 32);
        n2 = 37 * n2 + (int)(Double.doubleToLongBits(this.doubleValue) ^ Double.doubleToLongBits(this.doubleValue) >>> 32);
        n2 = 37 * n2 + (this.boolValue() ? 1 : 0);
        return n2;
    }

    @Override
    public NSNumber clone() {
        switch (this.type) {
            case 0: {
                return new NSNumber(this.longValue);
            }
            case 1: {
                return new NSNumber(this.doubleValue);
            }
            case 2: {
                return new NSNumber(this.boolValue);
            }
        }
        throw new IllegalStateException("The NSNumber instance has an invalid type: " + this.type);
    }

    public String toString() {
        switch (this.type()) {
            case 0: {
                return String.valueOf(this.longValue());
            }
            case 1: {
                return String.valueOf(this.doubleValue());
            }
            case 2: {
                return String.valueOf(this.boolValue());
            }
        }
        return super.toString();
    }

    @Override
    void toXML(StringBuilder stringBuilder, int n2) {
        this.indent(stringBuilder, n2);
        switch (this.type()) {
            case 0: {
                stringBuilder.append("<integer>");
                stringBuilder.append(this.longValue());
                stringBuilder.append("</integer>");
                break;
            }
            case 1: {
                stringBuilder.append("<real>");
                stringBuilder.append(this.doubleValue());
                stringBuilder.append("</real>");
                break;
            }
            case 2: {
                if (this.boolValue()) {
                    stringBuilder.append("<true/>");
                    break;
                }
                stringBuilder.append("<false/>");
                break;
            }
        }
    }

    @Override
    void toBinary(BinaryPropertyListWriter binaryPropertyListWriter) {
        switch (this.type()) {
            case 0: {
                if (this.longValue() < 0L) {
                    binaryPropertyListWriter.write(19);
                    binaryPropertyListWriter.writeBytes(this.longValue(), 8);
                    break;
                }
                if (this.longValue() <= 255L) {
                    binaryPropertyListWriter.write(16);
                    binaryPropertyListWriter.writeBytes(this.longValue(), 1);
                    break;
                }
                if (this.longValue() <= 65535L) {
                    binaryPropertyListWriter.write(17);
                    binaryPropertyListWriter.writeBytes(this.longValue(), 2);
                    break;
                }
                if (this.longValue() <= 0xFFFFFFFFL) {
                    binaryPropertyListWriter.write(18);
                    binaryPropertyListWriter.writeBytes(this.longValue(), 4);
                    break;
                }
                binaryPropertyListWriter.write(19);
                binaryPropertyListWriter.writeBytes(this.longValue(), 8);
                break;
            }
            case 1: {
                binaryPropertyListWriter.write(35);
                binaryPropertyListWriter.writeDouble(this.doubleValue());
                break;
            }
            case 2: {
                binaryPropertyListWriter.write(this.boolValue() ? 9 : 8);
                break;
            }
        }
    }

    @Override
    protected void toASCII(StringBuilder stringBuilder, int n2) {
        this.indent(stringBuilder, n2);
        if (this.isBoolean()) {
            stringBuilder.append(this.boolValue() ? "YES" : "NO");
        } else {
            stringBuilder.append(this.toString());
        }
    }

    @Override
    protected void toASCIIGnuStep(StringBuilder stringBuilder, int n2) {
        this.indent(stringBuilder, n2);
        switch (this.type()) {
            case 0: {
                stringBuilder.append("<*I");
                stringBuilder.append(this.toString());
                stringBuilder.append('>');
                break;
            }
            case 1: {
                stringBuilder.append("<*R");
                stringBuilder.append(this.toString());
                stringBuilder.append('>');
                break;
            }
            case 2: {
                if (this.boolValue()) {
                    stringBuilder.append("<*BY>");
                    break;
                }
                stringBuilder.append("<*BN>");
            }
        }
    }

    @Override
    public int compareTo(Object object) {
        double d2 = this.doubleValue();
        if (object instanceof NSNumber) {
            NSNumber nSNumber = (NSNumber)object;
            double d3 = nSNumber.doubleValue();
            return d2 < d3 ? -1 : (d2 == d3 ? 0 : 1);
        }
        if (object instanceof Number) {
            double d4 = ((Number)object).doubleValue();
            return d2 < d4 ? -1 : (d2 == d4 ? 0 : 1);
        }
        return -1;
    }
}

