/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.component.protocol.encrypt;

import android.text.TextUtils;
import com.hpplay.component.common.utils.CLog;
import com.hpplay.component.protocol.NLProtocolBuiler;
import com.hpplay.component.protocol.ProtocolUtils;
import com.hpplay.component.protocol.encrypt.ChaCha20;
import com.hpplay.component.protocol.encrypt.Curve25519;
import com.hpplay.component.protocol.encrypt.ED25519Encrypt;
import com.hpplay.component.protocol.encrypt.Poly1305;
import com.hpplay.component.protocol.encrypt.TlvBox;
import com.hpplay.component.protocol.plist.NSDictionary;
import com.hpplay.component.protocol.plist.PropertyListParser;
import com.hpplay.component.protocol.srp6.BigIntegerUtils;
import com.hpplay.component.protocol.srp6.SRP6ClientSession;
import com.hpplay.component.protocol.srp6.SRP6CryptoParams;
import com.hpplay.component.protocol.srp6.SRP6Exception;
import com.hpplay.component.protocol.srp6.cli.ClientSessionImpl;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Random;

public class LelinkEncrypt {
    private static final String TAG = "LelinkEncrypt";
    private static final int SRP_RANDOM_WAY = 2;
    private static final int SRP_WAY = 1;
    private static final int ED25519_WAY = 0;
    public static final String SALT_KEY = "LELINK-VERIFY_SIGNATURE-KEY";
    public static final String SALT_IV = "LELINK-VERIFY-SIGNATURE-NONCE";
    private static final String SRP_SALT_KEY = "LELINK-VERIFY_ATV-KEY";
    private static final String SRP_SALT_IV = "LEINK-VERIFY-ATV-NONCE";
    private static final String IDE_VERIFY_SALT_KEY = "LELINK-VERIFY_IDENTITY-KEY";
    private static final String IDE_VERIFY_NONCE = "LEINK-VERIFY-IDENTITY-NONCE";
    private static final String IDE_SALT_KEY = "LELINK-IDENTITY-KEY";
    private static final String IDE_NONCE = "LELINK-IDENTITY-NONCE";
    private static final String SRP_IDE_SALT_KEY = "LELINK-AUTH_IDENTITY-KEY";
    private static final String SRP_IDE_NONCE = "LELINK-AUTH_IDENTITY-NONCE";
    private static final String LELINK_USER = "LELINK_USER";
    private String srpPassword = "000000";
    private boolean isDebug = true;
    private byte[] mRcvEdPk = new byte[32];
    private byte[] mRcvEdPkSalt = new byte[32];
    private byte mRcvType;
    private byte mRcvStage;
    private byte[] mKeySalt = new byte[32];
    private byte mType;
    private byte mStage;
    public byte[] mSecretkey = null;
    public byte[] mEdPukey = null;
    public byte[] mEdSalt = null;
    private byte[] mCurvePukey;
    private byte[] mCurvePrkey;
    private byte[] mRcvCurvePkey;
    private byte[] mRcvSignatrue;
    private byte[] sharedSecret;
    private byte[] chachaMaterKey;
    private byte[] chachaNonce;
    private ChaCha20 mEnChaCha20;
    private ChaCha20 mDeChaCha20;
    private String mSessionId;
    private boolean isRelase = false;
    private SRP6ClientSession srp6ClientSession;
    private byte[] mRcvSrpPuk;
    private byte[] mChachaSignMessage;
    private byte[] msrpSignMessage;
    private byte[] msrpSignature;
    private byte[] mSrpSalt;
    private byte[] mSrpPukey;
    private int mAtv = 0;
    private String mEncryptState = "successful";
    private ED25519Encrypt mEd25519Encrypt;
    public static final int PAIR_TAG_HAF = 0;
    public static final int PAIR_TAG_TYPE = 1;
    public static final int PAIR_TAG_STAGE = 2;
    public static final int PAIR_SETUP_M1_CLIENT = 3;
    public static final int PAIR_SETUP_M1_SERVER = 3;
    public static final int PAIR_VRIFY_M2_CLIENT = 4;
    public static final int PAIR_VRIFY_M2_SERVER = 4;
    public static final int PAIR_VRIFY_M3_CLIENT = 5;
    public static final int PAIR_VRIFY_M3_SERVER = 5;
    public static final int PAIR_TAG_AUTH_SRP_M1_CLIENT_METHOD = 3;
    public static final int PAIR_TAG_AUTH_SRP_M1_CLIENT_USERNAME = 4;
    public static final int PAIR_TAG_AUTH_SRP_M2_CLIENT_PUBLIC_KEY = 5;
    public static final int PAIR_TAG_AUTH_SRP_M1_SERVER_PBULIC_KEY = 5;
    public static final int PAIR_TAG_AUTH_SRP_M1_SERVER_PUBLIC_SALT = 6;
    public static final int PAIR_TAG_AUTH_SRP_M2_CLIENT_PROOF = 8;
    public static final int PAIR_TAG_AUTH_SRP_M2_SERVER_PROOF = 8;
    public static final int PAIR_TAG_AUTH_SRP_M3_CLIENT_SIGN_BODY = 9;
    public static final int PAIR_TAG_AUTH_SRP_M3_CLIENT_SIGN_HEMAC = 10;
    public static final int PAIR_TAG_AUTH_SRP_M3_CLIENT_PUBLIC_SALT = 11;
    public static final int PAIR_TAG_AUTH_SRP_M3_SERVER_SIGN_BODY = 9;
    public static final int PAIR_TAG_AUTH_SRP_M3_SERVER_SIGN_HEMAC = 10;
    public static final int PAIR_TAG_AUTH_SRP_M3_SERVER_PUBLIC_SALT = 11;
    public static final int PAIR_AUTH_STAGE_INIT = 0;
    public static final int PAIR_AUTH_STAGE_M1_REQ = 1;
    public static final int PAIR_AUTH_STAGE_M1_RSP = 2;
    public static final int PAIR_AUTH_STAGE_M2_REQ = 3;
    public static final int PAIR_AUTH_STAGE_M2_RSP = 4;
    public static final int PAIR_AUTH_STAGE_M3_REQ = 5;
    public static final int PAIR_AUTH_STAGE_M3_RSP = 6;
    public static final int PAIR_AUTH_STAGE_M1 = 7;
    public static final int PAIR_AUTH_STAGE_M2 = 8;
    public static final int PAIR_AUTH_STAGE_M3 = 9;
    public static final int PAIR_AUTH_STAGE_FINISHED = 10;
    public static final int PAIR_AUTH_STAGE_ERROR = 11;
    public static final int PAIR_AUTH_STAGE_BADLENGTH = 12;
    public static final String KEY_VV = "vv";
    public static final String KEY_HSTV = "hstv";
    public static final String KEY_ETV = "etv";
    public static final String KEY_ATV = "atv";
    public static final String KEY_HMD = "hmd";
    public static final String KEY_HTV = "htv";

    public void setSrpPassword(String string) {
        this.srpPassword = TextUtils.isEmpty((CharSequence)string) ? "000000" : string;
    }

    public LelinkEncrypt(String string) {
        this.mSessionId = string;
        this.mEd25519Encrypt = new ED25519Encrypt();
    }

    public byte[] genPlayInfoRequest() {
        String string = this.buildHeader(new NLProtocolBuiler().getNewLelinkPlayerinfoCmd(), 0);
        return string.getBytes();
    }

    public boolean parsePlayerInfoResponse(byte[] byArray) {
        if (byArray == null) {
            return false;
        }
        String string = new String(byArray);
        CLog.d(TAG, string);
        byte[] byArray2 = ProtocolUtils.removeHeader(string.getBytes());
        try {
            String string2;
            NSDictionary nSDictionary = (NSDictionary)PropertyListParser.parse(byArray2);
            if (nSDictionary != null && nSDictionary.containsKey(KEY_ATV) && !TextUtils.isEmpty((CharSequence)(string2 = nSDictionary.get(KEY_ATV).toString()))) {
                this.mAtv = Integer.valueOf(string2);
            }
            CLog.d(TAG, "atv : " + this.mAtv);
            return true;
        }
        catch (Exception exception) {
            CLog.w(TAG, exception);
            return false;
        }
    }

    public byte[] genSetupRequest() {
        if (this.isRelase) {
            return null;
        }
        byte[] byArray = new byte[4];
        byArray[0] = 0;
        byArray[2] = (byte)this.mAtv;
        byArray[3] = 1;
        byte[] byArray2 = new byte[2];
        TlvBox tlvBox = new TlvBox();
        switch (this.mAtv) {
            case 1: 
            case 2: {
                byArray[1] = 2;
                byArray2[0] = 2;
                byArray2[1] = 1;
                tlvBox.putBytesValue(0, byArray);
                tlvBox.putByteValue(1, byArray2[0]);
                tlvBox.putByteValue(2, byArray2[1]);
                tlvBox.putStringValue(4, LELINK_USER);
                tlvBox.putStringValue(3, "default");
                break;
            }
            case 0: {
                byArray[1] = 1;
                byArray2[0] = 1;
                byArray2[1] = 1;
                this.mSecretkey = new byte[64];
                this.mEdPukey = new byte[32];
                this.mEdSalt = new byte[32];
                this.mEd25519Encrypt.publicKeyGen(this.mSecretkey, this.mEdPukey, this.mEdSalt);
                byte[] byArray3 = new byte[64];
                System.arraycopy(this.mEdPukey, 0, byArray3, 0, this.mEdPukey.length);
                this.mKeySalt = new byte[32];
                new Random().nextBytes(this.mKeySalt);
                System.arraycopy(this.mKeySalt, 0, byArray3, 32, this.mKeySalt.length);
                tlvBox.putBytesValue(0, byArray);
                tlvBox.putByteValue(1, byArray2[0]);
                tlvBox.putByteValue(2, byArray2[1]);
                tlvBox.putBytesValue(3, byArray3);
            }
        }
        byte[] byArray4 = tlvBox.serialize();
        CLog.d(TAG, this.bytesToHex(byArray4));
        String string = this.buildHeader(new NLProtocolBuiler().getSetupCmd(), byArray4.length);
        byte[] byArray5 = LelinkEncrypt.protocolMerge(string.getBytes(), byArray4);
        CLog.d(TAG, new String(byArray5));
        return byArray5;
    }

    public boolean parseSetupResponse(byte[] byArray) {
        if (byArray == null) {
            return false;
        }
        String string = new String(byArray);
        if (string.contains("453")) {
            this.mEncryptState = "453";
            return false;
        }
        CLog.d(TAG, string);
        byte[] byArray2 = ProtocolUtils.getBody(byArray);
        if (byArray2 == null || this.isRelase) {
            this.mEncryptState = "failed";
            return false;
        }
        TlvBox tlvBox = TlvBox.parse(byArray2, 0, byArray2.length, 2);
        if (tlvBox == null) {
            this.mEncryptState = "failed";
            return false;
        }
        this.mRcvType = tlvBox.getByteValue(1);
        this.mRcvStage = tlvBox.getByteValue(2);
        switch (this.mAtv) {
            case 1: 
            case 2: {
                this.mRcvSrpPuk = tlvBox.getBytesValue(5);
                byte[] byArray3 = tlvBox.getBytesValue(6);
                this.srp6ClientSession = new ClientSessionImpl();
                this.srp6ClientSession.step1(LELINK_USER, this.srpPassword);
                try {
                    this.srp6ClientSession.step2(SRP6CryptoParams.getInstance(2048, "SHA-1"), BigIntegerUtils.bigIntegerFromBytes(byArray3), BigIntegerUtils.bigIntegerFromBytes(this.mRcvSrpPuk));
                }
                catch (SRP6Exception sRP6Exception) {
                    CLog.w(TAG, sRP6Exception);
                }
                break;
            }
            case 0: {
                byte[] byArray4 = tlvBox.getBytesValue(3);
                System.arraycopy(byArray4, 0, this.mRcvEdPk, 0, this.mRcvEdPk.length);
                System.arraycopy(byArray4, 32, this.mRcvEdPkSalt, 0, this.mRcvEdPkSalt.length);
            }
        }
        return true;
    }

    public byte[] genVerrifyM1Request() {
        byte[] byArray;
        if (this.isRelase) {
            return null;
        }
        byte[] byArray2 = new byte[2];
        TlvBox tlvBox = new TlvBox();
        switch (this.mAtv) {
            case 1: 
            case 2: {
                byArray2[0] = 2;
                byArray2[1] = 3;
                tlvBox.putByteValue(1, byArray2[0]);
                tlvBox.putByteValue(2, byArray2[1]);
                this.mSrpPukey = BigIntegerUtils.bigIntegerToBytes(this.srp6ClientSession.getPublicClientValue());
                tlvBox.putBytesValue(5, this.mSrpPukey);
                tlvBox.putBytesValue(8, BigIntegerUtils.bigIntegerToBytes(this.srp6ClientSession.getClientEvidenceMessage()));
                break;
            }
            case 0: {
                byArray2[0] = 1;
                byArray2[1] = 3;
                byArray = new byte[64];
                this.mCurvePrkey = new byte[32];
                new Random().nextBytes(this.mCurvePrkey);
                this.mCurvePukey = new byte[32];
                Curve25519.keygen(this.mCurvePukey, null, this.mCurvePrkey);
                System.arraycopy(this.mCurvePukey, 0, byArray, 0, this.mCurvePukey.length);
                System.arraycopy(this.mEdPukey, 0, byArray, 32, this.mEdPukey.length);
                tlvBox.putByteValue(1, byArray2[0]);
                tlvBox.putByteValue(2, byArray2[1]);
                tlvBox.putBytesValue(4, byArray);
            }
        }
        byArray = tlvBox.serialize();
        String string = this.buildHeader(new NLProtocolBuiler().getVerifyCmd(), byArray.length);
        byte[] byArray3 = LelinkEncrypt.protocolMerge(string.getBytes(), byArray);
        CLog.d(TAG, new String(byArray3));
        return byArray3;
    }

    public boolean parseVerifyM1Response(byte[] byArray) {
        String string = new String(byArray);
        CLog.d(TAG, "vrify ->" + string);
        if (string.contains("603")) {
            this.mEncryptState = "603";
            return false;
        }
        byte[] byArray2 = ProtocolUtils.getBody(byArray);
        if (byArray2 == null || this.isRelase) {
            this.mEncryptState = "failed";
            return false;
        }
        TlvBox tlvBox = TlvBox.parse(byArray2, 0, byArray2.length, 3);
        if (tlvBox == null) {
            this.mEncryptState = "failed";
            return false;
        }
        this.mRcvType = tlvBox.getByteValue(1);
        this.mRcvStage = tlvBox.getByteValue(2);
        switch (this.mAtv) {
            case 1: 
            case 2: {
                byte[] byArray3 = tlvBox.getBytesValue(8);
                try {
                    this.srp6ClientSession.step3(BigIntegerUtils.bigIntegerFromBytes(byArray3));
                    this.chachaMaterKey = this.genSha512(SRP_SALT_KEY.getBytes(), this.srp6ClientSession.getSessionKeyHash(), 32);
                    this.chachaNonce = this.genSha512(SRP_SALT_IV.getBytes(), this.srp6ClientSession.getSessionKeyHash(), 16);
                    this.msrpSignMessage = new byte[64];
                    System.arraycopy(this.mSrpPukey, 0, this.msrpSignMessage, 0, 32);
                    System.arraycopy(this.mRcvSrpPuk, 0, this.msrpSignMessage, 32, 32);
                    this.mChachaSignMessage = new byte[64];
                    System.arraycopy(this.msrpSignMessage, 0, this.mChachaSignMessage, 0, this.mChachaSignMessage.length);
                    this.msrpSignature = this.chachaEncryptAndGenSignature(this.msrpSignMessage);
                    return true;
                }
                catch (SRP6Exception sRP6Exception) {
                    CLog.w(TAG, sRP6Exception);
                    break;
                }
            }
            case 0: {
                byte[] byArray4 = tlvBox.getBytesValue(4);
                this.mRcvCurvePkey = new byte[32];
                this.mRcvSignatrue = new byte[64];
                System.arraycopy(byArray4, 0, this.mRcvCurvePkey, 0, this.mRcvCurvePkey.length);
                System.arraycopy(byArray4, 32, this.mRcvSignatrue, 0, this.mRcvSignatrue.length);
                this.sharedSecret = new byte[32];
                Curve25519.curve(this.sharedSecret, this.mCurvePrkey, this.mRcvCurvePkey);
                try {
                    byte[] byArray5 = this.genSha512(SALT_KEY.getBytes(), this.sharedSecret, 16);
                    byte[] byArray6 = this.genSha512(SALT_IV.getBytes(), this.sharedSecret, 16);
                    byte[] byArray7 = new byte[64];
                    this.mEd25519Encrypt.aecrypt(byArray5, byArray6, this.mRcvSignatrue, 0, 64, byArray7, 0, false);
                    byte[] byArray8 = new byte[64];
                    System.arraycopy(this.mRcvCurvePkey, 0, byArray8, 0, this.mRcvCurvePkey.length);
                    System.arraycopy(this.mCurvePukey, 0, byArray8, 32, this.mCurvePukey.length);
                    this.mEncryptState = this.mEd25519Encrypt.verify(this.mRcvEdPk, byArray8, byArray7) ? "successful" : "failed";
                    return this.mEncryptState.equals("successful");
                }
                catch (Exception exception) {
                    CLog.w(TAG, exception);
                }
            }
        }
        this.mEncryptState = "failed";
        return false;
    }

    public byte[] genVerrifyM2Request() {
        byte[] byArray;
        Object object;
        byte[] byArray2;
        if (this.isRelase) {
            return null;
        }
        byte[] byArray3 = new byte[2];
        TlvBox tlvBox = new TlvBox();
        switch (this.mAtv) {
            case 1: 
            case 2: {
                byArray3[0] = 2;
                byArray3[1] = 5;
                tlvBox.putByteValue(1, byArray3[0]);
                tlvBox.putByteValue(2, byArray3[1]);
                tlvBox.putBytesValue(9, this.msrpSignMessage);
                tlvBox.putBytesValue(10, this.msrpSignature);
                this.mSrpSalt = new byte[32];
                new Random().nextBytes(this.mSrpSalt);
                tlvBox.putBytesValue(11, this.mSrpSalt);
                break;
            }
            case 0: {
                byArray3[0] = 1;
                byArray3[1] = 5;
                byArray2 = new byte[64];
                System.arraycopy(this.mCurvePukey, 0, byArray2, 0, this.mCurvePukey.length);
                System.arraycopy(this.mRcvCurvePkey, 0, byArray2, 32, this.mRcvCurvePkey.length);
                object = new byte[64];
                this.mEd25519Encrypt.sign(this.mEdPukey, this.mSecretkey, byArray2, (byte[])object);
                byArray = this.genSha512(IDE_VERIFY_SALT_KEY.getBytes(), this.sharedSecret, 16);
                byte[] byArray4 = this.genSha512(IDE_VERIFY_NONCE.getBytes(), this.sharedSecret, 16);
                try {
                    byte[] byArray5 = new byte[64];
                    this.mEd25519Encrypt.aecrypt(byArray, byArray4, (byte[])object, 0, 64, byArray5, 0, true);
                    tlvBox.putByteValue(1, byArray3[0]);
                    tlvBox.putByteValue(2, byArray3[1]);
                    tlvBox.putBytesValue(5, byArray5);
                    break;
                }
                catch (Exception exception) {
                    CLog.w(TAG, exception);
                }
            }
        }
        byArray2 = tlvBox.serialize();
        object = this.buildHeader(new NLProtocolBuiler().getVerifyCmd(), byArray2.length);
        byArray = LelinkEncrypt.protocolMerge(((String)object).getBytes(), byArray2);
        CLog.d(TAG, new String(byArray));
        return byArray;
    }

    public boolean parseVerifyM2Response(byte[] byArray) {
        String string = new String(byArray);
        if (string.contains("603")) {
            this.mEncryptState = "603";
            return false;
        }
        byte[] byArray2 = ProtocolUtils.getBody(byArray);
        if (byArray2 == null || byArray2.length == 0 || this.isRelase) {
            this.mEncryptState = "failed";
            return false;
        }
        TlvBox tlvBox = TlvBox.parse(byArray2, 0, byArray2.length, 4);
        if (tlvBox == null) {
            this.mEncryptState = "failed";
            return false;
        }
        switch (this.mAtv) {
            case 1: 
            case 2: {
                this.mRcvType = tlvBox.getByteValue(1);
                this.mRcvStage = tlvBox.getByteValue(2);
                byte[] byArray3 = tlvBox.getBytesValue(9);
                byte[] byArray4 = tlvBox.getBytesValue(10);
                byte[] byArray5 = tlvBox.getBytesValue(11);
                boolean bl = this.chachaDecrypt(byArray3, byArray4);
                if (!bl) break;
                this.mDeChaCha20 = null;
                this.mEnChaCha20 = null;
                byte[] byArray6 = this.genSha512(this.mSrpSalt, byArray5, 32);
                byte[] byArray7 = this.srp6ClientSession.getSessionKeyHash();
                byte[] byArray8 = new byte[32];
                System.arraycopy(byArray7, 0, byArray8, 0, byArray8.length);
                byArray6 = this.genSha512(byArray8, byArray6, 32);
                byArray6 = this.genSha512(byArray8, byArray6, 32);
                this.chachaMaterKey = this.genSha512(byArray6, SRP_IDE_SALT_KEY.getBytes(), 32);
                this.chachaNonce = this.genSha512(byArray6, SRP_IDE_NONCE.getBytes(), 32);
                break;
            }
            case 0: {
                this.mRcvType = tlvBox.getByteValue(1);
                this.mRcvStage = tlvBox.getByteValue(2);
                byte[] byArray9 = tlvBox.getBytesValue(5);
                byte[] byArray10 = this.genSha512(this.mKeySalt, this.mRcvEdPkSalt, 32);
                byArray10 = this.genSha512(this.sharedSecret, byArray10, 32);
                byArray10 = this.genSha512(this.sharedSecret, byArray10, 32);
                this.chachaMaterKey = this.genSha512(byArray10, IDE_SALT_KEY.getBytes(), 32);
                this.chachaNonce = this.genSha512(byArray10, IDE_NONCE.getBytes(), 32);
            }
        }
        return true;
    }

    private byte[] chachaEncryptAndGenSignature(byte[] byArray) {
        if (null == byArray || this.isRelase) {
            return null;
        }
        byte[] byArray2 = new byte[64];
        if (this.mEnChaCha20 == null) {
            this.mEnChaCha20 = this.chachaSetup();
            this.mEnChaCha20.encrypt(byArray2, byArray2, byArray2.length);
        } else {
            this.mEnChaCha20.encrypt(byArray2, byArray2, byArray2.length);
        }
        byte[] byArray3 = new byte[16];
        Poly1305.crypto_onetimeauth(byArray3, 0, byArray, 0, byArray.length, byArray2);
        this.mEnChaCha20.encrypt(byArray, byArray, byArray.length);
        return byArray3;
    }

    private boolean chachaDecrypt(byte[] byArray, byte[] byArray2) {
        if (null == byArray || this.isRelase) {
            return false;
        }
        if (this.mDeChaCha20 == null) {
            this.mDeChaCha20 = this.chachaSetup();
        }
        if (this.mDeChaCha20 == null) {
            return false;
        }
        byte[] byArray3 = new byte[64];
        this.mDeChaCha20.decrypt(byArray3, byArray3, byArray3.length);
        this.mDeChaCha20.decrypt(byArray, byArray, byArray.length);
        return 0 == Poly1305.crypto_onetimeauth_verify(byArray2, 0, byArray, 0, byArray.length, byArray3);
    }

    public byte[] buildEncryptData(byte[] ... byArray) {
        byte[] byArray2 = byArray[0];
        if (byArray2 == null || byArray2.length == 0 || this.isRelase) {
            return null;
        }
        byte[] byArray3 = new byte[4];
        int n2 = byArray2.length;
        byArray3[0] = (byte)(n2 & 0xFF);
        byArray3[1] = (byte)(n2 >> 8 & 0xFF);
        byArray3[2] = (byte)(n2 >> 16 & 0xFF);
        byArray3[3] = (byte)(n2 >> 24 & 0xFF);
        try {
            byte[] byArray4 = this.chachaEncryptAndGenSignature(byArray2);
            byte[] byArray5 = new byte[byArray3.length + byArray2.length + byArray4.length];
            System.arraycopy(byArray3, 0, byArray5, 0, byArray3.length);
            System.arraycopy(byArray2, 0, byArray5, byArray3.length, byArray2.length);
            System.arraycopy(byArray4, 0, byArray5, byArray3.length + byArray2.length, byArray4.length);
            return byArray5;
        }
        catch (Exception exception) {
            CLog.w(TAG, exception);
            return null;
        }
    }

    public byte[] decryptData(byte[] byArray) {
        if (byArray == null || byArray.length == 0 || this.isRelase) {
            return null;
        }
        int n2 = byArray[0] & 0xFF | (byArray[1] & 0xFF) << 8 | (byArray[2] & 0xFF) << 16 | (byArray[3] & 0xFF) << 24;
        if (n2 > 5120) {
            return null;
        }
        try {
            byte[] byArray2 = new byte[n2];
            byte[] byArray3 = new byte[16];
            System.arraycopy(byArray, 4, byArray2, 0, byArray2.length);
            System.arraycopy(byArray, 4 + n2, byArray3, 0, byArray3.length);
            this.chachaDecrypt(byArray2, byArray3);
            return byArray2;
        }
        catch (Exception exception) {
            CLog.w(TAG, exception);
            return null;
        }
    }

    public ChaCha20 chachaSetup() {
        ChaCha20 chaCha20 = null;
        try {
            if (this.isRelase) {
                return null;
            }
            if (this.chachaMaterKey.length > 8) {
                byte[] byArray = new byte[8];
                System.arraycopy(this.chachaNonce, 0, byArray, 0, 8);
                chaCha20 = new ChaCha20(this.chachaMaterKey, byArray, 0);
            } else {
                chaCha20 = new ChaCha20(this.chachaMaterKey, this.chachaNonce, 0);
            }
        }
        catch (ChaCha20.WrongKeySizeException | ChaCha20.WrongNonceSizeException exception) {
            CLog.w(TAG, exception);
        }
        return chaCha20;
    }

    String buildHeader(NLProtocolBuiler nLProtocolBuiler, int n2) {
        return nLProtocolBuiler.setPlatfrom().setUserAgent("HappyCast5,0/500.0").setNewLelinkClientId("0xff99ffex0022").setNewSessionId(this.mSessionId).setContentType("application/octet-stream").setContentLength(n2 + "").getString(true);
    }

    static byte[] protocolMerge(byte[] byArray, byte[] byArray2) {
        byte[] byArray3 = new byte[byArray.length + byArray2.length];
        System.arraycopy(byArray, 0, byArray3, 0, byArray.length);
        System.arraycopy(byArray2, 0, byArray3, byArray.length, byArray2.length);
        return byArray3;
    }

    String bytesToHex(byte[] byArray) {
        if (this.isDebug) {
            return ProtocolUtils.bytesToHex(byArray);
        }
        return "";
    }

    byte[] genSha512(byte[] byArray, byte[] byArray2, int n2) {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-512");
            messageDigest.update(byArray);
            messageDigest.update(byArray2);
            byte[] byArray3 = Arrays.copyOfRange(messageDigest.digest(), 0, n2);
            return byArray3;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            CLog.w(TAG, noSuchAlgorithmException);
            return null;
        }
    }

    public String getEncryptState() {
        return this.mEncryptState;
    }

    public String getSrpPassword() {
        return this.srpPassword;
    }

    public void release() {
        this.isRelase = true;
        this.mRcvEdPk = null;
        this.mRcvEdPkSalt = null;
        this.mRcvType = 0;
        this.mRcvStage = 0;
        this.mSecretkey = null;
        this.mEdPukey = null;
        this.mKeySalt = null;
        this.mType = 0;
        this.mStage = 0;
        this.mCurvePukey = null;
        this.mCurvePrkey = null;
        this.mRcvCurvePkey = null;
        this.mRcvSignatrue = null;
        this.sharedSecret = null;
        this.mSessionId = null;
        this.chachaMaterKey = null;
        this.chachaNonce = null;
        this.mEnChaCha20 = null;
        this.mDeChaCha20 = null;
    }
}

