/*
 * Decompiled with CFR 0.152.
 */
package com.ble.mycdmmanager;

import android.app.Activity;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothGatt;
import android.bluetooth.BluetoothGattCharacteristic;
import android.companion.AssociationRequest;
import android.companion.BluetoothDeviceFilter;
import android.companion.CompanionDeviceManager;
import android.companion.DeviceFilter;
import android.content.Intent;
import android.content.IntentSender;
import android.os.Build;
import android.util.Log;
import com.ble.mycdmmanager.CMDScanState;
import com.ble.mycdmmanager.CMDScannerCallback;
import java.util.UUID;
import java.util.regex.Pattern;

class MyCDMScanner {
    private static final String TAG = "MyCDMScanner";
    private static final int REQ_CODE = 2025;
    private static final int PERMISSION_REQ_CODE = 999;
    private final Activity activity;
    private final CompanionDeviceManager cdm;
    private CMDScannerCallback callback;
    private BluetoothDevice pendingDevice = null;
    private BluetoothGatt gatt;
    private BluetoothGattCharacteristic writeChar;
    private BluetoothGattCharacteristic notifyChar;
    private UUID UUID_SERVICE;
    private UUID UUID_WRITE;
    private UUID UUID_NOTIFY;

    public MyCDMScanner(Activity activity) {
        this.activity = activity;
        this.cdm = (CompanionDeviceManager)activity.getSystemService(CompanionDeviceManager.class);
    }

    public MyCDMScanner(Activity activity, CMDScannerCallback callback) {
        this.activity = activity;
        this.callback = callback;
        this.cdm = (CompanionDeviceManager)activity.getSystemService(CompanionDeviceManager.class);
    }

    public void scan(String pattern) {
        Log.d((String)TAG, (String)("Start scan, pattern = " + pattern));
        BluetoothDeviceFilter filter = new BluetoothDeviceFilter.Builder().setNamePattern(Pattern.compile(pattern)).build();
        AssociationRequest.Builder builder = new AssociationRequest.Builder().addDeviceFilter((DeviceFilter)filter).setSingleDevice(true);
        AssociationRequest request = builder.build();
        this.cdm.associate(request, new CompanionDeviceManager.Callback(){

            public void onDeviceFound(IntentSender chooserLauncher) {
                Log.d((String)MyCDMScanner.TAG, (String)"Device picker shown");
                try {
                    MyCDMScanner.this.activity.startIntentSenderForResult(chooserLauncher, 2025, null, 0, 0, 0);
                }
                catch (Exception e) {
                    Log.e((String)MyCDMScanner.TAG, (String)("Launcher error: " + e.getMessage()));
                }
            }

            public void onFailure(CharSequence error) {
                Log.e((String)MyCDMScanner.TAG, (String)("Scan failed: " + error));
                if (MyCDMScanner.this.callback != null) {
                    MyCDMScanner.this.callback.onScanFailed(CMDScanState.UNKNOWN_ERROR, error.toString());
                }
            }
        }, null);
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        Log.d((String)TAG, (String)("onActivityResult: req=" + requestCode + " result=" + resultCode));
        if (requestCode != 2025 || resultCode != -1) {
            return;
        }
        if (data == null) {
            Log.e((String)TAG, (String)"Data is NULL!");
            return;
        }
        BluetoothDevice device = (BluetoothDevice)data.getParcelableExtra("android.companion.extra.DEVICE");
        if (device == null) {
            Log.e((String)TAG, (String)"EXTRA_DEVICE is NULL!");
            return;
        }
        Log.d((String)TAG, (String)("User selected device: " + device.getAddress()));
        this.pendingDevice = device;
        this.resumePendingAction();
    }

    public void resumePendingAction() {
        if (this.pendingDevice == null) {
            Log.e((String)TAG, (String)"resumePendingAction: pendingDevice NULL");
            return;
        }
        BluetoothDevice device = this.pendingDevice;
        this.pendingDevice = null;
        try {
            Log.d((String)TAG, (String)("Continue action on device: " + device.getName() + " / " + device.getAddress()));
            if (Build.VERSION.SDK_INT >= 19) {
                device.createBond();
            }
        }
        catch (SecurityException se) {
            Log.e((String)TAG, (String)"SecurityException: BLUETOOTH_CONNECT permission missing when createBond()");
        }
        Log.i((String)TAG, (String)("device.getAddress:" + device.getAddress()));
        if (this.callback != null) {
            this.callback.onDeviceFound(device.getName(), device.getAddress());
        }
    }
}

