/*
 * Decompiled with CFR 0.152.
 */
package com.ble.mycdmmanager;

import android.app.Activity;
import android.bluetooth.BluetoothDevice;
import android.companion.AssociationRequest;
import android.companion.BluetoothDeviceFilter;
import android.companion.CompanionDeviceManager;
import android.companion.DeviceFilter;
import android.content.Intent;
import android.content.IntentSender;
import android.os.Bundle;
import android.os.Handler;
import android.os.HandlerThread;
import android.util.Log;
import com.ble.mycdmmanager.CMDScanState;
import com.ble.mycdmmanager.CMDScannerCallback;
import java.util.List;
import java.util.regex.Pattern;

public class CMDTransparentProxyActivity
extends Activity {
    private static final String TAG = "CMDTransparentProxyActivity";
    public static final String EXTRA_PATTERN = "pattern";
    private static final int REQ_CODE = 2025;
    private CompanionDeviceManager cdm;
    public static CMDScannerCallback globalCMDScannerCallback = null;
    private static final HandlerThread wrapperThread = new HandlerThread("CMD-Scan-Delay");
    private static Handler wrapperHandler;
    private CMDScanState currentState = CMDScanState.UNKNOWN_ERROR;
    private String errorStr = "";

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.getWindow().getDecorView().setSystemUiVisibility(5890);
        this.getWindow().setNavigationBarColor(0);
        this.getWindow().setStatusBarColor(0);
        this.getWindow().addFlags(16);
        String pattern = this.getIntent().getStringExtra(EXTRA_PATTERN);
        this.cdm = (CompanionDeviceManager)this.getSystemService(CompanionDeviceManager.class);
        this.scan(pattern);
    }

    public void scan(String pattern) {
        BluetoothDeviceFilter filter = new BluetoothDeviceFilter.Builder().setNamePattern(Pattern.compile(pattern)).build();
        AssociationRequest request = new AssociationRequest.Builder().addDeviceFilter((DeviceFilter)filter).setSingleDevice(true).build();
        this.cdm.associate(request, new CompanionDeviceManager.Callback(){

            public void onDeviceFound(IntentSender chooserLauncher) {
                try {
                    CMDTransparentProxyActivity.this.startIntentSenderForResult(chooserLauncher, 2025, null, 0, 0, 0);
                }
                catch (Exception e) {
                    Log.e((String)CMDTransparentProxyActivity.TAG, (String)("Launcher error: " + e.getMessage()));
                    if (globalCMDScannerCallback != null) {
                        globalCMDScannerCallback.onScanFailed(CMDScanState.UNKNOWN_ERROR, e.getMessage());
                    }
                    CMDTransparentProxyActivity.this.finishSafely();
                }
            }

            public void onFailure(CharSequence error) {
                String err = error == null ? "" : error.toString();
                CMDTransparentProxyActivity.this.errorStr = err;
                if ("canceled".equals(err)) {
                    CMDTransparentProxyActivity.this.currentState = CMDScanState.USER_CANCEL;
                } else if ("discovery_timeout".equals(err)) {
                    CMDTransparentProxyActivity.this.currentState = CMDScanState.TIMEOUT;
                } else {
                    CMDTransparentProxyActivity.this.currentState = CMDScanState.UNKNOWN_ERROR;
                }
                if (globalCMDScannerCallback != null) {
                    switch (CMDTransparentProxyActivity.this.currentState) {
                        case USER_CANCEL: {
                            globalCMDScannerCallback.onScanFailed(CMDScanState.USER_CANCEL, CMDTransparentProxyActivity.this.errorStr);
                            break;
                        }
                        case TIMEOUT: {
                            globalCMDScannerCallback.onScanFailed(CMDScanState.TIMEOUT, CMDTransparentProxyActivity.this.errorStr);
                            break;
                        }
                        default: {
                            globalCMDScannerCallback.onScanFailed(CMDScanState.UNKNOWN_ERROR, CMDTransparentProxyActivity.this.errorStr);
                        }
                    }
                }
                CMDTransparentProxyActivity.this.finishSafely();
            }
        }, null);
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (requestCode != 2025) {
            return;
        }
        if (resultCode != -1) {
            return;
        }
        if (data == null) {
            Log.d((String)TAG, (String)"onActivityResult DATA NULL");
            if (globalCMDScannerCallback != null) {
                globalCMDScannerCallback.onScanFailed(CMDScanState.DATA_NULL, "Data is NULL");
            }
            this.finishSafely();
            return;
        }
        BluetoothDevice device = (BluetoothDevice)data.getParcelableExtra("android.companion.extra.DEVICE");
        if (device == null) {
            Log.d((String)TAG, (String)"onActivityResult device NULL");
            if (globalCMDScannerCallback != null) {
                globalCMDScannerCallback.onScanFailed(CMDScanState.DEVICE_NULL, "Device is NULL");
            }
            this.finishSafely();
            return;
        }
        wrapperHandler.postDelayed(() -> {
            this.runOnUiThread(() -> {
                if (globalCMDScannerCallback != null) {
                    globalCMDScannerCallback.onDeviceFound(device.getName(), device.getAddress());
                }
            });
            List associations = this.cdm.getAssociations();
            for (String a : associations) {
                if (!a.equalsIgnoreCase(device.getAddress())) continue;
                this.cdm.disassociate(a);
                Log.d((String)"CMD", (String)("Disassociated " + a));
            }
            this.finishSafely();
        }, 800L);
    }

    private void finishSafely() {
        wrapperHandler.removeCallbacksAndMessages(null);
        globalCMDScannerCallback = null;
        if (!this.isFinishing()) {
            this.finish();
            this.overridePendingTransition(0, 0);
        }
    }

    static {
        wrapperThread.start();
        wrapperHandler = new Handler(wrapperThread.getLooper());
    }
}

