/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.sdk.source.process;

import android.content.Context;
import android.hardware.display.VirtualDisplay;
import android.net.Uri;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.text.TextUtils;
import com.hpplay.sdk.source.a.a;
import com.hpplay.sdk.source.api.IBindSdkListener;
import com.hpplay.sdk.source.api.ICloudMirrorPlayListener;
import com.hpplay.sdk.source.api.ICommonListener;
import com.hpplay.sdk.source.api.IConnectListener;
import com.hpplay.sdk.source.api.IDaPlayerListener;
import com.hpplay.sdk.source.api.IDebugAVListener;
import com.hpplay.sdk.source.api.ILelinkPlayerListener;
import com.hpplay.sdk.source.api.ILelinkSourceSDK;
import com.hpplay.sdk.source.api.ILogCallback;
import com.hpplay.sdk.source.api.IMirrorChangeListener;
import com.hpplay.sdk.source.api.INewPlayerListener;
import com.hpplay.sdk.source.api.IRelevantInfoListener;
import com.hpplay.sdk.source.api.ISearchBannerDataCallback;
import com.hpplay.sdk.source.api.ISendPassCallback;
import com.hpplay.sdk.source.api.ISinkKeyEventListener;
import com.hpplay.sdk.source.api.ISinkTouchEventListener;
import com.hpplay.sdk.source.api.LelinkPlayerInfo;
import com.hpplay.sdk.source.bean.AudioFrameBean;
import com.hpplay.sdk.source.bean.DanmakuBean;
import com.hpplay.sdk.source.bean.DanmakuPropertyBean;
import com.hpplay.sdk.source.bean.DebugTimestampBean;
import com.hpplay.sdk.source.bean.DramaInfoBean;
import com.hpplay.sdk.source.bean.SinkParameterBean;
import com.hpplay.sdk.source.bean.SinkTouchEventArea;
import com.hpplay.sdk.source.bean.VideoFrameBean;
import com.hpplay.sdk.source.browse.api.AuthListener;
import com.hpplay.sdk.source.browse.api.IAPICallbackListener;
import com.hpplay.sdk.source.browse.api.IBrowseListener;
import com.hpplay.sdk.source.browse.api.ICreatePinCodeListener;
import com.hpplay.sdk.source.browse.api.ICreateShortUrlListener;
import com.hpplay.sdk.source.browse.api.IServiceInfoParseListener;
import com.hpplay.sdk.source.browse.api.LelinkServiceInfo;
import com.hpplay.sdk.source.c;
import com.hpplay.sdk.source.common.store.Session;
import com.hpplay.sdk.source.log.SourceLog;
import com.hpplay.sdk.source.o;
import com.hpplay.sdk.source.process.DebugTSThread;
import com.hpplay.sdk.source.process.LelinkSdkManager;
import com.hpplay.sdk.source.process.LelinkServiceConnection;
import com.hpplay.sdk.source.utils.HpplayUtil;
import com.hpplay.sdk.source.v;
import java.util.ArrayList;
import java.util.List;

public class LelinkSourceSDKImpProxy
implements ILelinkSourceSDK {
    private static final String TAG = "LelinkSourceSdkImpProxy";
    private static LelinkSourceSDKImpProxy sInstance = new LelinkSourceSDKImpProxy();
    private v mMultiManager;
    private LelinkServiceConnection mMultiConnection;
    private boolean isMultiProcessBind = false;
    private LelinkSdkManager mSingleManager;
    private boolean isDebug = true;
    private boolean isDebugTimestamp = false;
    private IDebugAVListener mAppDebugAVListener;
    private IBrowseListener mAppBrowseListener;
    private IConnectListener mAppConnectListener;
    private ILelinkPlayerListener mAppLelinkPlayerListener;
    private INewPlayerListener mAppNewPlayerListener;
    private IDaPlayerListener mAppDaPlayerListener;
    private AuthListener mAppAuthListener;
    private ICommonListener mCommonListener;
    private long startDebugTime = 0L;
    private DebugTSThread mDebugTSThread;
    private static final int MAX_TRYBIND = 3;
    private int mBindCount = 0;
    private boolean isSetDebugModeWork = false;
    private Handler mHandler = new Handler(Looper.getMainLooper(), new Handler.Callback(){

        public boolean handleMessage(Message message) {
            return false;
        }
    });
    private IRelevantInfoListener mAppRelevantInfoListener;
    private o mRelevantInfoListener = new o.a(){

        @Override
        public void onSendRelevantInfoResult(int n2, String string) {
            if (LelinkSourceSDKImpProxy.this.mAppRelevantInfoListener != null) {
                LelinkSourceSDKImpProxy.this.mAppRelevantInfoListener.onSendRelevantInfoResult(n2, string);
            }
        }

        @Override
        public void onReverseInfoResult(int n2, String string) {
            if (LelinkSourceSDKImpProxy.this.mAppRelevantInfoListener != null) {
                LelinkSourceSDKImpProxy.this.mAppRelevantInfoListener.onReverseInfoResult(n2, string);
            }
        }
    };
    private ICloudMirrorPlayListener mAppCloudMirrorPlayListener;
    private c mCloudMirrorPlayListener = new c.a(){

        @Override
        public void onCloudMirrorStart(boolean bl, String string, String string2, String string3, String string4, String string5) {
            if (LelinkSourceSDKImpProxy.this.mAppCloudMirrorPlayListener != null) {
                LelinkSourceSDKImpProxy.this.mAppCloudMirrorPlayListener.onCloudMirrorStart(bl, string, string2, string3, string4, string5);
            }
        }

        @Override
        public void onCloudMirrorStop() {
            if (LelinkSourceSDKImpProxy.this.mAppCloudMirrorPlayListener != null) {
                LelinkSourceSDKImpProxy.this.mAppCloudMirrorPlayListener.onCloudMirrorStop();
            }
        }

        @Override
        public void onCloudMessage(long l2, String string) {
            if (LelinkSourceSDKImpProxy.this.mAppCloudMirrorPlayListener != null) {
                LelinkSourceSDKImpProxy.this.mAppCloudMirrorPlayListener.onCloudMessage(l2, string);
            }
        }
    };

    public static synchronized LelinkSourceSDKImpProxy getInstance() {
        return sInstance;
    }

    private LelinkSourceSDKImpProxy() {
    }

    public void setMultiManager(v v2, LelinkServiceConnection lelinkServiceConnection) {
        this.isMultiProcessBind = true;
        this.mMultiManager = v2;
        this.mMultiConnection = lelinkServiceConnection;
        this.mMultiConnection.setDebugAVListener(this.mAppDebugAVListener);
        this.mMultiConnection.setBrowseResultListener(this.mAppBrowseListener);
        this.mMultiConnection.setConnectListener(this.mAppConnectListener);
        this.mMultiConnection.setPlayListener(this.mAppLelinkPlayerListener);
        this.mMultiConnection.setNewPlayListener(this.mAppNewPlayerListener);
        this.mMultiConnection.setDaPlayListener(this.mAppDaPlayerListener);
        this.mMultiConnection.setAuthListener(this.mAppAuthListener);
        if (!this.isSetDebugModeWork) {
            this.mMultiConnection.setDebugMode(this.isDebug);
        }
        this.mMultiConnection.setCommonListener(this.mCommonListener);
    }

    public void setSingleManager(LelinkSdkManager lelinkSdkManager) {
        this.mSingleManager = lelinkSdkManager;
        this.mSingleManager.setDebugAVListener(this.mAppDebugAVListener);
        this.mSingleManager.setBrowseListener(this.mAppBrowseListener);
        this.mSingleManager.setConnectListener(this.mAppConnectListener);
        this.mSingleManager.setPlayerListener(this.mAppLelinkPlayerListener);
        this.mSingleManager.setNewPlayerListener(this.mAppNewPlayerListener);
        this.mSingleManager.setDaPlayListener(this.mAppDaPlayerListener);
        this.mSingleManager.setAuthListener(this.mAppAuthListener);
        this.mSingleManager.setCommonListener(this.mCommonListener);
    }

    @Override
    public void bindSdk(Context context, String string, String string2, IBindSdkListener iBindSdkListener) {
    }

    @Override
    public void bindSdk(Context context, String string, String string2, String string3, IBindSdkListener iBindSdkListener) {
    }

    @Override
    public void bindSdk(Context context, String string, String string2, String string3, String string4, String string5, IBindSdkListener iBindSdkListener) {
    }

    @Override
    public void setDebugMode(boolean bl) {
        this.isDebug = bl;
        if (a.a() && !this.isMultiProcessBind) {
            SourceLog.w(TAG, "service is binding");
            this.isSetDebugModeWork = false;
            return;
        }
        if (this.isMultiProcessBind) {
            try {
                this.mMultiConnection.setDebugMode(bl);
                this.isSetDebugModeWork = true;
                SourceLog.i(TAG, "setDebugMode," + bl);
            }
            catch (Exception exception) {
                SourceLog.w(TAG, exception);
            }
        } else if (this.mSingleManager != null) {
            this.mSingleManager.isDebug(bl);
        }
    }

    @Override
    public void setDebugTimestamp(boolean bl) {
        this.isDebugTimestamp = bl;
        if (this.isMultiProcessBind) {
            try {
                this.mMultiConnection.setDebugTimestamp(bl);
            }
            catch (Exception exception) {
                SourceLog.w(TAG, exception);
            }
        } else if (this.mSingleManager != null) {
            this.mSingleManager.isDebugTimestamp(bl);
        }
    }

    @Override
    public void unBindSdk() {
        try {
            if (this.isMultiProcessBind) {
                this.mMultiConnection.unBind();
            } else if (this.mSingleManager != null) {
                this.mSingleManager.release();
            }
        }
        catch (Exception exception) {
            SourceLog.w(TAG, exception);
        }
    }

    @Override
    public void setDebugAVListener(IDebugAVListener iDebugAVListener) {
        this.mAppDebugAVListener = iDebugAVListener;
        SourceLog.i(TAG, "LelinkSourceSdkImp setDebugAVListener " + this.isMultiProcessBind);
        try {
            if (this.isMultiProcessBind) {
                this.mMultiConnection.setDebugAVListener(iDebugAVListener);
            } else if (this.mSingleManager != null) {
                this.mSingleManager.setDebugAVListener(iDebugAVListener);
            }
        }
        catch (Exception exception) {
            SourceLog.w(TAG, exception);
        }
    }

    @Override
    public void setBrowseResultListener(IBrowseListener iBrowseListener) {
        this.mAppBrowseListener = iBrowseListener;
        SourceLog.i(TAG, "LelinkSourceSdkImp setBrowseResultListener " + this.isMultiProcessBind);
        try {
            if (this.isMultiProcessBind) {
                this.mMultiConnection.setBrowseResultListener(iBrowseListener);
            } else if (this.mSingleManager != null) {
                this.mSingleManager.setBrowseListener(iBrowseListener);
            }
        }
        catch (Exception exception) {
            SourceLog.w(TAG, exception);
        }
    }

    @Override
    public void setConnectListener(IConnectListener iConnectListener) {
        this.mAppConnectListener = iConnectListener;
        try {
            SourceLog.i(TAG, "LelinkSourceSdkImp setConnectListener " + this.isMultiProcessBind);
            if (this.isMultiProcessBind) {
                this.mMultiConnection.setConnectListener(iConnectListener);
            } else if (this.mSingleManager != null) {
                this.mSingleManager.setConnectListener(iConnectListener);
            }
        }
        catch (Exception exception) {
            SourceLog.w(TAG, exception);
        }
    }

    @Override
    public void setPlayListener(ILelinkPlayerListener iLelinkPlayerListener) {
        this.mAppLelinkPlayerListener = iLelinkPlayerListener;
        SourceLog.i(TAG, "setPlayListener " + this.isMultiProcessBind);
        try {
            if (this.isMultiProcessBind) {
                this.mMultiConnection.setPlayListener(iLelinkPlayerListener);
            } else if (this.mSingleManager != null) {
                this.mSingleManager.setPlayerListener(iLelinkPlayerListener);
            }
        }
        catch (Exception exception) {
            SourceLog.w(TAG, exception);
        }
    }

    @Override
    public void setNewPlayListener(INewPlayerListener iNewPlayerListener) {
        this.mAppNewPlayerListener = iNewPlayerListener;
        SourceLog.i(TAG, "setNewPlayListener " + this.isMultiProcessBind);
        try {
            if (this.isMultiProcessBind) {
                this.mMultiConnection.setNewPlayListener(iNewPlayerListener);
            } else if (this.mSingleManager != null) {
                this.mSingleManager.setNewPlayerListener(iNewPlayerListener);
            }
        }
        catch (Exception exception) {
            SourceLog.w(TAG, exception);
        }
    }

    @Override
    public void setDaPlayListener(IDaPlayerListener iDaPlayerListener) {
        this.mAppDaPlayerListener = iDaPlayerListener;
        SourceLog.i(TAG, "setDaPlayListener " + this.isMultiProcessBind);
        try {
            if (this.isMultiProcessBind) {
                this.mMultiConnection.setDaPlayListener(iDaPlayerListener);
            } else if (this.mSingleManager != null) {
                this.mSingleManager.setDaPlayListener(iDaPlayerListener);
            }
        }
        catch (Exception exception) {
            SourceLog.w(TAG, exception);
        }
    }

    @Override
    public void startBrowse(boolean bl, boolean bl2) {
        SourceLog.i(TAG, "startBrowse " + this.isMultiProcessBind);
        if (this.isMultiProcessBind) {
            try {
                this.mMultiManager.browse(bl, bl2);
            }
            catch (Exception exception) {
                SourceLog.w(TAG, exception);
                this.retryBind();
            }
        } else if (this.mSingleManager != null) {
            this.mSingleManager.startBrowseThread(bl, bl2);
        }
    }

    @Override
    public void stopBrowse() {
        SourceLog.i(TAG, "LelinkSourceSdkImp stopBrowse " + this.isMultiProcessBind);
        if (this.isMultiProcessBind) {
            try {
                this.mMultiManager.stopBrowse();
            }
            catch (Exception exception) {
                SourceLog.w(TAG, exception);
                this.retryBind();
            }
        } else if (this.mSingleManager != null) {
            this.mSingleManager.stopBrowseThread();
        }
    }

    @Override
    public void connect(LelinkServiceInfo lelinkServiceInfo) {
        if (this.isMultiProcessBind) {
            try {
                this.mMultiManager.connect(lelinkServiceInfo);
            }
            catch (Exception exception) {
                SourceLog.w(TAG, exception);
                this.retryBind();
            }
        } else if (this.mSingleManager != null) {
            this.mSingleManager.connect(lelinkServiceInfo);
        }
    }

    @Override
    public boolean disconnect(LelinkServiceInfo lelinkServiceInfo) {
        if (this.isMultiProcessBind) {
            try {
                return this.mMultiManager.disconnect(lelinkServiceInfo);
            }
            catch (Exception exception) {
                SourceLog.w(TAG, exception);
                this.retryBind();
            }
        } else if (this.mSingleManager != null) {
            return this.mSingleManager.disconnect(lelinkServiceInfo);
        }
        return true;
    }

    @Override
    public List<LelinkServiceInfo> getConnectInfos() {
        if (this.isMultiProcessBind) {
            try {
                return this.mMultiManager.getConnectInfos();
            }
            catch (Exception exception) {
                SourceLog.w(TAG, exception);
                this.retryBind();
            }
        } else if (this.mSingleManager != null) {
            return this.mSingleManager.getConnectInfos();
        }
        return null;
    }

    @Override
    public void startMirror(LelinkPlayerInfo lelinkPlayerInfo) {
        SourceLog.i(TAG, "startMirror " + this.isMultiProcessBind);
        if (this.isMultiProcessBind) {
            try {
                this.mMultiManager.startMirrorForPlayerInfo(lelinkPlayerInfo);
            }
            catch (Exception exception) {
                SourceLog.w(TAG, exception);
                this.retryBind();
            }
        } else if (this.mSingleManager != null) {
            this.mSingleManager.startMirror(lelinkPlayerInfo);
            this.startDebugThread();
        }
    }

    public void startDebugThread() {
        if (!Session.getInstance().getDebugTimestamp()) {
            return;
        }
        if (System.currentTimeMillis() - this.startDebugTime < 200L) {
            return;
        }
        if (this.mDebugTSThread == null || !this.mDebugTSThread.isAlive()) {
            DebugTimestampBean debugTimestampBean = new DebugTimestampBean();
            Session.getInstance().setDebugTimestampBean(debugTimestampBean);
            this.mDebugTSThread = new DebugTSThread(debugTimestampBean);
            this.mDebugTSThread.start();
        }
        this.mDebugTSThread.startThread();
        this.startDebugTime = System.currentTimeMillis();
    }

    @Override
    public void resume() {
        if (this.isMultiProcessBind) {
            try {
                this.mMultiManager.resume();
            }
            catch (Exception exception) {
                SourceLog.w(TAG, exception);
                this.retryBind();
            }
        } else if (this.mSingleManager != null) {
            this.mSingleManager.resume();
        }
    }

    @Override
    public void pause() {
        if (this.isMultiProcessBind) {
            try {
                this.mMultiManager.pause();
            }
            catch (Exception exception) {
                SourceLog.w(TAG, exception);
                this.retryBind();
            }
        } else if (this.mSingleManager != null) {
            this.mSingleManager.pause();
        }
    }

    @Override
    public void addVolume() {
        if (this.isMultiProcessBind) {
            try {
                this.mMultiManager.addVolume();
            }
            catch (Exception exception) {
                SourceLog.w(TAG, exception);
                this.retryBind();
            }
        } else if (this.mSingleManager != null) {
            this.mSingleManager.addVolume();
        }
    }

    @Override
    public void subVolume() {
        if (this.isMultiProcessBind) {
            try {
                this.mMultiManager.subVolume();
            }
            catch (Exception exception) {
                SourceLog.w(TAG, exception);
                this.retryBind();
            }
        } else if (this.mSingleManager != null) {
            this.mSingleManager.subVolume();
        }
    }

    @Override
    public void setVolume(int n2) {
        if (this.isMultiProcessBind) {
            try {
                this.mMultiManager.setVolume(n2);
            }
            catch (Exception exception) {
                SourceLog.w(TAG, exception);
                this.retryBind();
            }
        } else if (this.mSingleManager != null) {
            this.mSingleManager.setVolume(n2);
        }
    }

    @Override
    public void seekTo(int n2) {
        if (this.isMultiProcessBind) {
            try {
                this.mMultiManager.seekTo(n2);
            }
            catch (Exception exception) {
                SourceLog.w(TAG, exception);
                this.retryBind();
            }
        } else if (this.mSingleManager != null) {
            this.mSingleManager.seekTo(n2);
        }
    }

    @Override
    public void startPlayMedia(String string, int n2, boolean bl) {
        if (this.isMultiProcessBind) {
            try {
                this.mMultiManager.startPlayMedia(string, n2, bl);
            }
            catch (Exception exception) {
                SourceLog.w(TAG, exception);
                this.retryBind();
            }
        } else if (this.mSingleManager != null) {
            this.mSingleManager.startPlayMedia(null, string, n2, bl);
        }
    }

    @Override
    public void startPlayMedia(LelinkPlayerInfo lelinkPlayerInfo) {
        if (this.isMultiProcessBind) {
            try {
                this.mMultiManager.startPlayMediaForPlayerInfo(lelinkPlayerInfo);
            }
            catch (Exception exception) {
                SourceLog.w(TAG, exception);
                this.retryBind();
            }
        } else if (this.mSingleManager != null) {
            this.mSingleManager.startPlayCheck(lelinkPlayerInfo);
        }
    }

    @Override
    public void startPlayMediaImmed(LelinkServiceInfo lelinkServiceInfo, String string, int n2, boolean bl) {
        if (this.isMultiProcessBind) {
            try {
                this.mMultiManager.startPlayMediaImmed(lelinkServiceInfo, string, n2, bl);
            }
            catch (Exception exception) {
                SourceLog.w(TAG, exception);
                this.retryBind();
            }
        } else if (this.mSingleManager != null) {
            this.mSingleManager.startPlayMedia(lelinkServiceInfo, string, n2, bl);
        }
    }

    @Override
    public void startPlayMediaImmed(LelinkServiceInfo lelinkServiceInfo, Uri uri, int n2) {
        LelinkPlayerInfo lelinkPlayerInfo = new LelinkPlayerInfo();
        lelinkPlayerInfo.setLelinkServiceInfo(lelinkServiceInfo);
        lelinkPlayerInfo.setLocalUri(uri);
        lelinkPlayerInfo.setType(n2);
        if (this.isMultiProcessBind) {
            try {
                this.mMultiManager.startPlayMediaForPlayerInfo(lelinkPlayerInfo);
            }
            catch (Exception exception) {
                SourceLog.w(TAG, exception);
                this.retryBind();
            }
        } else if (this.mSingleManager != null) {
            this.mSingleManager.startPlayCheck(lelinkPlayerInfo);
        }
    }

    @Override
    public void stopPlay() {
        if (this.isMultiProcessBind) {
            try {
                this.mMultiManager.stopPlay();
            }
            catch (Exception exception) {
                SourceLog.w(TAG, exception);
                this.retryBind();
            }
        } else if (this.mSingleManager != null) {
            this.mSingleManager.stopPlay();
            this.stopDebugThread();
        }
    }

    public void stopDebugThread() {
        if (this.mDebugTSThread != null && System.currentTimeMillis() - this.startDebugTime > 200L) {
            this.mDebugTSThread.stopThread();
        }
    }

    @Override
    public void addQRCodeToLelinkServiceInfo(String string, IServiceInfoParseListener iServiceInfoParseListener) {
        if (this.isMultiProcessBind) {
            try {
                this.mMultiConnection.setServiceInfoParseListener(iServiceInfoParseListener);
                this.mMultiManager.addQRCodeToLelinkServiceInfo(string);
            }
            catch (Exception exception) {
                SourceLog.w(TAG, exception);
            }
        } else if (this.mSingleManager != null) {
            this.mSingleManager.setServiceInfoParseListener(iServiceInfoParseListener);
            this.mSingleManager.addQRCodeToLelinkServiceInfo(string);
        }
    }

    @Override
    public void createPinCode(ICreatePinCodeListener iCreatePinCodeListener) {
        if (this.isMultiProcessBind) {
            try {
                this.mMultiConnection.setAICreatePinCodeListener(iCreatePinCodeListener);
                this.mMultiManager.createPinCode();
            }
            catch (Exception exception) {
                SourceLog.w(TAG, exception);
            }
        } else if (this.mSingleManager != null) {
            this.mSingleManager.createPinCode(iCreatePinCodeListener);
        }
    }

    @Override
    public void createShortUrl(ICreateShortUrlListener iCreateShortUrlListener) {
        if (this.isMultiProcessBind) {
            try {
                this.mMultiConnection.setAICreateShortUrlListener(iCreateShortUrlListener);
                this.mMultiManager.createShortUrl();
            }
            catch (Exception exception) {
                SourceLog.w(TAG, exception);
            }
        } else if (this.mSingleManager != null) {
            this.mSingleManager.createShortUrl(iCreateShortUrlListener);
        }
    }

    @Override
    public void addPinCodeToLelinkServiceInfo(String string, IServiceInfoParseListener iServiceInfoParseListener) {
        if (this.isMultiProcessBind) {
            try {
                this.mMultiConnection.setServiceInfoParseListener(iServiceInfoParseListener);
                this.mMultiManager.addPinCodeToLelinkServiceInfo(string);
            }
            catch (Exception exception) {
                SourceLog.w(TAG, exception);
            }
        } else if (this.mSingleManager != null) {
            this.mSingleManager.setServiceInfoParseListener(iServiceInfoParseListener);
            this.mSingleManager.addPinCodeToLelinkServiceInfo(string);
        }
    }

    @Override
    public void createLelinkServiceInfo(SinkParameterBean sinkParameterBean, IServiceInfoParseListener iServiceInfoParseListener) {
        if (this.isMultiProcessBind) {
            try {
                this.mMultiConnection.setServiceInfoParseListener(iServiceInfoParseListener);
                this.mMultiManager.setOption(0x200006, new String[]{sinkParameterBean.toJson()});
            }
            catch (Exception exception) {
                SourceLog.w(TAG, exception);
            }
        } else if (this.mSingleManager != null) {
            this.mSingleManager.setServiceInfoParseListener(iServiceInfoParseListener);
            this.mSingleManager.createLelinkServiceInfo(sinkParameterBean);
        }
    }

    @Override
    public boolean canPlayScreen(LelinkServiceInfo lelinkServiceInfo) {
        if (this.isMultiProcessBind) {
            try {
                return this.mMultiManager.canPlayScreen(lelinkServiceInfo);
            }
            catch (Exception exception) {
                SourceLog.w(TAG, exception);
            }
        } else if (this.mSingleManager != null) {
            return this.mSingleManager.canPlayScreen(lelinkServiceInfo);
        }
        return false;
    }

    @Override
    public boolean canPlayLocalMedia(LelinkServiceInfo lelinkServiceInfo) {
        if (this.isMultiProcessBind) {
            try {
                return this.mMultiManager.canPlayLocalMedia(lelinkServiceInfo);
            }
            catch (Exception exception) {
                SourceLog.w(TAG, exception);
            }
        } else if (this.mSingleManager != null) {
            return this.mSingleManager.canPlayLocalMedia(lelinkServiceInfo);
        }
        return false;
    }

    @Override
    public void updateAudioData(byte[] byArray, AudioFrameBean audioFrameBean) {
        if (this.isMultiProcessBind) {
            try {
                this.mMultiManager.updateAudioData(byArray, audioFrameBean);
            }
            catch (Exception exception) {
                SourceLog.w(TAG, exception);
            }
        } else if (this.mSingleManager != null) {
            this.mSingleManager.updateAudioData(byArray, audioFrameBean);
        }
    }

    @Override
    public void updateVideoData(byte[] byArray, VideoFrameBean videoFrameBean) {
        if (this.isMultiProcessBind) {
            try {
                this.mMultiManager.updateVideoData(byArray, videoFrameBean);
            }
            catch (Exception exception) {
                SourceLog.w(TAG, exception);
            }
        } else if (this.mSingleManager != null) {
            this.mSingleManager.updateVideoData(byArray, videoFrameBean);
        }
    }

    @Override
    public void setSinkKeyEventListener(ISinkKeyEventListener iSinkKeyEventListener) {
        if (this.isMultiProcessBind) {
            try {
                this.mMultiConnection.setSinkKeyEventListener(iSinkKeyEventListener);
            }
            catch (Exception exception) {
                SourceLog.w(TAG, exception);
            }
        } else if (this.mSingleManager != null) {
            this.mSingleManager.setSinkKeyEventListener(iSinkKeyEventListener);
        }
    }

    @Override
    public void setSinkTouchEventListener(SinkTouchEventArea sinkTouchEventArea, float f2, ISinkTouchEventListener iSinkTouchEventListener) {
        if (this.isMultiProcessBind) {
            try {
                this.mMultiConnection.setSinkTouchEventListener(sinkTouchEventArea, f2, iSinkTouchEventListener);
            }
            catch (Exception exception) {
                SourceLog.w(TAG, exception);
            }
        } else if (this.mSingleManager != null) {
            this.mSingleManager.setSinkTouchEventListener(sinkTouchEventArea, f2, iSinkTouchEventListener);
        }
    }

    @Override
    public void setSendPassCallback(ISendPassCallback iSendPassCallback) {
        if (this.isMultiProcessBind) {
            try {
                this.mMultiConnection.setPassCallback(iSendPassCallback);
            }
            catch (Exception exception) {
                SourceLog.w(TAG, exception);
            }
        } else if (this.mSingleManager != null) {
            this.mSingleManager.setPassCallback(iSendPassCallback);
        }
    }

    @Override
    public void setOption(int n2, Object ... objectArray) {
        try {
            switch (n2) {
                case 65539: {
                    IAPICallbackListener iAPICallbackListener = (IAPICallbackListener)objectArray[0];
                    List list = (List)objectArray[1];
                    if (iAPICallbackListener != null) {
                        if (list == null) break;
                        if (this.isMultiProcessBind) {
                            this.mMultiConnection.setOnlineCheckListener(iAPICallbackListener);
                            this.mMultiManager.startOnlineCheck(this.mMultiConnection.mOnlineCheckListener, list);
                            break;
                        }
                        this.mSingleManager.startOnlineCheck(iAPICallbackListener, list);
                    }
                    break;
                }
                case 65540: {
                    AuthListener authListener = (AuthListener)objectArray[0];
                    if (this.isMultiProcessBind) {
                        try {
                            this.mMultiConnection.setAuthListener(authListener);
                        }
                        catch (Exception exception) {
                            SourceLog.w(TAG, exception);
                        }
                    } else if (this.mSingleManager != null) {
                        this.mSingleManager.setAuthListener(authListener);
                    }
                    this.mAppAuthListener = authListener;
                    break;
                }
                case 1048615: {
                    if (objectArray.length > 0 && objectArray[0] instanceof ILogCallback) {
                        this.setLogCallback((ILogCallback)objectArray[0]);
                    }
                    break;
                }
                case 1048617: {
                    if (objectArray[0] instanceof Boolean) {
                        if (this.isMultiProcessBind) {
                            this.mMultiManager.setSystemApp((Boolean)objectArray[0]);
                            break;
                        }
                        if (this.mSingleManager != null) {
                            this.mSingleManager.setSystemApp((Boolean)objectArray[0]);
                        }
                    }
                    break;
                }
                case 1048675: {
                    if (objectArray != null && objectArray.length > 0 && objectArray[0] instanceof DanmakuBean) {
                        DanmakuBean danmakuBean = (DanmakuBean)objectArray[0];
                        if (this.isMultiProcessBind) {
                            this.mMultiManager.setOption(n2, new String[]{danmakuBean.toJson(null, 0)});
                            break;
                        }
                        if (this.mSingleManager != null) {
                            this.mSingleManager.setOption(n2, danmakuBean.toJson(null, 0));
                        }
                    }
                    break;
                }
                case 1048676: {
                    if (objectArray != null && objectArray.length > 0 && objectArray[0] instanceof DanmakuPropertyBean) {
                        DanmakuPropertyBean danmakuPropertyBean = (DanmakuPropertyBean)objectArray[0];
                        if (this.isMultiProcessBind) {
                            this.mMultiManager.setOption(n2, new String[]{danmakuPropertyBean.toJson(0)});
                            break;
                        }
                        if (this.mSingleManager != null) {
                            this.mSingleManager.setOption(n2, danmakuPropertyBean.toJson(0));
                        }
                    }
                    break;
                }
                case 1048642: 
                case 0x120000: 
                case 0x120001: {
                    if (!this.isMultiProcessBind) break;
                    if (objectArray != null && objectArray.length > 0) {
                        ArrayList<LelinkServiceInfo> arrayList = new ArrayList<LelinkServiceInfo>();
                        for (int i2 = 0; i2 < objectArray.length; ++i2) {
                            arrayList.add((LelinkServiceInfo)objectArray[i2]);
                        }
                        if (n2 == 1048642) {
                            SourceLog.i(TAG, "IAPI.OPTION_42");
                            this.mMultiManager.addCloudMirrorDevice(arrayList);
                            break;
                        }
                        this.mMultiManager.multiMirrorControl(0x120000 == n2, arrayList);
                    }
                    break;
                }
                case 0x120002: {
                    if (objectArray != null && objectArray.length > 0 && objectArray[0] instanceof IRelevantInfoListener) {
                        this.mAppRelevantInfoListener = (IRelevantInfoListener)objectArray[0];
                        if (this.isMultiProcessBind) {
                            this.mMultiManager.setRelevantInfoListener(this.mRelevantInfoListener);
                            break;
                        }
                        if (this.mSingleManager != null) {
                            this.mSingleManager.setRelevantInfoListener(this.mAppRelevantInfoListener);
                        }
                    }
                    break;
                }
                case 1179651: {
                    if (objectArray != null && objectArray.length > 0 && objectArray[0] instanceof ICloudMirrorPlayListener) {
                        this.mAppCloudMirrorPlayListener = (ICloudMirrorPlayListener)objectArray[0];
                        if (this.isMultiProcessBind) {
                            this.mMultiManager.setCloudMirrorPlayListener(this.mCloudMirrorPlayListener);
                            break;
                        }
                        if (this.mSingleManager != null) {
                            this.mSingleManager.setCloudMirrorPlayListener(this.mAppCloudMirrorPlayListener);
                        }
                    }
                    break;
                }
                default: {
                    try {
                        String[] stringArray;
                        if (objectArray != null && objectArray.length > 0) {
                            stringArray = new String[objectArray.length];
                            for (int i3 = 0; i3 < stringArray.length; ++i3) {
                                stringArray[i3] = String.valueOf(objectArray[i3]);
                            }
                        } else {
                            stringArray = new String[1];
                        }
                        SourceLog.i(TAG, "isMultiProcessBind " + n2 + " / " + stringArray);
                        if (this.isMultiProcessBind) {
                            if (this.mMultiManager != null) {
                                this.mMultiManager.setOption(n2, stringArray);
                            }
                        } else if (this.mSingleManager != null) {
                            this.mSingleManager.setOption(n2, stringArray);
                        }
                        break;
                    }
                    catch (Exception exception) {
                        SourceLog.w(TAG, exception);
                    }
                }
            }
        }
        catch (Exception exception) {
            SourceLog.w(TAG, "setOption: process may be closed");
        }
    }

    @Override
    public Object getOption(int n2, Object ... objectArray) {
        SourceLog.i(TAG, "getOption " + n2);
        switch (n2) {
            case 1048629: 
            case 1048631: 
            case 1048675: 
            case 0x200007: 
            case 0x200008: 
            case 2097173: 
            case 2097175: 
            case 2097177: {
                if (objectArray != null && objectArray.length > 0 && objectArray[0] instanceof LelinkServiceInfo) {
                    LelinkServiceInfo lelinkServiceInfo = (LelinkServiceInfo)objectArray[0];
                    if (this.isMultiProcessBind) {
                        try {
                            return this.mMultiManager.setLelinkServiceInfoOption(n2, lelinkServiceInfo);
                        }
                        catch (Exception exception) {
                            SourceLog.w(TAG, exception);
                        }
                    } else if (this.mSingleManager != null) {
                        Object object = this.mSingleManager.getOption(n2, lelinkServiceInfo);
                        if (object != null && !TextUtils.isEmpty((CharSequence)object.toString()) && HpplayUtil.isDigitsOnly(object.toString()) && Integer.parseInt(object.toString()) == 0) {
                            return true;
                        }
                        return false;
                    }
                }
                return false;
            }
        }
        if (this.isMultiProcessBind) {
            try {
                String string = this.mMultiManager.getOption(n2);
                if (!TextUtils.isEmpty((CharSequence)string) && HpplayUtil.isDigitsOnly(string)) {
                    return Integer.parseInt(string);
                }
                return string;
            }
            catch (Exception exception) {
                SourceLog.w(TAG, exception);
            }
        } else if (this.mSingleManager != null) {
            return this.mSingleManager.getOption(n2, objectArray);
        }
        return -1;
    }

    @Override
    public String getSDKInfos(int n2) {
        if (this.isMultiProcessBind) {
            try {
                return this.mMultiManager.getSDKInfos(n2);
            }
            catch (Exception exception) {
                SourceLog.w(TAG, exception);
            }
        } else if (this.mSingleManager != null) {
            return this.mSingleManager.getSDKInfos(n2);
        }
        return "";
    }

    @Override
    public void setLogCallback(ILogCallback iLogCallback) {
        if (this.isMultiProcessBind) {
            try {
                this.mMultiConnection.setLogCallback(iLogCallback);
            }
            catch (Exception exception) {
                SourceLog.w(TAG, exception);
            }
        } else if (this.mSingleManager != null) {
            this.mSingleManager.setLogCallback(iLogCallback);
        }
    }

    @Override
    public void setSearchBannerDataCallback(ISearchBannerDataCallback iSearchBannerDataCallback) {
        if (this.isMultiProcessBind) {
            try {
                this.mMultiConnection.setSearchBannerDataCallback(iSearchBannerDataCallback);
            }
            catch (Exception exception) {
                SourceLog.w(TAG, exception);
            }
        } else if (this.mSingleManager != null) {
            this.mSingleManager.setSearchBannerDataCallback(iSearchBannerDataCallback);
        }
    }

    @Override
    public void setMirrorChangeListener(IMirrorChangeListener iMirrorChangeListener) {
        if (this.isMultiProcessBind) {
            try {
                this.mMultiConnection.setMirrorChangeListener(iMirrorChangeListener);
            }
            catch (Exception exception) {
                SourceLog.w(TAG, exception);
            }
        } else if (this.mSingleManager != null) {
            this.mSingleManager.setMirrorChangeListener(iMirrorChangeListener);
        }
    }

    @Override
    public void appendPlayList(DramaInfoBean[] dramaInfoBeanArray, int n2, int n3, int n4) {
        if (this.isMultiProcessBind) {
            try {
                this.mMultiManager.appendPlayList(dramaInfoBeanArray, n2, n3, n4);
            }
            catch (Exception exception) {
                SourceLog.w(TAG, exception);
            }
        } else if (this.mSingleManager != null) {
            this.mSingleManager.appendPlayList(dramaInfoBeanArray, n2, n3, n4);
        }
    }

    @Override
    public void clearPlayList() {
        if (this.isMultiProcessBind) {
            try {
                this.mMultiManager.clearPlayList();
            }
            catch (Exception exception) {
                SourceLog.w(TAG, exception);
            }
        } else if (this.mSingleManager != null) {
            this.mSingleManager.clearPlayList();
        }
    }

    @Override
    public void setCommonListener(ICommonListener iCommonListener) {
        if (this.isMultiProcessBind) {
            try {
                this.mMultiConnection.setCommonListener(iCommonListener);
            }
            catch (Exception exception) {
                SourceLog.w(TAG, exception);
            }
        } else if (this.mSingleManager != null) {
            this.mSingleManager.setCommonListener(iCommonListener);
        }
    }

    @Override
    public VirtualDisplay getVirtualDisplay() {
        if (this.mSingleManager != null) {
            return this.mSingleManager.getVirtualDisplay();
        }
        return null;
    }

    public void retryBind() {
        if (this.mHandler != null && this.mBindCount < 3) {
            this.mHandler.removeCallbacksAndMessages(null);
            this.mHandler.postDelayed(new Runnable(){

                @Override
                public void run() {
                    if (LelinkSourceSDKImpProxy.this.mMultiConnection != null) {
                        LelinkSourceSDKImpProxy.this.mMultiConnection.startBind();
                    }
                    ++LelinkSourceSDKImpProxy.this.mBindCount;
                    LelinkSourceSDKImpProxy.this.isMultiProcessBind = false;
                }
            }, 500L);
        }
    }
}

