/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.glide.load.resource.gif;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.view.Gravity;
import com.hpplay.glide.gifdecoder.GifDecoder;
import com.hpplay.glide.gifdecoder.GifHeader;
import com.hpplay.glide.load.Transformation;
import com.hpplay.glide.load.engine.bitmap_recycle.BitmapPool;
import com.hpplay.glide.load.resource.drawable.GlideDrawable;
import com.hpplay.glide.load.resource.gif.GifFrameLoader;

public class GifDrawable
extends GlideDrawable
implements GifFrameLoader.FrameCallback {
    private final Paint paint;
    private final Rect destRect = new Rect();
    private final GifState state;
    private final GifDecoder decoder;
    private final GifFrameLoader frameLoader;
    private boolean isRunning;
    private boolean isStarted;
    private boolean isRecycled;
    private boolean isVisible = true;
    private int loopCount;
    private int maxLoopCount = -1;
    private boolean applyGravity;

    public GifDrawable(Context context, GifDecoder.BitmapProvider bitmapProvider, BitmapPool bitmapPool, Transformation<Bitmap> transformation, int n2, int n3, GifHeader gifHeader, byte[] byArray, Bitmap bitmap) {
        this(new GifState(gifHeader, byArray, context, transformation, n2, n3, bitmapProvider, bitmapPool, bitmap));
    }

    public GifDrawable(GifDrawable gifDrawable, Bitmap bitmap, Transformation<Bitmap> transformation) {
        this(new GifState(gifDrawable.state.gifHeader, gifDrawable.state.data, gifDrawable.state.context, transformation, gifDrawable.state.targetWidth, gifDrawable.state.targetHeight, gifDrawable.state.bitmapProvider, gifDrawable.state.bitmapPool, bitmap));
    }

    GifDrawable(GifState gifState) {
        if (gifState == null) {
            throw new NullPointerException("GifState must not be null");
        }
        this.state = gifState;
        this.decoder = new GifDecoder(gifState.bitmapProvider);
        this.paint = new Paint();
        this.decoder.setData(gifState.gifHeader, gifState.data);
        this.frameLoader = new GifFrameLoader(gifState.context, this, this.decoder, gifState.targetWidth, gifState.targetHeight);
        this.frameLoader.setFrameTransformation(gifState.frameTransformation);
    }

    GifDrawable(GifDecoder gifDecoder, GifFrameLoader gifFrameLoader, Bitmap bitmap, BitmapPool bitmapPool, Paint paint) {
        this.decoder = gifDecoder;
        this.frameLoader = gifFrameLoader;
        this.state = new GifState(null);
        this.paint = paint;
        this.state.bitmapPool = bitmapPool;
        this.state.firstFrame = bitmap;
    }

    public Bitmap getFirstFrame() {
        return this.state.firstFrame;
    }

    public void setFrameTransformation(Transformation<Bitmap> transformation, Bitmap bitmap) {
        if (bitmap == null) {
            throw new NullPointerException("The first frame of the GIF must not be null");
        }
        if (transformation == null) {
            throw new NullPointerException("The frame transformation must not be null");
        }
        this.state.frameTransformation = transformation;
        this.state.firstFrame = bitmap;
        this.frameLoader.setFrameTransformation(transformation);
    }

    public GifDecoder getDecoder() {
        return this.decoder;
    }

    public Transformation<Bitmap> getFrameTransformation() {
        return this.state.frameTransformation;
    }

    public byte[] getData() {
        return this.state.data;
    }

    public int getFrameCount() {
        return this.decoder.getFrameCount();
    }

    private void resetLoopCount() {
        this.loopCount = 0;
    }

    public void start() {
        this.isStarted = true;
        this.resetLoopCount();
        if (this.isVisible) {
            this.startRunning();
        }
    }

    public void stop() {
        this.isStarted = false;
        this.stopRunning();
        if (Build.VERSION.SDK_INT < 11) {
            this.reset();
        }
    }

    private void reset() {
        this.frameLoader.clear();
        this.invalidateSelf();
    }

    private void startRunning() {
        if (this.decoder.getFrameCount() == 1) {
            this.invalidateSelf();
        } else if (!this.isRunning) {
            this.isRunning = true;
            this.frameLoader.start();
            this.invalidateSelf();
        }
    }

    private void stopRunning() {
        this.isRunning = false;
        this.frameLoader.stop();
    }

    public boolean setVisible(boolean bl, boolean bl2) {
        this.isVisible = bl;
        if (!bl) {
            this.stopRunning();
        } else if (this.isStarted) {
            this.startRunning();
        }
        return super.setVisible(bl, bl2);
    }

    public int getIntrinsicWidth() {
        return this.state.firstFrame.getWidth();
    }

    public int getIntrinsicHeight() {
        return this.state.firstFrame.getHeight();
    }

    public boolean isRunning() {
        return this.isRunning;
    }

    void setIsRunning(boolean bl) {
        this.isRunning = bl;
    }

    protected void onBoundsChange(Rect rect) {
        super.onBoundsChange(rect);
        this.applyGravity = true;
    }

    public void draw(Canvas canvas) {
        Bitmap bitmap;
        if (this.isRecycled) {
            return;
        }
        if (this.applyGravity) {
            Gravity.apply((int)119, (int)this.getIntrinsicWidth(), (int)this.getIntrinsicHeight(), (Rect)this.getBounds(), (Rect)this.destRect);
            this.applyGravity = false;
        }
        Bitmap bitmap2 = (bitmap = this.frameLoader.getCurrentFrame()) != null ? bitmap : this.state.firstFrame;
        canvas.drawBitmap(bitmap2, null, this.destRect, this.paint);
    }

    public void setAlpha(int n2) {
        this.paint.setAlpha(n2);
    }

    public void setColorFilter(ColorFilter colorFilter) {
        this.paint.setColorFilter(colorFilter);
    }

    public int getOpacity() {
        return -2;
    }

    @Override
    @TargetApi(value=11)
    public void onFrameReady(int n2) {
        if (Build.VERSION.SDK_INT >= 11 && this.getCallback() == null) {
            this.stop();
            this.reset();
            return;
        }
        this.invalidateSelf();
        if (n2 == this.decoder.getFrameCount() - 1) {
            ++this.loopCount;
        }
        if (this.maxLoopCount != -1 && this.loopCount >= this.maxLoopCount) {
            this.stop();
        }
    }

    public Drawable.ConstantState getConstantState() {
        return this.state;
    }

    public void recycle() {
        this.isRecycled = true;
        this.state.bitmapPool.put(this.state.firstFrame);
        this.frameLoader.clear();
        this.frameLoader.stop();
    }

    boolean isRecycled() {
        return this.isRecycled;
    }

    @Override
    public boolean isAnimated() {
        return true;
    }

    @Override
    public void setLoopCount(int n2) {
        if (n2 <= 0 && n2 != -1 && n2 != 0) {
            throw new IllegalArgumentException("Loop count must be greater than 0, or equal to GlideDrawable.LOOP_FOREVER, or equal to GlideDrawable.LOOP_INTRINSIC");
        }
        this.maxLoopCount = n2 == 0 ? this.decoder.getLoopCount() : n2;
    }

    static class GifState
    extends Drawable.ConstantState {
        private static final int GRAVITY = 119;
        GifHeader gifHeader;
        byte[] data;
        Context context;
        Transformation<Bitmap> frameTransformation;
        int targetWidth;
        int targetHeight;
        GifDecoder.BitmapProvider bitmapProvider;
        BitmapPool bitmapPool;
        Bitmap firstFrame;

        public GifState(GifHeader gifHeader, byte[] byArray, Context context, Transformation<Bitmap> transformation, int n2, int n3, GifDecoder.BitmapProvider bitmapProvider, BitmapPool bitmapPool, Bitmap bitmap) {
            if (bitmap == null) {
                throw new NullPointerException("The first frame of the GIF must not be null");
            }
            this.gifHeader = gifHeader;
            this.data = byArray;
            this.bitmapPool = bitmapPool;
            this.firstFrame = bitmap;
            this.context = context.getApplicationContext();
            this.frameTransformation = transformation;
            this.targetWidth = n2;
            this.targetHeight = n3;
            this.bitmapProvider = bitmapProvider;
        }

        public GifState(GifState gifState) {
            if (gifState != null) {
                this.gifHeader = gifState.gifHeader;
                this.data = gifState.data;
                this.context = gifState.context;
                this.frameTransformation = gifState.frameTransformation;
                this.targetWidth = gifState.targetWidth;
                this.targetHeight = gifState.targetHeight;
                this.bitmapProvider = gifState.bitmapProvider;
                this.bitmapPool = gifState.bitmapPool;
                this.firstFrame = gifState.firstFrame;
            }
        }

        public Drawable newDrawable(Resources resources) {
            return this.newDrawable();
        }

        public Drawable newDrawable() {
            return new GifDrawable(this);
        }

        public int getChangingConfigurations() {
            return 0;
        }
    }
}

