/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.cybergarage.upnp.ssdp;

import android.content.SharedPreferences;
import android.text.TextUtils;
import com.hpplay.component.common.utils.CLog;
import com.hpplay.component.modulelinker.api.ModuleLinker;
import com.hpplay.cybergarage.http.HTTP;
import com.hpplay.cybergarage.upnp.ControlPoint;
import com.hpplay.cybergarage.upnp.Device;
import com.hpplay.cybergarage.upnp.UPnP;
import com.hpplay.cybergarage.util.OnlineCheckUtil;
import com.hpplay.cybergarage.xml.Node;
import com.hpplay.cybergarage.xml.Parser;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;

public class LocationCacheHandleTask
extends Thread {
    private static final String TAG = "LocationCacheHandleTasker";
    public static final String KEY_DLNA_LOCATION = "key_dlna_location";
    private List<String> mLocationList = new ArrayList<String>();
    private ControlPoint mControlPoint;
    private SharedPreferences mPreferences;

    public LocationCacheHandleTask(ControlPoint controlPoint) {
        this.mControlPoint = controlPoint;
        try {
            this.mPreferences = ModuleLinker.getInstance().getContext().getSharedPreferences(KEY_DLNA_LOCATION, 0);
            String string = this.mPreferences.getString(KEY_DLNA_LOCATION, null);
            if (!TextUtils.isEmpty((CharSequence)string)) {
                JSONArray jSONArray = new JSONArray(string);
                for (int i2 = 0; i2 < jSONArray.length(); ++i2) {
                    this.mLocationList.add(jSONArray.optString(i2));
                }
                CLog.w(TAG, " LocationCacheHandleTasker : " + string.replace(".", "-"));
            }
        }
        catch (Exception exception) {
            CLog.w(TAG, exception);
        }
    }

    @Override
    public void run() {
        super.run();
        CLog.w(TAG, " LocationCacheHandleTasker start");
        try {
            ArrayList<String> arrayList = new ArrayList<String>();
            for (int i2 = 0; i2 < this.mLocationList.size(); ++i2) {
                String string = this.mLocationList.get(i2);
                try {
                    String string2 = HTTP.getHost(string);
                    int n2 = HTTP.getPort(string);
                    if (!OnlineCheckUtil.tcpCheckTvState(string2, n2)) {
                        arrayList.add(this.mLocationList.remove(i2));
                        --i2;
                        continue;
                    }
                    CLog.w(TAG, " start  load desc" + string.replace(".", "-"));
                    Parser parser = UPnP.getXMLParser();
                    Node node = parser.parse(string, 5000);
                    if (this.mControlPoint != null && !this.isInterrupted()) {
                        Device device = this.mControlPoint.getDevice(node);
                        if (device == null) {
                            arrayList.add(this.mLocationList.remove(i2));
                            --i2;
                            continue;
                        }
                        device.setLocation(string);
                        CLog.w(TAG, " LocationCacheHandleTasker load new dev");
                        this.mControlPoint.addDevice(node);
                        this.mControlPoint.performAddDeviceListener(device);
                        continue;
                    }
                    break;
                }
                catch (Exception exception) {
                    CLog.i(TAG, "LocationCacheHandleTasker addDevice parse exception  \r\n" + exception.toString());
                    break;
                }
            }
        }
        catch (Exception exception) {
            CLog.w(TAG, exception);
        }
        CLog.i(TAG, "  LocationCacheHandleTasker exit");
    }

    private void deleteToLocal(String string) {
        try {
            int n2;
            JSONArray jSONArray;
            ArrayList<String> arrayList = new ArrayList<String>();
            String string2 = this.mPreferences.getString(KEY_DLNA_LOCATION, null);
            if (!TextUtils.isEmpty((CharSequence)string2)) {
                CLog.w(TAG, " LocationCacheHandleTasker deleteToLocal : " + string.replace(".", ""));
                jSONArray = new JSONArray(string2);
                for (n2 = 0; n2 < jSONArray.length(); ++n2) {
                    arrayList.add(jSONArray.optString(n2));
                }
            }
            if (arrayList.remove(string) && this.mPreferences != null) {
                jSONArray = new JSONArray();
                for (n2 = 0; n2 < arrayList.size(); ++n2) {
                    jSONArray.put(n2, arrayList.get(n2));
                }
                this.mPreferences.edit().putString(KEY_DLNA_LOCATION, jSONArray.toString()).apply();
            }
        }
        catch (Exception exception) {
            CLog.w(TAG, exception);
        }
    }

    public void release() {
        this.mControlPoint = null;
        this.interrupt();
    }
}

