/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.sdk.source.mdns.xbill.dns;

import com.hpplay.sdk.source.mdns.xbill.dns.Address;
import com.hpplay.sdk.source.mdns.xbill.dns.DNSInput;
import com.hpplay.sdk.source.mdns.xbill.dns.DNSOutput;
import com.hpplay.sdk.source.mdns.xbill.dns.EDNSOption;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class ClientSubnetOption
extends EDNSOption {
    private static final long serialVersionUID = -3868158449890266347L;
    private int family;
    private int sourceNetmask;
    private int scopeNetmask;
    private InetAddress address;

    ClientSubnetOption() {
        super(8);
    }

    public InetAddress getAddress() {
        return this.address;
    }

    @Override
    void optionFromWire(DNSInput dNSInput) {
        this.family = dNSInput.readU16();
        if (this.family != 1 && this.family != 2) {
            throw new Exception("unknown address family");
        }
        this.sourceNetmask = dNSInput.readU8();
        if (this.sourceNetmask > Address.addressLength(this.family) * 8) {
            throw new Exception("invalid source netmask");
        }
        this.scopeNetmask = dNSInput.readU8();
        if (this.scopeNetmask > Address.addressLength(this.family) * 8) {
            throw new Exception("invalid scope netmask");
        }
        byte[] byArray = dNSInput.readByteArray();
        if (byArray.length != (this.sourceNetmask + 7) / 8) {
            throw new Exception("invalid address");
        }
        byte[] byArray2 = new byte[Address.addressLength(this.family)];
        System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
        try {
            this.address = InetAddress.getByAddress(byArray2);
        }
        catch (UnknownHostException unknownHostException) {
            throw new Exception("invalid address", unknownHostException);
        }
        InetAddress inetAddress = Address.truncate(this.address, this.sourceNetmask);
        if (!inetAddress.equals(this.address)) {
            throw new Exception("invalid padding");
        }
    }

    @Override
    void optionToWire(DNSOutput dNSOutput) {
        dNSOutput.writeU16(this.family);
        dNSOutput.writeU8(this.sourceNetmask);
        dNSOutput.writeU8(this.scopeNetmask);
        dNSOutput.writeByteArray(this.address.getAddress(), 0, (this.sourceNetmask + 7) / 8);
    }

    @Override
    String optionToString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.address.getHostAddress());
        stringBuffer.append("/");
        stringBuffer.append(this.sourceNetmask);
        stringBuffer.append(", scope netmask ");
        stringBuffer.append(this.scopeNetmask);
        return stringBuffer.toString();
    }
}

