/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.component.protocol.plist;

import com.hpplay.component.protocol.plist.NSArray;
import com.hpplay.component.protocol.plist.NSData;
import com.hpplay.component.protocol.plist.NSDate;
import com.hpplay.component.protocol.plist.NSDictionary;
import com.hpplay.component.protocol.plist.NSNumber;
import com.hpplay.component.protocol.plist.NSObject;
import com.hpplay.component.protocol.plist.NSString;
import com.hpplay.component.protocol.plist.PropertyListFormatException;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

public class XMLPropertyListParser {
    private static final DocumentBuilderFactory FACTORY = DocumentBuilderFactory.newInstance();

    public static DocumentBuilder getDocBuilder() {
        DocumentBuilder documentBuilder = FACTORY.newDocumentBuilder();
        documentBuilder.setEntityResolver(new PlistDtdResolver());
        return documentBuilder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static NSObject parse(File file) {
        FileInputStream fileInputStream = new FileInputStream(file);
        try {
            NSObject nSObject = XMLPropertyListParser.parse(XMLPropertyListParser.getDocBuilder().parse(fileInputStream));
            return nSObject;
        }
        finally {
            try {
                ((InputStream)fileInputStream).close();
            }
            catch (IOException iOException) {}
        }
    }

    public static NSObject parse(byte[] byArray) {
        return XMLPropertyListParser.parse(new ByteArrayInputStream(byArray));
    }

    public static NSObject parse(InputStream inputStream) {
        return XMLPropertyListParser.parse(XMLPropertyListParser.getDocBuilder().parse(inputStream));
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static NSObject parse(Document document) {
        void var2_5;
        DocumentType documentType = document.getDoctype();
        if (documentType == null ? !document.getDocumentElement().getNodeName().equals("plist") : !documentType.getName().equals("plist")) {
            throw new UnsupportedOperationException("The given XML document is not a property list.");
        }
        if (document.getDocumentElement().getNodeName().equals("plist")) {
            List<Node> list = XMLPropertyListParser.filterElementNodes(document.getDocumentElement().getChildNodes());
            if (list.isEmpty()) {
                throw new PropertyListFormatException("The given XML property list has no root element!");
            }
            if (list.size() != 1) throw new PropertyListFormatException("The given XML property list has more than one root element!");
            Node node = list.get(0);
            return XMLPropertyListParser.parseObject((Node)var2_5);
        } else {
            Element element = document.getDocumentElement();
        }
        return XMLPropertyListParser.parseObject((Node)var2_5);
    }

    private static NSObject parseObject(Node node) {
        String string = node.getNodeName();
        if (string.equals("dict")) {
            NSDictionary nSDictionary = new NSDictionary();
            List<Node> list = XMLPropertyListParser.filterElementNodes(node.getChildNodes());
            for (int i2 = 0; i2 < list.size(); i2 += 2) {
                Node node2 = list.get(i2);
                Node node3 = list.get(i2 + 1);
                String string2 = XMLPropertyListParser.getNodeTextContents(node2);
                nSDictionary.put(string2, XMLPropertyListParser.parseObject(node3));
            }
            return nSDictionary;
        }
        if (string.equals("array")) {
            List<Node> list = XMLPropertyListParser.filterElementNodes(node.getChildNodes());
            NSArray nSArray = new NSArray(list.size());
            for (int i3 = 0; i3 < list.size(); ++i3) {
                nSArray.setValue(i3, XMLPropertyListParser.parseObject(list.get(i3)));
            }
            return nSArray;
        }
        if (string.equals("true")) {
            return new NSNumber(true);
        }
        if (string.equals("false")) {
            return new NSNumber(false);
        }
        if (string.equals("integer")) {
            return new NSNumber(XMLPropertyListParser.getNodeTextContents(node));
        }
        if (string.equals("real")) {
            return new NSNumber(XMLPropertyListParser.getNodeTextContents(node));
        }
        if (string.equals("string")) {
            return new NSString(XMLPropertyListParser.getNodeTextContents(node));
        }
        if (string.equals("data")) {
            return new NSData(XMLPropertyListParser.getNodeTextContents(node));
        }
        if (string.equals("date")) {
            return new NSDate(XMLPropertyListParser.getNodeTextContents(node));
        }
        return null;
    }

    private static List<Node> filterElementNodes(NodeList nodeList) {
        ArrayList<Node> arrayList = new ArrayList<Node>(nodeList.getLength());
        for (int i2 = 0; i2 < nodeList.getLength(); ++i2) {
            if (nodeList.item(i2).getNodeType() != 1) continue;
            arrayList.add(nodeList.item(i2));
        }
        return arrayList;
    }

    private static String getNodeTextContents(Node node) {
        if (node.getNodeType() == 3 || node.getNodeType() == 4) {
            Text text = (Text)node;
            String string = text.getWholeText();
            if (string == null) {
                return "";
            }
            return string;
        }
        if (node.hasChildNodes()) {
            NodeList nodeList = node.getChildNodes();
            for (int i2 = 0; i2 < nodeList.getLength(); ++i2) {
                Node node2 = nodeList.item(i2);
                if (node2.getNodeType() != 3 && node2.getNodeType() != 4) continue;
                Text text = (Text)node2;
                String string = text.getWholeText();
                if (string == null) {
                    return "";
                }
                return string;
            }
            return "";
        }
        return "";
    }

    static {
        try {
            FACTORY.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            // empty catch block
        }
        try {
            FACTORY.setFeature("http://xml.org/sax/features/external-general-entities", false);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            // empty catch block
        }
        try {
            FACTORY.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            // empty catch block
        }
        try {
            FACTORY.setXIncludeAware(false);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        FACTORY.setExpandEntityReferences(false);
        FACTORY.setNamespaceAware(false);
        FACTORY.setIgnoringComments(true);
        FACTORY.setCoalescing(true);
        FACTORY.setValidating(false);
    }

    private static class PlistDtdResolver
    implements EntityResolver {
        private static final String PLIST_PUBLIC_ID_1 = "-//Lebo Computer//DTD PLIST 1.0//EN";
        private static final String PLIST_PUBLIC_ID_2 = "-//Lebo//DTD PLIST 1.0//EN";

        PlistDtdResolver() {
        }

        @Override
        public InputSource resolveEntity(String string, String string2) {
            if (PLIST_PUBLIC_ID_1.equals(string) || PLIST_PUBLIC_ID_2.equals(string)) {
                return new InputSource(new ByteArrayInputStream(new byte[0]));
            }
            return null;
        }
    }
}

