/*
 * Decompiled with CFR 0.152.
 */
package com.yasirkula.unity;

import android.app.Fragment;
import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.Bundle;
import android.provider.MediaStore;
import android.util.Log;
import android.widget.Toast;
import com.yasirkula.unity.NativeGalleryMediaPickerResultFragment;
import com.yasirkula.unity.NativeGalleryMediaPickerResultOperation;
import com.yasirkula.unity.NativeGalleryMediaReceiver;
import com.yasirkula.unity.NativeGalleryUtils;

public class NativeGalleryMediaPickerFragment
extends Fragment {
    private static final int MEDIA_REQUEST_CODE = 987455;
    public static final String MEDIA_TYPE_ID = "NGMP_MEDIA_TYPE";
    public static final String SELECT_MULTIPLE_ID = "NGMP_MULTIPLE";
    public static final String SAVE_PATH_ID = "NGMP_SAVE_PATH";
    public static final String MIME_ID = "NGMP_MIME";
    public static final String TITLE_ID = "NGMP_TITLE";
    public static boolean preferGetContent = false;
    public static boolean tryPreserveFilenames = false;
    public static boolean showProgressbar = true;
    public static boolean useDefaultGalleryApp = false;
    public static boolean GrantPersistableUriPermission = false;
    private final NativeGalleryMediaReceiver mediaReceiver;
    private boolean selectMultiple;
    private String savePathDirectory;
    private String savePathFilename;

    public NativeGalleryMediaPickerFragment() {
        this.mediaReceiver = null;
    }

    public NativeGalleryMediaPickerFragment(NativeGalleryMediaReceiver mediaReceiver) {
        this.mediaReceiver = mediaReceiver;
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (this.mediaReceiver == null) {
            Log.e((String)"Unity", (String)"NativeGalleryMediaPickerFragment.mediaReceiver became null in onCreate!");
            this.onActivityResult(987455, 0, null);
        } else {
            int mediaType = this.getArguments().getInt(MEDIA_TYPE_ID);
            String mime = this.getArguments().getString(MIME_ID);
            String title = this.getArguments().getString(TITLE_ID);
            this.selectMultiple = this.getArguments().getBoolean(SELECT_MULTIPLE_ID);
            String savePath = this.getArguments().getString(SAVE_PATH_ID);
            int pathSeparator = savePath.lastIndexOf(47);
            this.savePathFilename = pathSeparator >= 0 ? savePath.substring(pathSeparator + 1) : savePath;
            this.savePathDirectory = pathSeparator > 0 ? savePath.substring(0, pathSeparator) : this.getActivity().getCacheDir().getAbsolutePath();
            int mediaTypeCount = 0;
            if ((mediaType & 1) == 1) {
                ++mediaTypeCount;
            }
            if ((mediaType & 2) == 2) {
                ++mediaTypeCount;
            }
            if ((mediaType & 4) == 4) {
                ++mediaTypeCount;
            }
            Intent intent = null;
            if (!preferGetContent && !this.selectMultiple && mediaTypeCount == 1 && mediaType != 4) {
                intent = new Intent("android.intent.action.PICK");
                if (mediaType == 1) {
                    intent.setDataAndType(MediaStore.Images.Media.EXTERNAL_CONTENT_URI, mime);
                } else if (mediaType == 2) {
                    intent.setDataAndType(MediaStore.Video.Media.EXTERNAL_CONTENT_URI, mime);
                } else {
                    intent.setDataAndType(MediaStore.Audio.Media.EXTERNAL_CONTENT_URI, mime);
                }
            }
            if (intent == null) {
                intent = new Intent(mediaTypeCount > 1 && Build.VERSION.SDK_INT >= 19 ? "android.intent.action.OPEN_DOCUMENT" : "android.intent.action.GET_CONTENT");
                intent.addCategory("android.intent.category.OPENABLE");
                intent.addFlags(1);
                if (this.selectMultiple && Build.VERSION.SDK_INT >= 18) {
                    intent.putExtra("android.intent.extra.ALLOW_MULTIPLE", true);
                }
                if (mediaTypeCount > 1) {
                    mime = "*/*";
                    if (Build.VERSION.SDK_INT >= 19) {
                        String[] mimetypes = new String[mediaTypeCount];
                        int index = 0;
                        if ((mediaType & 1) == 1) {
                            mimetypes[index++] = "image/*";
                        }
                        if ((mediaType & 2) == 2) {
                            mimetypes[index++] = "video/*";
                        }
                        if ((mediaType & 4) == 4) {
                            mimetypes[index++] = "audio/*";
                        }
                        intent.putExtra("android.intent.extra.MIME_TYPES", mimetypes);
                    }
                }
                intent.setType(mime);
            }
            if (NativeGalleryMediaPickerFragment.ShouldGrantPersistableUriPermission((Context)this.getActivity())) {
                intent.addFlags(64);
            }
            if (title != null && title.length() > 0) {
                intent.putExtra("android.intent.extra.TITLE", title);
            }
            try {
                if (useDefaultGalleryApp || Build.VERSION.SDK_INT == 30 && NativeGalleryUtils.IsXiaomiOrMIUI()) {
                    this.startActivityForResult(intent, 987455);
                } else {
                    this.startActivityForResult(Intent.createChooser((Intent)intent, (CharSequence)title), 987455);
                }
            }
            catch (ActivityNotFoundException e) {
                Toast.makeText((Context)this.getActivity(), (CharSequence)"No apps can perform this action.", (int)1).show();
                this.onActivityResult(987455, 0, null);
            }
        }
    }

    public static boolean ShouldGrantPersistableUriPermission(Context context) {
        return GrantPersistableUriPermission && Build.VERSION.SDK_INT >= 33 && context.getApplicationInfo().targetSdkVersion >= 33;
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        if (requestCode != 987455) {
            return;
        }
        NativeGalleryMediaPickerResultFragment resultFragment = null;
        if (this.mediaReceiver == null) {
            Log.d((String)"Unity", (String)"NativeGalleryMediaPickerFragment.mediaReceiver became null in onActivityResult!");
        } else if (resultCode != -1 || data == null) {
            if (!this.selectMultiple) {
                this.mediaReceiver.OnMediaReceived("");
            } else {
                this.mediaReceiver.OnMultipleMediaReceived("");
            }
        } else {
            NativeGalleryMediaPickerResultOperation resultOperation = new NativeGalleryMediaPickerResultOperation((Context)this.getActivity(), this.mediaReceiver, data, this.selectMultiple, this.savePathDirectory, this.savePathFilename);
            if (showProgressbar) {
                resultFragment = new NativeGalleryMediaPickerResultFragment(resultOperation);
            } else {
                resultOperation.execute();
                resultOperation.sendResultToUnity();
            }
        }
        if (resultFragment == null) {
            this.getFragmentManager().beginTransaction().remove((Fragment)this).commitAllowingStateLoss();
        } else {
            this.getFragmentManager().beginTransaction().remove((Fragment)this).add(0, resultFragment).commitAllowingStateLoss();
        }
    }
}

