/*
 * Decompiled with CFR 0.152.
 */
package com.tony.bluetoothunityapi;

import com.tony.bluetoothunityapi.BluetoothHelper;
import com.tony.bluetoothunityapi.transceiver.ITransceiver;

public abstract class BluetoothStreamManager
implements ITransceiver.OnTransceiverMessageReceived {
    protected ITransceiver transceiver;
    protected BluetoothHelper helper;
    protected byte[] data_out;

    public BluetoothStreamManager(BluetoothHelper helper) {
        this.helper = helper;
        this.transceiver = helper.getTransceiver();
        this.transceiver.setOnMessageReceived(this);
    }

    public void Listen() {
        this.transceiver.listen();
    }

    public abstract void sendData();

    public void set(byte[] c) {
        this.data_out = c;
    }

    public void set(String data) {
        byte[] b = BluetoothStreamManager.StringToBytes(data);
        this.set(b);
    }

    public final void setStopThread(boolean stopThread) {
        this.transceiver.stop(stopThread);
    }

    protected static byte[] StringToBytes(String str) {
        byte[] b = new byte[str.length()];
        for (int i = 0; i < b.length; ++i) {
            b[i] = (byte)str.charAt(i);
        }
        return b;
    }

    protected static char toUnsigned(byte b) {
        return (char)(b >= 0 ? b : 256 + b);
    }

    protected static String BytetoString(byte[] array, int len) {
        char[] temp = new char[len];
        for (int i = 0; i < len; ++i) {
            temp[i] = BluetoothStreamManager.toUnsigned(array[i]);
        }
        return new String(temp);
    }

    protected static byte[] toPrimivite(Byte[] array) {
        byte[] temp = new byte[array.length];
        for (int i = 0; i < array.length; ++i) {
            temp[i] = array[i];
        }
        return temp;
    }

    protected static Byte[] toObject(byte[] array) {
        return BluetoothStreamManager.toObject(array, array.length);
    }

    protected static Byte[] toObject(byte[] array, int length) {
        Byte[] temp = new Byte[length];
        for (int i = 0; i < length; ++i) {
            temp[i] = array[i];
        }
        return temp;
    }
}

