/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.sdk.source.mdns;

import android.util.Log;
import com.hpplay.sdk.source.mdns.ElementHelper;
import com.hpplay.sdk.source.mdns.MulticastDNSCache;
import com.hpplay.sdk.source.mdns.xbill.dns.MulticastDNSUtils;
import com.hpplay.sdk.source.mdns.xbill.dns.RRset;
import com.hpplay.sdk.source.mdns.xbill.dns.Record;
import java.lang.ref.WeakReference;
import java.util.List;
import java.util.logging.Level;

public class MonitorTask
extends Thread {
    private static final String TAG = "MonitorTask";
    private boolean isShutdown = false;
    private WeakReference<MulticastDNSCache> mWeakReference;

    MonitorTask(MulticastDNSCache multicastDNSCache) {
        this(false);
        this.mWeakReference = new WeakReference<MulticastDNSCache>(multicastDNSCache);
    }

    MonitorTask(boolean bl) {
        this.isShutdown = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.setName(TAG);
        while (!this.isShutdown) {
            try {
                Object[] objectArray;
                Object object;
                MulticastDNSCache multicastDNSCache = (MulticastDNSCache)this.mWeakReference.get();
                if (multicastDNSCache == null) break;
                MulticastDNSCache.CacheMonitor cacheMonitor = multicastDNSCache.getCacheMonitor();
                if (cacheMonitor == null || this.isShutdown) {
                    return;
                }
                try {
                    cacheMonitor.begin();
                }
                catch (Exception exception) {
                    MulticastDNSCache.logger.log(Level.WARNING, exception.getMessage(), exception);
                }
                MonitorTask monitorTask = this;
                synchronized (monitorTask) {
                    object = multicastDNSCache.dataCopy.values();
                    objectArray = object.toArray(new Object[object.size()]);
                }
                for (int i2 = 0; i2 < objectArray.length; ++i2) {
                    try {
                        object = objectArray[i2];
                        if (object instanceof List) {
                            Object[] objectArray2;
                            List list = (List)object;
                            MonitorTask monitorTask2 = this;
                            synchronized (monitorTask2) {
                                objectArray2 = list.toArray(new Object[list.size()]);
                            }
                            for (int i3 = 0; i3 < objectArray2.length; ++i3) {
                                this.processElement(new ElementHelper(multicastDNSCache, objectArray2[i3]), multicastDNSCache);
                            }
                            continue;
                        }
                        this.processElement(new ElementHelper(multicastDNSCache, object), multicastDNSCache);
                        continue;
                    }
                    catch (Exception exception) {
                        MulticastDNSCache.logger.log(Level.WARNING, exception.getMessage(), exception);
                    }
                }
                try {
                    cacheMonitor.end();
                }
                catch (Exception exception) {
                    MulticastDNSCache.logger.log(Level.WARNING, exception.getMessage(), exception);
                }
                Thread.sleep(1000L);
            }
            catch (Exception exception) {
                Log.i((String)TAG, (String)"MonitorTask exit...");
            }
        }
    }

    public void release() {
        this.isShutdown = true;
        this.interrupt();
    }

    private void processElement(ElementHelper elementHelper, MulticastDNSCache multicastDNSCache) {
        try {
            if (elementHelper.getElement() instanceof RRset) {
                Object object;
                RRset rRset = (RRset)elementHelper.getElement();
                if (this.isShutdown) {
                    for (Object object2 : object = MulticastDNSUtils.extractRecords(rRset)) {
                        if (elementHelper.getCredibility() < 4) continue;
                        MulticastDNSUtils.setTLLForRecord((Record)object2, 0L);
                    }
                }
                object = multicastDNSCache.getCacheMonitor();
                int n2 = elementHelper.getExpiresIn();
                if (n2 <= 0 || rRset.getTTL() <= 0L) {
                    object.expired(rRset, elementHelper.getCredibility());
                } else {
                    object.check(rRset, elementHelper.getCredibility(), n2);
                }
            } else {
                String string = elementHelper.getElement() != null ? elementHelper.getElement().getClass().getName() : "null";
            }
        }
        catch (Exception exception) {
            MulticastDNSCache.logger.log(Level.WARNING, exception.getMessage(), exception);
        }
    }
}

