/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.sdk.source.mdns;

import com.hpplay.sdk.source.mdns.xbill.dns.Name;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.Field;
import java.net.URL;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ServiceName
extends Name {
    private static final long serialVersionUID = 201305151047L;
    private static final byte[][] PROTOCOLS;
    private static final byte[] SUB_SERVICE_INDICATOR;
    private String instance;
    private String fullSubType;
    private String subType;
    private String fullType;
    private String type;
    private String domain;
    private String protocol;
    private String application;
    private final Name serviceTypeName;
    private final Name serviceRRName;

    public ServiceName(String string) {
        this(new Name(string));
    }

    public ServiceName(String string, Name name) {
        this(new Name(string, name));
    }

    ServiceName(Name name) {
        super(name, 0);
        int n2;
        int n3;
        Object object;
        byte[] byArray = null;
        try {
            Class<Name> clazz = Name.class;
            object = clazz.getDeclaredField("name");
            ((Field)object).setAccessible(true);
            byArray = (byte[])((Field)object).get(name);
        }
        catch (NoSuchFieldException noSuchFieldException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        int n4 = name.labels();
        if (byArray == null) {
            byArray = new byte[name.length()];
            int n5 = 0;
            for (n3 = 0; n3 < n4; ++n3) {
                byte[] byArray2 = name.getLabel(n3);
                System.arraycopy(byArray2, 0, byArray, n5, byArray2[0] + 1);
                n5 += byArray2[0] + 1;
            }
        }
        object = new short[n4];
        n3 = 0;
        int n6 = 0;
        int n7 = -1;
        int n8 = -1;
        int n9 = -1;
        for (int i2 = 0; i2 < n4; ++i2) {
            object[i2] = n3;
            n2 = (short)(byArray[object[i2]] & 0xFF);
            n3 = (short)(object[i2] + n2 + true);
            if (byArray[object[i2]] <= 0 || byArray[object[i2] + true] != 95) continue;
            if (n9 < 0) {
                n9 = i2;
            }
            if (n8 < 0 && ServiceName.arrayEquals(SUB_SERVICE_INDICATOR, byArray, (short)object[i2])) {
                n8 = i2;
            }
            n7 = i2;
            ++n6;
        }
        if (n6 > 0) {
            byte by;
            StringBuilder stringBuilder = new StringBuilder();
            if (n9 > 0) {
                for (n2 = 0; n2 < n9; ++n2) {
                    by = byArray[object[n2]];
                    if (by <= 0) continue;
                    stringBuilder.append(new String(byArray, (int)(object[n2] + true), (int)by)).append('.');
                }
                this.instance = stringBuilder.substring(0, stringBuilder.length() - 1);
                stringBuilder.setLength(0);
            }
            block7: for (n2 = n9; n2 <= n7; ++n2) {
                by = byArray[object[n2]];
                if (by <= 0) continue;
                String string = new String(byArray, (int)(object[n2] + true), (int)by);
                if (n2 < n8) {
                    stringBuilder.append(string);
                } else if (n2 == n8) {
                    this.subType = stringBuilder.substring(0, stringBuilder.length() - 1);
                    stringBuilder.append(string);
                    this.fullSubType = stringBuilder.toString();
                } else {
                    if (n2 == n7) {
                        stringBuilder.append(string);
                        for (byte[] byArray3 : PROTOCOLS) {
                            if (!ServiceName.arrayEquals(byArray3, byArray, (short)object[n2])) continue;
                            this.protocol = string;
                            break block7;
                        }
                        break;
                    }
                    stringBuilder.append(string);
                }
                stringBuilder.append('.');
            }
            if (this.fullSubType != null) {
                this.type = stringBuilder.substring(this.fullSubType.length() + 1, stringBuilder.length());
                this.fullType = stringBuilder.toString();
                this.application = this.protocol != null ? stringBuilder.substring(this.fullSubType.length() + 1, stringBuilder.length() - this.protocol.length() - 1) : this.type;
            } else {
                this.type = this.fullType = stringBuilder.toString();
                this.application = this.protocol != null ? stringBuilder.substring(0, stringBuilder.length() - this.protocol.length() - 1) : this.type;
            }
            stringBuilder.setLength(0);
            for (n2 = n7 + 1; n2 < ((Object)object).length; ++n2) {
                by = byArray[object[n2]];
                if (by <= 0) continue;
                stringBuilder.append(new String(byArray, (int)(object[n2] + true), (int)by)).append('.');
            }
            this.domain = stringBuilder.substring(0, stringBuilder.length());
            stringBuilder.setLength(0);
            this.serviceTypeName = new Name(this.type + (this.domain != null ? "." + this.domain : ""));
            this.serviceRRName = this.instance != null && this.instance.length() > 0 ? new Name(this.instance, this.serviceTypeName) : null;
        } else {
            throw new Exception("Name \"" + name + "\" is not an IETF RFC 2782 or IETF RFC 6763 compliant service name.");
        }
    }

    private static final boolean arrayEquals(byte[] byArray, byte[] byArray2, short s2) {
        int n2 = byArray2[s2];
        if (n2 == byArray[0] && byArray2.length > s2 + n2) {
            for (int i2 = 1; i2 < n2; ++i2) {
                if (byArray[i2] == byArray2[s2 + i2]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public String getApplication() {
        return this.application;
    }

    public String getDomain() {
        return this.domain;
    }

    public String getFullSubType() {
        return this.fullSubType;
    }

    public String getFullType() {
        return this.fullType;
    }

    public String getInstance() {
        return this.instance;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public Name getServiceTypeName() {
        return this.serviceTypeName;
    }

    public Name getServiceRRName() {
        return this.serviceRRName;
    }

    public String getSubType() {
        return this.subType;
    }

    public String getType() {
        return this.type;
    }

    public static void main(String ... stringArray) {
        Name name = new Name(stringArray.length > 0 ? stringArray[0] : "Steve Posick's Work MacBook Pro._test._sub._syncmate._tcp.local.");
        ServiceName serviceName = new ServiceName(name);
        System.out.println("Service Name = " + serviceName);
        System.out.println("Instance: " + serviceName.instance);
        System.out.println("Full Type: " + serviceName.fullType);
        System.out.println("Sub Type: " + serviceName.subType);
        System.out.println("Type: " + serviceName.type);
        System.out.println("Application: " + serviceName.application);
        System.out.println("Protocol: " + serviceName.protocol);
        System.out.println("Domain: " + serviceName.domain);
        int n2 = 100000;
        long l2 = System.nanoTime();
        for (int i2 = 0; i2 < n2; ++i2) {
            serviceName = new ServiceName(name);
        }
        long l3 = System.nanoTime() - l2;
        System.out.println("Took " + (double)l3 / 1000000.0 + " milliseconds to parse " + n2 + " service names at " + (double)(l3 / (long)n2) / 1000000.0 + " millis / " + l3 / (long)n2 + " nanoseconds each name");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        SUB_SERVICE_INDICATOR = new byte[]{4, 95, 115, 117, 98};
        ArrayList<byte[]> arrayList = new ArrayList<byte[]>();
        byte[][] byArrayArray = new byte[][]{{4, 95, 116, 99, 112}, {4, 95, 117, 100, 112}, {5, 95, 115, 99, 116, 112}};
        for (byte[] byArray : byArrayArray) {
            arrayList.add(byArray);
        }
        Object object = ServiceName.class.getResource("ServiceName.protocol");
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = new BufferedReader(new InputStreamReader(((URL)object).openStream()));
            String string = null;
            while ((string = bufferedReader.readLine()) != null) {
                byte[] byArray;
                byArray = string.trim().getBytes();
                byte[] byArray2 = new byte[byArray.length + 1];
                byArray2[0] = (byte)byArray.length;
                System.arraycopy(byArray, 0, byArray2, 1, byArray.length);
                arrayList.add(byArray2);
            }
        }
        catch (Exception exception) {
            Logger.getAnonymousLogger().log(Level.FINE, "Could not find Protocols file \"" + object + "\"", exception);
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException) {}
            }
        }
        PROTOCOLS = (byte[][])arrayList.toArray((T[])new byte[arrayList.size()][]);
    }
}

