/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.component.protocol.plist;

import com.hpplay.component.protocol.plist.NSArray;
import com.hpplay.component.protocol.plist.NSData;
import com.hpplay.component.protocol.plist.NSDate;
import com.hpplay.component.protocol.plist.NSDictionary;
import com.hpplay.component.protocol.plist.NSNumber;
import com.hpplay.component.protocol.plist.NSObject;
import com.hpplay.component.protocol.plist.NSString;
import com.hpplay.component.protocol.plist.PropertyListParser;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.text.ParseException;
import java.text.StringCharacterIterator;
import java.util.LinkedList;

public final class ASCIIPropertyListParser {
    public static final char WHITESPACE_SPACE = ' ';
    public static final char WHITESPACE_TAB = '\t';
    public static final char WHITESPACE_NEWLINE = '\n';
    public static final char WHITESPACE_CARRIAGE_RETURN = '\r';
    public static final char ARRAY_BEGIN_TOKEN = '(';
    public static final char ARRAY_END_TOKEN = ')';
    public static final char ARRAY_ITEM_DELIMITER_TOKEN = ',';
    public static final char DICTIONARY_BEGIN_TOKEN = '{';
    public static final char DICTIONARY_END_TOKEN = '}';
    public static final char DICTIONARY_ASSIGN_TOKEN = '=';
    public static final char DICTIONARY_ITEM_DELIMITER_TOKEN = ';';
    public static final char QUOTEDSTRING_BEGIN_TOKEN = '\"';
    public static final char QUOTEDSTRING_END_TOKEN = '\"';
    public static final char QUOTEDSTRING_ESCAPE_TOKEN = '\\';
    public static final char DATA_BEGIN_TOKEN = '<';
    public static final char DATA_END_TOKEN = '>';
    public static final char DATA_GSOBJECT_BEGIN_TOKEN = '*';
    public static final char DATA_GSDATE_BEGIN_TOKEN = 'D';
    public static final char DATA_GSBOOL_BEGIN_TOKEN = 'B';
    public static final char DATA_GSBOOL_TRUE_TOKEN = 'Y';
    public static final char DATA_GSBOOL_FALSE_TOKEN = 'N';
    public static final char DATA_GSINT_BEGIN_TOKEN = 'I';
    public static final char DATA_GSREAL_BEGIN_TOKEN = 'R';
    public static final char DATE_DATE_FIELD_DELIMITER = '-';
    public static final char DATE_TIME_FIELD_DELIMITER = ':';
    public static final char DATE_GS_DATE_TIME_DELIMITER = ' ';
    public static final char DATE_APPLE_DATE_TIME_DELIMITER = 'T';
    public static final char DATE_APPLE_END_TOKEN = 'Z';
    public static final char COMMENT_BEGIN_TOKEN = '/';
    public static final char MULTILINE_COMMENT_SECOND_TOKEN = '*';
    public static final char SINGLELINE_COMMENT_SECOND_TOKEN = '/';
    public static final char MULTILINE_COMMENT_END_TOKEN = '/';
    private final char[] data;
    private int index;

    private ASCIIPropertyListParser(byte[] byArray, String string) {
        this.data = new String(byArray, string).toCharArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static NSObject parse(File file) {
        FileInputStream fileInputStream = new FileInputStream(file);
        try {
            NSObject nSObject = ASCIIPropertyListParser.parse(fileInputStream);
            return nSObject;
        }
        finally {
            try {
                ((InputStream)fileInputStream).close();
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static NSObject parse(File file, String string) {
        FileInputStream fileInputStream = new FileInputStream(file);
        try {
            NSObject nSObject = ASCIIPropertyListParser.parse(fileInputStream, string);
            return nSObject;
        }
        finally {
            try {
                ((InputStream)fileInputStream).close();
            }
            catch (IOException iOException) {}
        }
    }

    public static NSObject parse(InputStream inputStream) {
        return ASCIIPropertyListParser.parse(PropertyListParser.readAll(inputStream));
    }

    public static NSObject parse(InputStream inputStream, String string) {
        return ASCIIPropertyListParser.parse(PropertyListParser.readAll(inputStream), string);
    }

    public static NSObject parse(byte[] byArray) {
        try {
            if (byArray.length > 2) {
                if (byArray[0] == -2 && byArray[1] == -1) {
                    return ASCIIPropertyListParser.parse(byArray, "UTF-16");
                }
                if (byArray[0] == -1 && byArray[1] == -2) {
                    if (byArray.length > 4 && byArray[2] == 0 && byArray[3] == 0) {
                        return ASCIIPropertyListParser.parse(byArray, "UTF-32");
                    }
                    return ASCIIPropertyListParser.parse(byArray, "UTF-16");
                }
                if (byArray.length > 3) {
                    if (byArray[0] == -17 && byArray[1] == -69 && byArray[2] == -65) {
                        return ASCIIPropertyListParser.parse(byArray, "UTF-8");
                    }
                    if (byArray.length > 4 && byArray[0] == 0 && byArray[1] == 0 && byArray[2] == -2 && byArray[3] == -1) {
                        return ASCIIPropertyListParser.parse(byArray, "UTF-32");
                    }
                }
            }
            return ASCIIPropertyListParser.parse(byArray, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException("Unsupported property list encoding: " + unsupportedEncodingException.getMessage());
        }
    }

    public static NSObject parse(byte[] byArray, String string) {
        ASCIIPropertyListParser aSCIIPropertyListParser = new ASCIIPropertyListParser(byArray, string);
        return aSCIIPropertyListParser.parse();
    }

    private boolean acceptSequence(char ... cArray) {
        for (int i2 = 0; i2 < cArray.length; ++i2) {
            if (this.data[this.index + i2] == cArray[i2]) continue;
            return false;
        }
        return true;
    }

    private boolean accept(char ... cArray) {
        boolean bl = false;
        for (char c2 : cArray) {
            if (this.data[this.index] != c2) continue;
            bl = true;
        }
        return bl;
    }

    private boolean accept(char c2) {
        return this.data[this.index] == c2;
    }

    private void expect(char ... cArray) {
        if (!this.accept(cArray)) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Expected '").append(cArray[0]).append("'");
            for (int i2 = 1; i2 < cArray.length; ++i2) {
                stringBuilder.append(" or '").append(cArray[i2]).append("'");
            }
            stringBuilder.append(" but found '").append(this.data[this.index]).append("'");
            throw new ParseException(stringBuilder.toString(), this.index);
        }
    }

    private void expect(char c2) {
        if (!this.accept(c2)) {
            throw new ParseException("Expected '" + c2 + "' but found '" + this.data[this.index] + "'", this.index);
        }
    }

    private void read(char c2) {
        this.expect(c2);
        ++this.index;
    }

    private void skip() {
        ++this.index;
    }

    private void skip(int n2) {
        this.index += n2;
    }

    private void skipWhitespacesAndComments() {
        boolean bl;
        do {
            bl = false;
            while (this.accept('\r', '\n', ' ', '\t')) {
                this.skip();
            }
            if (this.acceptSequence('/', '/')) {
                this.skip(2);
                this.readInputUntil('\r', '\n');
                bl = true;
                continue;
            }
            if (!this.acceptSequence('/', '*')) continue;
            this.skip(2);
            while (true) {
                if (this.acceptSequence('*', '/')) break;
                this.skip();
            }
            this.skip(2);
            bl = true;
        } while (bl);
    }

    private String readInputUntil(char ... cArray) {
        StringBuilder stringBuilder = new StringBuilder();
        while (!this.accept(cArray)) {
            stringBuilder.append(this.data[this.index]);
            this.skip();
        }
        return stringBuilder.toString();
    }

    private String readInputUntil(char c2) {
        StringBuilder stringBuilder = new StringBuilder();
        while (!this.accept(c2)) {
            stringBuilder.append(this.data[this.index]);
            this.skip();
        }
        return stringBuilder.toString();
    }

    public NSObject parse() {
        this.index = 0;
        if (this.data.length == 0) {
            throw new ParseException("The property list is empty.", 0);
        }
        if (this.data[0] == '\ufeff') {
            this.skip(1);
        }
        this.skipWhitespacesAndComments();
        this.expect('{', '(', '/');
        try {
            return this.parseObject();
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new ParseException("Reached end of input unexpectedly.", this.index);
        }
    }

    private NSObject parseObject() {
        switch (this.data[this.index]) {
            case '(': {
                return this.parseArray();
            }
            case '{': {
                return this.parseDictionary();
            }
            case '<': {
                return this.parseData();
            }
            case '\"': {
                String string = this.parseQuotedString();
                if (string.length() == 20 && string.charAt(4) == '-') {
                    try {
                        return new NSDate(string);
                    }
                    catch (Exception exception) {
                        return new NSString(string);
                    }
                }
                return new NSString(string);
            }
        }
        if (this.data[this.index] >= '0' && this.data[this.index] <= '9') {
            return this.parseDateString();
        }
        return new NSString(this.parseString());
    }

    private NSArray parseArray() {
        this.skip();
        this.skipWhitespacesAndComments();
        LinkedList<NSObject> linkedList = new LinkedList<NSObject>();
        while (!this.accept(')')) {
            linkedList.add(this.parseObject());
            this.skipWhitespacesAndComments();
            if (!this.accept(',')) break;
            this.skip();
            this.skipWhitespacesAndComments();
        }
        this.read(')');
        return new NSArray(linkedList.toArray(new NSObject[linkedList.size()]));
    }

    private NSDictionary parseDictionary() {
        this.skip();
        this.skipWhitespacesAndComments();
        NSDictionary nSDictionary = new NSDictionary();
        while (!this.accept('}')) {
            String string = this.accept('\"') ? this.parseQuotedString() : this.parseString();
            this.skipWhitespacesAndComments();
            this.read('=');
            this.skipWhitespacesAndComments();
            NSObject nSObject = this.parseObject();
            nSDictionary.put(string, nSObject);
            this.skipWhitespacesAndComments();
            this.read(';');
            this.skipWhitespacesAndComments();
        }
        this.skip();
        return nSDictionary;
    }

    private NSObject parseData() {
        NSObject nSObject = null;
        this.skip();
        if (this.accept('*')) {
            this.skip();
            this.expect('B', 'D', 'I', 'R');
            if (this.accept('B')) {
                this.skip();
                this.expect('Y', 'N');
                nSObject = this.accept('Y') ? new NSNumber(true) : new NSNumber(false);
                this.skip();
            } else if (this.accept('D')) {
                this.skip();
                String string = this.readInputUntil('>');
                nSObject = new NSDate(string);
            } else if (this.accept('I', 'R')) {
                this.skip();
                String string = this.readInputUntil('>');
                nSObject = new NSNumber(string);
            }
            this.read('>');
        } else {
            String string = this.readInputUntil('>');
            string = string.replaceAll("\\s+", "");
            int n2 = string.length() / 2;
            byte[] byArray = new byte[n2];
            for (int i2 = 0; i2 < byArray.length; ++i2) {
                String string2 = string.substring(i2 * 2, i2 * 2 + 2);
                int n3 = Integer.parseInt(string2, 16);
                byArray[i2] = (byte)n3;
            }
            nSObject = new NSData(byArray);
            this.skip();
        }
        return nSObject;
    }

    private NSObject parseDateString() {
        String string = this.parseString();
        if (string.length() > 4 && string.charAt(4) == '-') {
            try {
                return new NSDate(string);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return new NSString(string);
    }

    private String parseString() {
        return this.readInputUntil(' ', '\t', '\n', '\r', ',', ';', '=', ')');
    }

    private String parseQuotedString() {
        String string;
        this.skip();
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = true;
        while (this.data[this.index] != '\"' || this.data[this.index - 1] == '\\' && bl) {
            stringBuilder.append(this.data[this.index]);
            if (this.accept('\\')) {
                bl = this.data[this.index - 1] != '\\' || !bl;
            }
            this.skip();
        }
        try {
            string = ASCIIPropertyListParser.parseQuotedString(stringBuilder.toString());
        }
        catch (ParseException parseException) {
            throw new ParseException(parseException.getMessage(), this.index + parseException.getErrorOffset());
        }
        catch (Exception exception) {
            throw new ParseException("A quoted string could not be parsed.", this.index);
        }
        this.skip();
        return string;
    }

    private static synchronized String parseQuotedString(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        StringCharacterIterator stringCharacterIterator = new StringCharacterIterator(string);
        char c2 = stringCharacterIterator.current();
        while (stringCharacterIterator.getIndex() < stringCharacterIterator.getEndIndex()) {
            switch (c2) {
                case '\\': {
                    stringBuilder.append(ASCIIPropertyListParser.parseEscapedSequence(stringCharacterIterator));
                    break;
                }
                default: {
                    stringBuilder.append(c2);
                }
            }
            c2 = stringCharacterIterator.next();
        }
        return stringBuilder.toString();
    }

    private static char parseEscapedSequence(StringCharacterIterator stringCharacterIterator) {
        char c2 = stringCharacterIterator.next();
        switch (c2) {
            case '\"': 
            case '\'': 
            case '\\': {
                return c2;
            }
            case 'b': {
                return '\b';
            }
            case 'n': {
                return '\n';
            }
            case 'r': {
                return '\r';
            }
            case 't': {
                return '\t';
            }
            case 'U': 
            case 'u': {
                String string = new String(new char[]{stringCharacterIterator.next(), stringCharacterIterator.next(), stringCharacterIterator.next(), stringCharacterIterator.next()});
                try {
                    return (char)Integer.parseInt(string, 16);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new ParseException("The property list contains a string with an invalid escape sequence: \\" + c2 + string, stringCharacterIterator.getIndex() - 4);
                }
            }
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': {
                String string = new String(new char[]{c2, stringCharacterIterator.next(), stringCharacterIterator.next()});
                try {
                    return (char)Integer.parseInt(string, 8);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new ParseException("The property list contains a string with an invalid escape sequence: \\" + string, stringCharacterIterator.getIndex() - 2);
                }
            }
        }
        throw new ParseException("The property list contains a string with an invalid escape sequence: \\" + c2, stringCharacterIterator.getIndex());
    }
}

