/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.glide.load.data;

import android.text.TextUtils;
import android.util.Log;
import com.hpplay.glide.Priority;
import com.hpplay.glide.load.data.DataFetcher;
import com.hpplay.glide.load.model.GlideUrl;
import com.hpplay.glide.util.ContentLengthInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Map;

public class HttpUrlFetcher
implements DataFetcher<InputStream> {
    private static final String TAG = "HttpUrlFetcher";
    private static final int MAXIMUM_REDIRECTS = 5;
    private static final HttpUrlConnectionFactory DEFAULT_CONNECTION_FACTORY = new DefaultHttpUrlConnectionFactory();
    private final GlideUrl glideUrl;
    private final HttpUrlConnectionFactory connectionFactory;
    private HttpURLConnection urlConnection;
    private InputStream stream;
    private volatile boolean isCancelled;

    public HttpUrlFetcher(GlideUrl glideUrl) {
        this(glideUrl, DEFAULT_CONNECTION_FACTORY);
    }

    HttpUrlFetcher(GlideUrl glideUrl, HttpUrlConnectionFactory httpUrlConnectionFactory) {
        this.glideUrl = glideUrl;
        this.connectionFactory = httpUrlConnectionFactory;
    }

    @Override
    public InputStream loadData(Priority priority) {
        return this.loadDataWithRedirects(this.glideUrl.toURL(), 0, null, this.glideUrl.getHeaders());
    }

    private InputStream loadDataWithRedirects(URL uRL, int n2, URL uRL2, Map<String, String> map) {
        if (n2 >= 5) {
            throw new IOException("Too many (> 5) redirects!");
        }
        try {
            if (uRL2 != null && uRL.toURI().equals(uRL2.toURI())) {
                throw new IOException("In re-direct loop");
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        this.urlConnection = this.connectionFactory.build(uRL);
        for (Map.Entry<String, String> object : map.entrySet()) {
            this.urlConnection.addRequestProperty(object.getKey(), object.getValue());
        }
        this.urlConnection.setConnectTimeout(30000);
        this.urlConnection.setReadTimeout(30000);
        this.urlConnection.setUseCaches(false);
        this.urlConnection.setDoInput(true);
        this.urlConnection.connect();
        if (this.isCancelled) {
            return null;
        }
        int n3 = this.urlConnection.getResponseCode();
        if (n3 / 100 == 2) {
            return this.getStreamForSuccessfulRequest(this.urlConnection);
        }
        if (n3 / 100 == 3) {
            String string = this.urlConnection.getHeaderField("Location");
            if (TextUtils.isEmpty((CharSequence)string)) {
                throw new IOException("Received empty or null redirect url");
            }
            URL uRL3 = new URL(uRL, string);
            return this.loadDataWithRedirects(uRL3, n2 + 1, uRL, map);
        }
        if (n3 == -1) {
            throw new IOException("Unable to retrieve response code from HttpUrlConnection.");
        }
        throw new IOException("Request failed " + n3 + ": " + this.urlConnection.getResponseMessage());
    }

    private InputStream getStreamForSuccessfulRequest(HttpURLConnection httpURLConnection) {
        if (TextUtils.isEmpty((CharSequence)httpURLConnection.getContentEncoding())) {
            int n2 = httpURLConnection.getContentLength();
            this.stream = ContentLengthInputStream.obtain(httpURLConnection.getInputStream(), n2);
        } else {
            if (Log.isLoggable((String)TAG, (int)3)) {
                Log.d((String)TAG, (String)("Got non empty content encoding: " + httpURLConnection.getContentEncoding()));
            }
            this.stream = httpURLConnection.getInputStream();
        }
        return this.stream;
    }

    @Override
    public void cleanup() {
        if (this.stream != null) {
            try {
                this.stream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this.urlConnection != null) {
            this.urlConnection.disconnect();
        }
    }

    @Override
    public String getId() {
        return this.glideUrl.getCacheKey();
    }

    @Override
    public void cancel() {
        this.isCancelled = true;
    }

    private static class DefaultHttpUrlConnectionFactory
    implements HttpUrlConnectionFactory {
        private DefaultHttpUrlConnectionFactory() {
        }

        @Override
        public HttpURLConnection build(URL uRL) {
            return (HttpURLConnection)uRL.openConnection();
        }
    }

    static interface HttpUrlConnectionFactory {
        public HttpURLConnection build(URL var1);
    }
}

