/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.component.asyncmanager;

import android.text.TextUtils;
import com.hpplay.component.asyncmanager.AsyncHttpJob;
import com.hpplay.component.asyncmanager.AsyncHttpParameter;
import com.hpplay.component.asyncmanager.HttpResult;
import com.hpplay.component.common.utils.CLog;
import java.io.DataOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.Iterator;
import java.util.Map;
import java.util.zip.GZIPInputStream;

public class HttpRequest {
    public static final String TAG = "HttpRequest";
    private int count = 0;
    private AsyncHttpParameter.In parameter;
    private AsyncHttpJob mHttpJob;

    public HttpRequest(AsyncHttpParameter.In in, AsyncHttpJob asyncHttpJob) {
        this.parameter = in;
        this.mHttpJob = asyncHttpJob;
    }

    public HttpResult doGet() {
        HttpResult httpResult = new HttpResult();
        this.count = 0;
        String string = this.parameter.requestUrl;
        if (!TextUtils.isEmpty((CharSequence)this.parameter.params)) {
            string = string.endsWith("?") ? this.parameter.requestUrl + this.parameter.params : this.parameter.requestUrl + "?" + this.parameter.params;
        }
        string = string.replaceAll(" ", "%20");
        while (this.count < this.parameter.tryCount) {
            try {
                int n2;
                URL uRL = new URL(string);
                HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
                httpURLConnection.setConnectTimeout(this.parameter.connectTimeout);
                httpURLConnection.setReadTimeout(this.parameter.readTimeout);
                httpURLConnection.setDoInput(true);
                httpURLConnection.setUseCaches(false);
                httpURLConnection.setRequestMethod("GET");
                boolean bl = this.setHeaders(httpURLConnection, this.parameter.requestHeaders);
                httpURLConnection.connect();
                if (this.mHttpJob != null) {
                    this.mHttpJob.cancelTimeOut();
                }
                httpResult.responseCode = n2 = httpURLConnection.getResponseCode();
                CLog.i(TAG, "doGet responseCode:" + n2 + "  " + this.count);
                if (n2 == 200) {
                    String string2 = this.readHttpResult(httpURLConnection, bl);
                    httpResult.resultType = 0;
                    httpResult.result = string2;
                    return httpResult;
                }
                if (this.count < this.parameter.tryCount - 1 && this.parameter.trySpace > 0) {
                    try {
                        Thread.sleep(this.parameter.trySpace);
                    }
                    catch (Exception exception) {
                        CLog.w(TAG, "Exception when doGet retry sleep " + exception);
                    }
                }
            }
            catch (Exception exception) {
                CLog.w(TAG, exception);
            }
            catch (Error error) {
                CLog.w(TAG, error);
            }
            ++this.count;
        }
        httpResult.resultType = 1;
        httpResult.result = null;
        return httpResult;
    }

    public HttpResult doPost() {
        HttpResult httpResult = new HttpResult();
        this.count = 0;
        while (this.count < this.parameter.tryCount) {
            try {
                int n2;
                String string = this.parameter.requestUrl;
                URL uRL = new URL(string);
                CLog.i(TAG, string + "  path post");
                HttpURLConnection httpURLConnection = null;
                httpURLConnection = (HttpURLConnection)uRL.openConnection();
                httpURLConnection.setConnectTimeout(this.parameter.connectTimeout);
                httpURLConnection.setReadTimeout(this.parameter.readTimeout);
                httpURLConnection.setDoInput(true);
                httpURLConnection.setDoOutput(true);
                httpURLConnection.setRequestMethod("POST");
                httpURLConnection.setUseCaches(false);
                httpURLConnection.setInstanceFollowRedirects(true);
                httpURLConnection.setRequestProperty("Content-Type", "application/json");
                boolean bl = this.setHeaders(httpURLConnection, this.parameter.requestHeaders);
                httpURLConnection.connect();
                if (this.mHttpJob != null) {
                    this.mHttpJob.cancelTimeOut();
                }
                DataOutputStream dataOutputStream = null;
                if (!TextUtils.isEmpty((CharSequence)this.parameter.params)) {
                    dataOutputStream = new DataOutputStream(httpURLConnection.getOutputStream());
                    dataOutputStream.write(this.parameter.params.getBytes("UTF-8"));
                    dataOutputStream.flush();
                }
                httpResult.responseCode = n2 = httpURLConnection.getResponseCode();
                CLog.i(TAG, "doPost responseCode:" + n2);
                if (n2 == 200) {
                    String string2 = this.readHttpResult(httpURLConnection, bl);
                    httpResult.resultType = 0;
                    httpResult.result = string2;
                    return httpResult;
                }
                if (this.count < this.parameter.tryCount - 1 && this.parameter.trySpace > 0) {
                    try {
                        Thread.sleep(this.parameter.trySpace);
                    }
                    catch (Exception exception) {
                        CLog.w(TAG, "Exception when doPost retry sleep " + exception);
                    }
                }
            }
            catch (Exception exception) {
                CLog.w(TAG, exception);
            }
            catch (Error error) {
                CLog.w(TAG, error);
            }
            ++this.count;
        }
        httpResult.resultType = 1;
        httpResult.result = null;
        return httpResult;
    }

    public boolean setHeaders(URLConnection uRLConnection, Map<String, String> map) {
        boolean bl = false;
        if (map != null && map.size() > 0) {
            Iterator<String> iterator = map.keySet().iterator();
            while (iterator.hasNext()) {
                String string = iterator.next().toString();
                String string2 = map.get(string);
                if ("gzip".equals(string2)) {
                    bl = true;
                }
                uRLConnection.setRequestProperty(string, string2);
            }
        }
        return bl;
    }

    public String readHttpResult(URLConnection uRLConnection, boolean bl) {
        Object object;
        StringBuffer stringBuffer = null;
        InputStream inputStream = null;
        inputStream = bl ? new GZIPInputStream(uRLConnection.getInputStream()) : uRLConnection.getInputStream();
        if (inputStream != null) {
            object = new InputStreamReader(inputStream, "UTF-8");
            stringBuffer = new StringBuffer();
            int n2 = ((InputStreamReader)object).read();
            while (n2 != -1) {
                stringBuffer.append((char)n2);
                n2 = ((InputStreamReader)object).read();
            }
            inputStream.close();
            ((InputStreamReader)object).close();
        }
        object = null;
        if (stringBuffer != null) {
            object = stringBuffer.toString();
        }
        if (TextUtils.isEmpty((CharSequence)object)) {
            return "";
        }
        return object;
    }
}

