/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.sdk.source.business;

import android.content.Context;
import com.hpplay.component.screencapture.view.SecondMirrorView;
import com.hpplay.sdk.source.bean.DramaInfoBean;
import com.hpplay.sdk.source.bean.OutParameter;
import com.hpplay.sdk.source.bean.StopInfo;
import com.hpplay.sdk.source.browse.data.BrowserInfo;
import com.hpplay.sdk.source.business.LelinkPlayerListenerDispatcher;
import com.hpplay.sdk.source.business.cloud.SourceDataReport;
import com.hpplay.sdk.source.da.e;
import com.hpplay.sdk.source.log.SourceLog;
import com.hpplay.sdk.source.player.CastPlayer;
import com.hpplay.sdk.source.player.ICastPlayer;
import com.hpplay.sdk.source.player.IPlayer;
import com.hpplay.sdk.source.player.listener.OnCompletionListener;
import com.hpplay.sdk.source.player.listener.OnErrorListener;
import com.hpplay.sdk.source.player.listener.OnInfoListener;
import com.hpplay.sdk.source.player.listener.OnLoadingListener;
import com.hpplay.sdk.source.player.listener.OnPreparedListener;
import com.hpplay.sdk.source.player.listener.OnStateChangeListener;
import com.hpplay.sdk.source.player.listener.OnStopListener;
import com.hpplay.sdk.source.process.ConnectManager;
import com.hpplay.sdk.source.process.LelinkSdkManager;
import com.hpplay.sdk.source.utils.CastUtil;
import com.hpplay.sdk.source.utils.Feature;

public class PlayController
implements IPlayer {
    private static final String TAG = "PlayController";
    private Context mContext;
    private OutParameter mPlayInfo;
    private CastPlayer mCastPlayer;
    private int mCurrentState = -1;
    private boolean isStopped = false;
    private boolean isReleased = false;
    private boolean isReportStop = false;
    private boolean retry = false;
    private boolean disconnectFromUser = false;
    private String mReportStopDramaId = null;
    private int mStopType = 0;
    private long mPlayedDuration = -1L;
    private long mDuration = -1L;
    private LelinkPlayerListenerDispatcher mLelinkPlayerListener;
    private OnLoadingListener mLoadingListener = new OnLoadingListener(){

        @Override
        public void onLoading(ICastPlayer iCastPlayer, String string) {
            SourceLog.i(PlayController.TAG, "onLoading " + PlayController.this + " reportExtra:  " + string);
            SourceDataReport.getInstance().onCastSuccess(PlayController.this.mPlayInfo, PlayController.this.retry, string);
            if (PlayController.this.mPlayInfo != null) {
                switch (((PlayController)PlayController.this).mPlayInfo.castType) {
                    case 2: {
                        PlayController.this.mCurrentState = 1;
                        break;
                    }
                    case 1: {
                        if (((PlayController)PlayController.this).mPlayInfo.mimeType == 102) {
                            PlayController.this.mCurrentState = 2;
                            break;
                        }
                        if (((PlayController)PlayController.this).mPlayInfo.mimeType == 101) {
                            PlayController.this.mCurrentState = 3;
                            break;
                        }
                        if (((PlayController)PlayController.this).mPlayInfo.mimeType != 103) break;
                        PlayController.this.mCurrentState = 4;
                    }
                }
                ConnectManager.getInstance().notifyCastSuccess(((PlayController)PlayController.this).mPlayInfo.serviceInfo);
            }
            if (PlayController.this.mLelinkPlayerListener != null) {
                PlayController.this.mLelinkPlayerListener.onLoading(PlayController.this.mPlayInfo);
            }
        }
    };
    private OnPreparedListener mPreparedListener = new OnPreparedListener(){

        @Override
        public void onPrepared(ICastPlayer iCastPlayer) {
            SourceLog.i(PlayController.TAG, "onPrepared");
            switch (((PlayController)PlayController.this).mPlayInfo.castType) {
                case 2: {
                    PlayController.this.mCurrentState = 5;
                    break;
                }
                case 1: {
                    if (((PlayController)PlayController.this).mPlayInfo.mimeType == 102) {
                        PlayController.this.mCurrentState = 6;
                        break;
                    }
                    if (((PlayController)PlayController.this).mPlayInfo.mimeType == 101) {
                        PlayController.this.mCurrentState = 7;
                        break;
                    }
                    if (((PlayController)PlayController.this).mPlayInfo.mimeType != 103) break;
                    PlayController.this.mCurrentState = 8;
                }
            }
            SourceDataReport.getInstance().onCastRender(PlayController.this.mPlayInfo);
            if (PlayController.this.mLelinkPlayerListener != null) {
                PlayController.this.mLelinkPlayerListener.onStart(PlayController.this.mPlayInfo);
            }
            ConnectManager.getInstance().notifyCastSuccess(((PlayController)PlayController.this).mPlayInfo.serviceInfo);
            if (((PlayController)PlayController.this).mPlayInfo.pushType == 1) {
                e.d().a(PlayController.this.mPlayInfo);
            }
        }
    };
    private OnStateChangeListener mStateChangeListener = new OnStateChangeListener(){

        @Override
        public void onStateChanged(ICastPlayer iCastPlayer, int n2) {
            if (PlayController.this.mCurrentState == n2) {
                SourceLog.i(PlayController.TAG, "onStateChanged ignore " + PlayController.this.mCurrentState + "/" + n2);
                return;
            }
            SourceLog.i(PlayController.TAG, "onStateChanged " + n2 + "/" + PlayController.this.mCurrentState);
            if (PlayController.this.mLelinkPlayerListener != null) {
                if (n2 == 3) {
                    if (PlayController.this.disconnectFromUser && !ConnectManager.getInstance().isConnected(PlayController.this.mPlayInfo)) {
                        SourceLog.i(PlayController.TAG, "onStateChanged stop disconnectFromUser");
                        PlayController.this.stop(1005);
                    }
                    switch (((PlayController)PlayController.this).mPlayInfo.castType) {
                        case 2: {
                            if (PlayController.this.mCurrentState == 5) {
                                return;
                            }
                            PlayController.this.mCurrentState = 5;
                            break;
                        }
                        case 1: {
                            if (((PlayController)PlayController.this).mPlayInfo.mimeType == 102) {
                                PlayController.this.mCurrentState = 6;
                                break;
                            }
                            if (((PlayController)PlayController.this).mPlayInfo.mimeType == 101) {
                                PlayController.this.mCurrentState = 7;
                                break;
                            }
                            if (((PlayController)PlayController.this).mPlayInfo.mimeType != 103) break;
                            PlayController.this.mCurrentState = 8;
                        }
                    }
                    PlayController.this.mLelinkPlayerListener.onStart(PlayController.this.mPlayInfo);
                } else {
                    switch (((PlayController)PlayController.this).mPlayInfo.castType) {
                        case 2: {
                            PlayController.this.mCurrentState = 11;
                            break;
                        }
                        case 1: {
                            if (((PlayController)PlayController.this).mPlayInfo.mimeType == 102) {
                                PlayController.this.mCurrentState = 9;
                                break;
                            }
                            if (((PlayController)PlayController.this).mPlayInfo.mimeType != 101) break;
                            PlayController.this.mCurrentState = 10;
                        }
                    }
                    PlayController.this.mLelinkPlayerListener.onPause(PlayController.this.mPlayInfo);
                }
            }
        }
    };
    private final OnInfoListener mInfoListener = new OnInfoListener(){

        @Override
        public void onInfo(ICastPlayer iCastPlayer, int n2, int n3, int n4) {
            switch (n2) {
                case 100: {
                    SourceLog.i(PlayController.TAG, "onPositionUpdate duration:" + n3 + "/" + n4);
                    PlayController.this.mPlayedDuration = Math.max(PlayController.this.mPlayedDuration, (long)n4);
                    PlayController.this.mDuration = n3;
                    if (PlayController.this.mLelinkPlayerListener != null) {
                        PlayController.this.mLelinkPlayerListener.onPositionUpdate(PlayController.this.mPlayInfo, n3, n4);
                    }
                    ConnectManager.getInstance().notifyCastStatusValid(((PlayController)PlayController.this).mPlayInfo.serviceInfo);
                    break;
                }
                default: {
                    SourceLog.i(PlayController.TAG, "onInfo " + n3 + "/" + n4);
                }
            }
        }

        @Override
        public void onInfo(ICastPlayer iCastPlayer, int n2, String string) {
            if (PlayController.this.mLelinkPlayerListener != null) {
                PlayController.this.mLelinkPlayerListener.onInfo(PlayController.this.mPlayInfo, n2, string);
            }
        }
    };
    private final OnErrorListener mErrorListener = new OnErrorListener(){

        @Override
        public void onError(ICastPlayer iCastPlayer, int n2, int n3, String string) {
            SourceLog.i(PlayController.TAG, "onError " + n2 + "/" + n3);
            if (PlayController.this.retry(n2, n3)) {
                PlayController.this.retry = true;
                PlayController.this.reopen();
                return;
            }
            if (n3 == 211026) {
                if (((PlayController)PlayController.this).mPlayInfo.castType == 1) {
                    SourceDataReport.getInstance().onCastFailed(PlayController.this.mPlayInfo, "120103101", "", PlayController.this.retry, null);
                } else {
                    SourceDataReport.getInstance().onCastFailed(PlayController.this.mPlayInfo, "120105101", "", PlayController.this.retry, null);
                }
            } else {
                SourceDataReport.getInstance().onCastFailed(PlayController.this.mPlayInfo, "", "", PlayController.this.retry, string);
                ConnectManager.getInstance().notifyCastError(((PlayController)PlayController.this).mPlayInfo.serviceInfo);
                if (Feature.isLeboApp()) {
                    if (((PlayController)PlayController.this).mPlayInfo.castType == 1) {
                        LelinkSdkManager.getInstance().uploadLog("1003", "");
                    } else if (((PlayController)PlayController.this).mPlayInfo.castType == 2) {
                        LelinkSdkManager.getInstance().uploadLog("2009", "");
                    }
                }
            }
            if (PlayController.this.mLelinkPlayerListener != null) {
                PlayController.this.mLelinkPlayerListener.onError(PlayController.this.mPlayInfo, n2, n3, string);
            }
            PlayController.this.pushAfterDa();
        }
    };
    private final OnCompletionListener mCompletionListener = new OnCompletionListener(){

        @Override
        public void onComplete(ICastPlayer iCastPlayer) {
            SourceLog.i(PlayController.TAG, "onComplete current:" + PlayController.this.mCurrentState);
            if (PlayController.this.mLelinkPlayerListener != null && PlayController.this.mCurrentState != 0) {
                PlayController.this.mCurrentState = 0;
                PlayController.this.mLelinkPlayerListener.onCompletion(PlayController.this.mPlayInfo, 0);
            } else {
                PlayController.this.mCurrentState = 0;
                if (PlayController.this.mLelinkPlayerListener != null) {
                    PlayController.this.mLelinkPlayerListener.onStop(PlayController.this.mPlayInfo);
                }
            }
            if (PlayController.this.mStopType <= 0) {
                PlayController.this.mStopType = 1002;
            }
            PlayController.this.reportStop();
            PlayController.this.pushAfterDa();
        }
    };
    private final OnStopListener mStopListener = new OnStopListener(){

        @Override
        public void onStop(ICastPlayer iCastPlayer, StopInfo stopInfo) {
            SourceLog.i(PlayController.TAG, "onStop current:" + PlayController.this.mCurrentState);
            if (PlayController.this.mStopType <= 0) {
                PlayController.this.mStopType = 1003;
            }
            if (PlayController.this.mLelinkPlayerListener != null && PlayController.this.mCurrentState != 0) {
                PlayController.this.mCurrentState = 0;
                if (stopInfo != null && stopInfo.type == 3) {
                    if (PlayController.this.mStopType <= 0) {
                        PlayController.this.mStopType = 1002;
                    }
                    PlayController.this.mLelinkPlayerListener.onCompletion(PlayController.this.mPlayInfo, 1);
                } else {
                    PlayController.this.mLelinkPlayerListener.onStop(PlayController.this.mPlayInfo);
                }
            } else {
                PlayController.this.mCurrentState = 0;
                if (PlayController.this.mLelinkPlayerListener != null) {
                    PlayController.this.mLelinkPlayerListener.onStop(PlayController.this.mPlayInfo);
                }
            }
            PlayController.this.reportStop();
            if (PlayController.this.mStopType == 1003 && stopInfo != null && stopInfo.type != 4) {
                PlayController.this.pushAfterDa();
            }
        }
    };

    public PlayController(Context context, OutParameter outParameter) {
        this.mContext = context;
        this.mPlayInfo = outParameter;
        this.initPlayer();
    }

    private void initPlayer() {
        if (this.mCastPlayer != null) {
            this.mCastPlayer.release(this.mPlayInfo.getKey());
            this.mCastPlayer = null;
        }
        this.mCastPlayer = new CastPlayer(this.mContext, this.mPlayInfo);
        this.mCastPlayer.setOnLoadingListener(this.mLoadingListener);
        this.mCastPlayer.setOnPreparedListener(this.mPreparedListener);
        this.mCastPlayer.setOnStateChangeListener(this.mStateChangeListener);
        this.mCastPlayer.setOnInfoListener(this.mInfoListener);
        this.mCastPlayer.setOnErrorListener(this.mErrorListener);
        this.mCastPlayer.setOnCompletionListener(this.mCompletionListener);
        this.mCastPlayer.setOnStopListener(this.mStopListener);
    }

    public void reopen() {
        SourceLog.i(TAG, "reopen");
        this.initPlayer();
        this.setDataSource(this.mPlayInfo);
        this.start();
    }

    public void setDataSource(OutParameter outParameter, int n2) {
        this.setDataSource(outParameter);
        SourceLog.i(TAG, " setDataSource    " + outParameter.urlID + "  " + outParameter.session);
        SourceDataReport.getInstance().onCastStart(outParameter, n2);
    }

    @Override
    public void setDataSource(OutParameter outParameter) {
        this.mPlayInfo = outParameter;
        this.mCastPlayer.setDataSource(outParameter);
    }

    public void start() {
        if (this.mPlayInfo == null) {
            SourceLog.w(TAG, "start ignore");
            return;
        }
        this.isReportStop = false;
        this.start(this.mPlayInfo.getKey());
    }

    @Override
    public boolean start(String string) {
        if (!this.isInPlaybackState()) {
            SourceLog.w(TAG, "start ignore 2: " + this.mCurrentState);
            return false;
        }
        return this.mCastPlayer.start(string);
    }

    public void pause() {
        if (this.mPlayInfo == null) {
            SourceLog.w(TAG, "pause ignore " + this.mCurrentState);
            return;
        }
        if (this.mPlayInfo.pushType == 1) {
            SourceLog.w(TAG, "pause ignore, da cannot seek");
            return;
        }
        this.pause(this.mPlayInfo.getKey());
    }

    @Override
    public boolean pause(String string) {
        if (!this.isInPlaybackState()) {
            SourceLog.w(TAG, "pause ignore 2: " + this.mCurrentState);
            return false;
        }
        return this.mCastPlayer.pause(string);
    }

    public void playDrama(String string) {
        if (this.mPlayInfo == null) {
            SourceLog.w(TAG, "playDrama ignore " + this.mCurrentState);
            return;
        }
        this.playDrama(this.mPlayInfo.getKey(), string);
    }

    @Override
    public boolean playDrama(String string, String string2) {
        return this.mCastPlayer.playDrama(string, string2);
    }

    public void playNextDrama() {
        if (this.mPlayInfo == null) {
            SourceLog.w(TAG, "playNextDrama ignore " + this.mCurrentState);
            return;
        }
        this.playNextDrama(this.mPlayInfo.getKey());
    }

    @Override
    public boolean playNextDrama(String string) {
        return this.mCastPlayer.playNextDrama(string);
    }

    public void playPreDrama() {
        if (this.mPlayInfo == null) {
            SourceLog.w(TAG, "playPreDrama ignore " + this.mCurrentState);
            return;
        }
        this.playPreDrama(this.mPlayInfo.getKey());
    }

    @Override
    public boolean playPreDrama(String string) {
        return this.mCastPlayer.playPreDrama(string);
    }

    public void appendPlayList(DramaInfoBean[] dramaInfoBeanArray, int n2, int n3, int n4) {
        if (this.mPlayInfo == null) {
            SourceLog.w(TAG, "setPlayList ignore " + this.mCurrentState);
            return;
        }
        this.appendPlayList(this.mPlayInfo.getKey(), dramaInfoBeanArray, n2, n3, n4);
    }

    public void clearPlayList() {
        if (this.mPlayInfo == null) {
            SourceLog.w(TAG, "clearPlayList ignore " + this.mCurrentState);
            return;
        }
        this.clearPlayList(this.mPlayInfo.getKey());
    }

    @Override
    public boolean appendPlayList(String string, DramaInfoBean[] dramaInfoBeanArray, int n2, int n3, int n4) {
        return this.mCastPlayer.appendPlayList(string, dramaInfoBeanArray, n2, n3, n4);
    }

    @Override
    public boolean clearPlayList(String string) {
        return this.mCastPlayer.clearPlayList(string);
    }

    @Override
    public void setWatermarkVisible(boolean bl) {
        this.mCastPlayer.setWatermarkVisible(bl);
    }

    @Override
    public void setMirrorScreenSecret(boolean bl) {
        this.mCastPlayer.setMirrorScreenSecret(bl);
    }

    public void resume() {
        if (this.mPlayInfo == null) {
            SourceLog.w(TAG, "pause ignore " + this.mCurrentState);
            return;
        }
        this.resume(this.mPlayInfo.getKey());
    }

    @Override
    public boolean resume(String string) {
        if (!this.isInPlaybackState()) {
            SourceLog.w(TAG, "pause ignore 2: " + this.mCurrentState);
            return false;
        }
        return this.mCastPlayer.resume(string);
    }

    public void seekTo(int n2) {
        if (this.mPlayInfo == null) {
            SourceLog.w(TAG, "seekTo ignore");
            return;
        }
        if (this.mPlayInfo.pushType == 1) {
            SourceLog.w(TAG, "seekTo ignore, da cannot seek");
            return;
        }
        if (!this.isInPlaybackState()) {
            SourceLog.w(TAG, "seekTo ignore 2: " + this.mCurrentState);
            return;
        }
        this.seekTo(this.mPlayInfo.getKey(), n2);
    }

    @Override
    public boolean seekTo(String string, int n2) {
        return this.mCastPlayer.seekTo(string, n2);
    }

    public void stop(int n2) {
        SourceLog.i(TAG, "stop stopType: " + n2);
        if (this.mPlayInfo == null) {
            return;
        }
        if (n2 == 1005) {
            this.disconnectFromUser = true;
        }
        if (!this.isInPlaybackState()) {
            SourceLog.w(TAG, "stop ignore 2: " + this.mCurrentState);
            return;
        }
        if (this.mStopType <= 0) {
            this.mStopType = n2;
        }
        this.stop(this.mPlayInfo.getKey());
        this.reportStop();
    }

    public void stopWithCallback(int n2) {
        this.stop(n2);
        if (this.mLelinkPlayerListener != null) {
            this.mLelinkPlayerListener.onStop(this.mPlayInfo);
        }
    }

    @Override
    public void stop(String string) {
        SourceLog.i(TAG, "play control stop");
        this.isStopped = true;
        this.mCurrentState = 0;
        this.mCastPlayer.stop(string);
    }

    public void setLelinkPlayerListener(LelinkPlayerListenerDispatcher lelinkPlayerListenerDispatcher) {
        this.mLelinkPlayerListener = lelinkPlayerListenerDispatcher;
    }

    public int getCurrentPlayState() {
        SourceLog.w(TAG, "getCurrentPlayState " + this.mCurrentState);
        return this.mCurrentState;
    }

    @Override
    public void addVolume() {
        if (!this.isInPlaybackState()) {
            SourceLog.w(TAG, "addVolume ignore " + this.mCurrentState);
            return;
        }
        this.mCastPlayer.addVolume();
    }

    @Override
    public void subVolume() {
        if (!this.isInPlaybackState()) {
            SourceLog.w(TAG, "subVolume ignore " + this.mCurrentState);
            return;
        }
        this.mCastPlayer.subVolume();
    }

    public void onAppPause() {
        if (this.mCastPlayer != null) {
            this.mCastPlayer.onAppPause();
        }
    }

    public void onAppResume() {
        if (this.mCastPlayer != null) {
            this.mCastPlayer.onAppResume();
        }
    }

    @Override
    @Deprecated
    public void setVolume(int n2) {
        this.mCastPlayer.setVolume(n2);
    }

    @Override
    public void selectAudiotrack(int n2) {
        if (!this.isInPlaybackState()) {
            SourceLog.w(TAG, "selectAudiotrack ignore " + this.mCurrentState);
            return;
        }
        this.mCastPlayer.selectAudiotrack(n2);
    }

    public OutParameter getPlayInfo() {
        return this.mPlayInfo;
    }

    @Override
    public boolean switchExpansionScreen(boolean bl) {
        return this.mCastPlayer.switchExpansionScreen(bl);
    }

    @Override
    public void setSecondMirrorView(SecondMirrorView secondMirrorView) {
        this.mCastPlayer.setSecondMirrorView(secondMirrorView);
    }

    public void doChangeChannel(int n2) {
        this.mCastPlayer.doChangeChannel(n2);
    }

    public void onWifiConnected() {
        this.mCastPlayer.onWifiConnected();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void reportStop() {
        if (this.mPlayInfo != null && this.mPlayInfo.urls != null) {
            if (this.mReportStopDramaId != null && this.mReportStopDramaId.equals(this.mPlayInfo.dramaID)) return;
            this.mReportStopDramaId = this.mPlayInfo.dramaID;
        } else {
            if (this.isReportStop) {
                return;
            }
            this.isReportStop = true;
        }
        if (this.mPlayInfo == null) return;
        SourceDataReport.getInstance().onCastStop(this.mPlayInfo, this.mStopType);
        if (this.mPlayInfo.pushType != 1) return;
        long l2 = this.mPlayedDuration;
        if (this.mStopType == 1002) {
            l2 = Math.max(this.mPlayedDuration, this.mDuration);
        }
        e.d().a(this.mPlayInfo, l2);
    }

    public void setStopType(int n2) {
        if (this.mStopType <= 0) {
            this.mStopType = n2;
        }
    }

    private void pushAfterDa() {
        if (this.mPlayInfo != null && this.mPlayInfo.pushType == 1) {
            e.d().b(this.mContext);
        }
    }

    public ICastPlayer getMediaPlayer() {
        return this.mCastPlayer == null ? null : this.mCastPlayer.getMediaPlayer();
    }

    public void release() {
        if (this.mPlayInfo == null) {
            return;
        }
        this.release(this.mPlayInfo.getKey());
    }

    @Override
    public void release(String string) {
        this.reportStop();
        this.isReleased = true;
        this.mCastPlayer.release(string);
        e.d().b();
    }

    public boolean isInPlaybackState() {
        return this.mCastPlayer != null && this.mCurrentState != 0;
    }

    private boolean retry(int n2, int n3) {
        if (this.isStopped || this.isReleased) {
            return false;
        }
        if (n3 == 211026 || n3 == 211001 || n3 == 211002 || n3 == 211055) {
            return false;
        }
        BrowserInfo browserInfo = CastUtil.getBrowserInfo(this.mPlayInfo.serviceInfo, 3);
        BrowserInfo browserInfo2 = CastUtil.getBrowserInfo(this.mPlayInfo.serviceInfo, 4);
        if (this.mPlayInfo.castType == 2) {
            switch (this.mPlayInfo.protocol) {
                case 1: {
                    if (this.mPlayInfo.connectProtocol == 4 && browserInfo2 != null && (Feature.isLeboApp() || Feature.isHappyTest())) {
                        this.mPlayInfo.protocol = 4;
                        this.mPlayInfo.currentBrowserInfo = browserInfo2;
                        SourceLog.i(TAG, "retry with im");
                        return true;
                    }
                    return false;
                }
            }
            return false;
        }
        switch (this.mPlayInfo.protocol) {
            case 1: {
                if (browserInfo != null) {
                    this.mPlayInfo.protocol = 3;
                    this.mPlayInfo.currentBrowserInfo = browserInfo;
                    SourceLog.i(TAG, "retry with dlna");
                    return true;
                }
                if (browserInfo2 != null) {
                    this.mPlayInfo.protocol = 4;
                    this.mPlayInfo.currentBrowserInfo = browserInfo2;
                    SourceLog.i(TAG, "retry with im");
                    return true;
                }
                return false;
            }
            case 3: {
                if (browserInfo2 != null) {
                    this.mPlayInfo.protocol = 4;
                    this.mPlayInfo.currentBrowserInfo = browserInfo2;
                    SourceLog.i(TAG, "retry with im");
                    return true;
                }
                return false;
            }
        }
        return false;
    }
}

