/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.cybergarage.upnp;

import com.hpplay.cybergarage.upnp.AllowedValue;
import com.hpplay.cybergarage.upnp.AllowedValueList;
import com.hpplay.cybergarage.upnp.AllowedValueRange;
import com.hpplay.cybergarage.upnp.Service;
import com.hpplay.cybergarage.upnp.UPnPStatus;
import com.hpplay.cybergarage.upnp.control.QueryListener;
import com.hpplay.cybergarage.upnp.control.QueryRequest;
import com.hpplay.cybergarage.upnp.control.QueryResponse;
import com.hpplay.cybergarage.upnp.xml.NodeData;
import com.hpplay.cybergarage.upnp.xml.StateVariableData;
import com.hpplay.cybergarage.xml.Node;

public class StateVariable
extends NodeData {
    public static final String ELEM_NAME = "stateVariable";
    private Node stateVariableNode;
    private Node serviceNode;
    private static final String NAME = "name";
    private static final String DATATYPE = "dataType";
    private static final String SENDEVENTS = "sendEvents";
    private static final String SENDEVENTS_YES = "yes";
    private static final String SENDEVENTS_NO = "no";
    private UPnPStatus upnpStatus = new UPnPStatus();
    private static final String DEFAULT_VALUE = "defaultValue";
    private Object userData = null;

    public Node getServiceNode() {
        return this.serviceNode;
    }

    void setServiceNode(Node node) {
        this.serviceNode = node;
    }

    public Service getService() {
        Node node = this.getServiceNode();
        if (node == null) {
            return null;
        }
        return new Service(node);
    }

    public Node getStateVariableNode() {
        return this.stateVariableNode;
    }

    public StateVariable() {
        this.serviceNode = null;
        this.stateVariableNode = new Node(ELEM_NAME);
    }

    public StateVariable(Node node, Node node2) {
        this.serviceNode = node;
        this.stateVariableNode = node2;
    }

    public static boolean isStateVariableNode(Node node) {
        return ELEM_NAME.equals(node.getName());
    }

    public void setName(String string) {
        this.getStateVariableNode().setNode(NAME, string);
    }

    public String getName() {
        return this.getStateVariableNode().getNodeValue(NAME);
    }

    public void setDataType(String string) {
        this.getStateVariableNode().setNode(DATATYPE, string);
    }

    public String getDataType() {
        return this.getStateVariableNode().getNodeValue(DATATYPE);
    }

    public void setSendEvents(boolean bl) {
        this.getStateVariableNode().setAttribute(SENDEVENTS, bl ? SENDEVENTS_YES : SENDEVENTS_NO);
    }

    public boolean isSendEvents() {
        String string = this.getStateVariableNode().getAttributeValue(SENDEVENTS);
        if (string == null) {
            return false;
        }
        return string.equalsIgnoreCase(SENDEVENTS_YES);
    }

    public void set(StateVariable stateVariable) {
        this.setName(stateVariable.getName());
        this.setValue(stateVariable.getValue());
        this.setDataType(stateVariable.getDataType());
        this.setSendEvents(stateVariable.isSendEvents());
    }

    public StateVariableData getStateVariableData() {
        Node node = this.getStateVariableNode();
        StateVariableData stateVariableData = (StateVariableData)node.getUserData();
        if (stateVariableData == null) {
            stateVariableData = new StateVariableData();
            node.setUserData(stateVariableData);
            stateVariableData.setNode(node);
        }
        return stateVariableData;
    }

    public void setValue(String string) {
        String string2 = this.getStateVariableData().getValue();
        if (string2 != null && string2.equals(string)) {
            return;
        }
        this.getStateVariableData().setValue(string);
        Service service = this.getService();
        if (service == null) {
            return;
        }
        if (!this.isSendEvents()) {
            return;
        }
        service.notify(this);
    }

    public void setValue(int n2) {
        this.setValue(Integer.toString(n2));
    }

    public void setValue(long l2) {
        this.setValue(Long.toString(l2));
    }

    public String getValue() {
        return this.getStateVariableData().getValue();
    }

    public AllowedValueList getAllowedValueList() {
        AllowedValueList allowedValueList = new AllowedValueList();
        Node node = this.getStateVariableNode().getNode("allowedValueList");
        if (node == null) {
            return null;
        }
        int n2 = node.getNNodes();
        for (int i2 = 0; i2 < n2; ++i2) {
            Node node2 = node.getNode(i2);
            if (!AllowedValue.isAllowedValueNode(node2)) continue;
            AllowedValue allowedValue = new AllowedValue(node2);
            allowedValueList.add(allowedValue);
        }
        return allowedValueList;
    }

    public void setAllowedValueList(AllowedValueList allowedValueList) {
        this.getStateVariableNode().removeNode("allowedValueList");
        this.getStateVariableNode().removeNode("allowedValueRange");
        Node node = new Node("allowedValueList");
        for (AllowedValue allowedValue : allowedValueList) {
            node.addNode(allowedValue.getAllowedValueNode());
        }
        this.getStateVariableNode().addNode(node);
    }

    public boolean hasAllowedValueList() {
        AllowedValueList allowedValueList = this.getAllowedValueList();
        return allowedValueList != null;
    }

    public AllowedValueRange getAllowedValueRange() {
        Node node = this.getStateVariableNode().getNode("allowedValueRange");
        if (node == null) {
            return null;
        }
        return new AllowedValueRange(node);
    }

    public void setAllowedValueRange(AllowedValueRange allowedValueRange) {
        this.getStateVariableNode().removeNode("allowedValueList");
        this.getStateVariableNode().removeNode("allowedValueRange");
        this.getStateVariableNode().addNode(allowedValueRange.getAllowedValueRangeNode());
    }

    public boolean hasAllowedValueRange() {
        return this.getAllowedValueRange() != null;
    }

    public QueryListener getQueryListener() {
        return this.getStateVariableData().getQueryListener();
    }

    public void setQueryListener(QueryListener queryListener) {
        this.getStateVariableData().setQueryListener(queryListener);
    }

    public boolean performQueryListener(QueryRequest queryRequest) {
        QueryListener queryListener = this.getQueryListener();
        if (queryListener == null) {
            return false;
        }
        QueryResponse queryResponse = new QueryResponse();
        StateVariable stateVariable = new StateVariable();
        stateVariable.set(this);
        stateVariable.setValue("");
        stateVariable.setStatus(404);
        if (queryListener.queryControlReceived(stateVariable)) {
            queryResponse.setResponse(stateVariable);
        } else {
            UPnPStatus uPnPStatus = stateVariable.getStatus();
            queryResponse.setFaultResponse(uPnPStatus.getCode(), uPnPStatus.getDescription());
        }
        queryRequest.post(queryResponse);
        return true;
    }

    public QueryResponse getQueryResponse() {
        return this.getStateVariableData().getQueryResponse();
    }

    private void setQueryResponse(QueryResponse queryResponse) {
        this.getStateVariableData().setQueryResponse(queryResponse);
    }

    public UPnPStatus getQueryStatus() {
        return this.getQueryResponse().getUPnPError();
    }

    public boolean postQuerylAction() {
        QueryRequest queryRequest = new QueryRequest();
        queryRequest.setRequest(this);
        queryRequest.print();
        QueryResponse queryResponse = queryRequest.post();
        queryResponse.print();
        this.setQueryResponse(queryResponse);
        if (!queryResponse.isSuccessful()) {
            this.setValue(queryResponse.getReturnValue());
            return false;
        }
        this.setValue(queryResponse.getReturnValue());
        return true;
    }

    public void setStatus(int n2, String string) {
        this.upnpStatus.setCode(n2);
        this.upnpStatus.setDescription(string);
    }

    public void setStatus(int n2) {
        this.setStatus(n2, UPnPStatus.code2String(n2));
    }

    public UPnPStatus getStatus() {
        return this.upnpStatus;
    }

    public String getDefaultValue() {
        return this.getStateVariableNode().getNodeValue(DEFAULT_VALUE);
    }

    public void setDefaultValue(String string) {
        this.getStateVariableNode().setNode(DEFAULT_VALUE, string);
    }

    public void setUserData(Object object) {
        this.userData = object;
    }

    public Object getUserData() {
        return this.userData;
    }
}

