/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.sdk.source.protocol.connect;

import android.util.SparseArray;
import com.hpplay.component.modulelinker.api.ModuleLinker;
import com.hpplay.sdk.source.api.IConnectListener;
import com.hpplay.sdk.source.browse.api.LelinkServiceInfo;
import com.hpplay.sdk.source.browse.data.BrowserInfo;
import com.hpplay.sdk.source.log.SourceLog;
import com.hpplay.sdk.source.protocol.connect.CloudConnectBridge;
import com.hpplay.sdk.source.protocol.connect.ConnectBridge;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicInteger;

public class GroupConnectBridge
extends ConnectBridge {
    public static final String TAG = "ConnectGroupBridge";
    public static final int CONNECT_TIME_OUT = 2000;
    public static final int STATE_IDLE = 0;
    public static final int STATE_CONNECTED = 1;
    public static final int STATE_CONNECT_FAILED = 2;
    private final AtomicInteger mLocalConnectState = new AtomicInteger();
    private final AtomicInteger mCloudConnectState = new AtomicInteger();
    private IConnectListener mConnectCheckListener;
    private IConnectListener mOuterListener;
    private IConnectListener mReconnectListener;
    private final Timer mTimer = new Timer();
    private ConnectWaitTask mWaitTask;
    private LelinkServiceInfo mInfo;
    private final SparseArray<ConnectBridge> mConnectionBridges = new SparseArray();
    private boolean isDisconnected = false;
    private int mCurrentType = 0;
    private int mReconnect;
    private final IConnectListener mLocalConnectListener = new IConnectListener(){

        @Override
        public void onConnect(LelinkServiceInfo lelinkServiceInfo, int n2) {
            SourceLog.i(GroupConnectBridge.TAG, " local LocalConnectListener onConnect ");
            GroupConnectBridge.this.mLocalConnectState.set(1);
            GroupConnectBridge.this.mConnectProtocol = 1;
            GroupConnectBridge.this.onConnectCallback(lelinkServiceInfo, n2);
        }

        @Override
        public void onDisconnect(LelinkServiceInfo lelinkServiceInfo, int n2, int n3) {
            SourceLog.i(GroupConnectBridge.TAG, " local LocalConnectListener onDisconnect ");
            if (GroupConnectBridge.this.mCloudConnectState.get() == 1 && GroupConnectBridge.this.mLocalConnectState.get() == 1) {
                GroupConnectBridge.this.mLocalConnectState.set(2);
                return;
            }
            GroupConnectBridge.this.onDisconnectCallback(lelinkServiceInfo, n2, n3);
        }
    };
    private final IConnectListener mCloudConnectListener = new IConnectListener(){

        @Override
        public void onConnect(LelinkServiceInfo lelinkServiceInfo, int n2) {
            SourceLog.i(GroupConnectBridge.TAG, "cloud CloudConnectListener onConnect ");
            GroupConnectBridge.this.mCloudConnectState.set(1);
            GroupConnectBridge.this.mConnectProtocol = 4;
            GroupConnectBridge.this.onConnectCallback(lelinkServiceInfo, n2);
        }

        @Override
        public void onDisconnect(LelinkServiceInfo lelinkServiceInfo, int n2, int n3) {
            if (n2 == 212012) {
                SourceLog.i(GroupConnectBridge.TAG, " cloud CloudConnectListener WHAT_HARASS_WAITING ");
                if (GroupConnectBridge.this.mOuterListener != null) {
                    GroupConnectBridge.this.mOuterListener.onDisconnect(lelinkServiceInfo, n2, n3);
                }
                return;
            }
            SourceLog.i(GroupConnectBridge.TAG, " cloud CloudConnectListener onDisconnect ");
            if (GroupConnectBridge.this.mCloudConnectState.get() == 1 && GroupConnectBridge.this.mLocalConnectState.get() == 1) {
                GroupConnectBridge.this.mCloudConnectState.set(2);
                return;
            }
            GroupConnectBridge.this.onDisconnectCallback(lelinkServiceInfo, n2, n3);
        }
    };
    private ReconnectTask mReconnectTask;
    private final IConnectListener wifiReconnectConnectListener = new IConnectListener(){

        @Override
        public void onConnect(LelinkServiceInfo lelinkServiceInfo, int n2) {
            if (n2 == 5) {
                GroupConnectBridge.this.mConnectProtocol = 1;
                GroupConnectBridge.this.mLocalConnectState.set(1);
            } else {
                GroupConnectBridge.this.mConnectProtocol = 4;
                GroupConnectBridge.this.mCloudConnectState.set(1);
            }
            if (GroupConnectBridge.this.mLocalConnectState.get() == 1 && GroupConnectBridge.this.mCloudConnectState.get() == 1) {
                GroupConnectBridge.this.mConnectProtocol = 6;
            }
            SourceLog.i(GroupConnectBridge.TAG, "=======wifiReconnectConnectListener onConnect =========>>> " + n2 + "  mConnectProtocol: " + GroupConnectBridge.this.mConnectProtocol);
            GroupConnectBridge.this.setLocalWifi();
        }

        @Override
        public void onDisconnect(LelinkServiceInfo lelinkServiceInfo, int n2, int n3) {
            SourceLog.i(GroupConnectBridge.TAG, "================>>onDisconnect> ");
        }
    };
    public IConnectListener reconnectListener = new IConnectListener(){

        @Override
        public void onConnect(LelinkServiceInfo lelinkServiceInfo, int n2) {
            if (n2 == 5) {
                GroupConnectBridge.this.mConnectProtocol = 1;
                GroupConnectBridge.this.mLocalConnectState.set(1);
            } else {
                GroupConnectBridge.this.mConnectProtocol = 4;
                GroupConnectBridge.this.mCloudConnectState.set(1);
                GroupConnectBridge.this.stopWaitReconnectTask();
            }
            if (GroupConnectBridge.this.mLocalConnectState.get() == 1 && GroupConnectBridge.this.mCloudConnectState.get() == 1) {
                GroupConnectBridge.this.mConnectProtocol = 6;
            }
            SourceLog.i(GroupConnectBridge.TAG, " group reconnect successful " + n2 + "  " + GroupConnectBridge.this.mConnectProtocol);
            GroupConnectBridge.this.setLocalWifi();
            if (GroupConnectBridge.this.mReconnectListener != null) {
                GroupConnectBridge.this.mReconnectListener.onConnect(lelinkServiceInfo, n2);
            }
        }

        @Override
        public void onDisconnect(LelinkServiceInfo lelinkServiceInfo, int n2, int n3) {
            SourceLog.i(GroupConnectBridge.TAG, " group reconnect failed");
            GroupConnectBridge.this.mLocalConnectState.set(2);
            if (GroupConnectBridge.this.mReconnectListener != null) {
                GroupConnectBridge.this.mReconnectListener.onDisconnect(lelinkServiceInfo, n2, n3);
            }
        }
    };

    @Override
    public void connect(LelinkServiceInfo lelinkServiceInfo) {
        SourceLog.i(TAG, "  ConnectGroupBridge connect");
        this.mReconnect = 0;
        this.mLocalConnectState.set(0);
        this.mCloudConnectState.set(0);
        this.disconnect();
        this.isDisconnected = false;
        this.mConnectBridge = null;
        this.isGroup = true;
        this.mInfo = lelinkServiceInfo;
        ConnectBridge connectBridge = new ConnectBridge(ModuleLinker.getInstance().getContext(), 1);
        connectBridge.setConnectListener(this.mLocalConnectListener);
        connectBridge.setGroupConnect(true);
        connectBridge.connect(lelinkServiceInfo);
        this.mConnectBridge = connectBridge.mConnectBridge;
        this.mConnectionBridges.put(1, (Object)connectBridge);
        if (lelinkServiceInfo.getBrowserInfos().get(1) == null) {
            this.mLocalConnectState.set(2);
        }
        ConnectBridge connectBridge2 = new ConnectBridge(ModuleLinker.getInstance().getContext(), 4);
        connectBridge2.setConnectListener(this.mCloudConnectListener);
        connectBridge2.setGroupConnect(true);
        connectBridge2.connect(lelinkServiceInfo);
        this.connectWait(2000L);
        this.mConnectionBridges.put(4, (Object)connectBridge2);
        if (lelinkServiceInfo.getBrowserInfos().get(4) == null) {
            this.mCloudConnectState.set(2);
        }
    }

    public void groupReconnect(int n2, LelinkServiceInfo lelinkServiceInfo, IConnectListener iConnectListener) {
        this.mInfo = lelinkServiceInfo;
        this.mReconnect = 0;
        try {
            this.mLocalConnectState.set(0);
            this.mReconnectListener = iConnectListener;
            for (int i2 = 0; i2 < this.mConnectionBridges.size(); ++i2) {
                ((ConnectBridge)this.mConnectionBridges.valueAt(i2)).setConnectListener(null);
            }
            SourceLog.i(TAG, "==reconnect type ==" + n2);
            ConnectBridge connectBridge = (ConnectBridge)this.mConnectionBridges.get(n2);
            this.mConnectBridge = connectBridge.mConnectBridge;
            connectBridge.setConnectListener(this.reconnectListener);
            connectBridge.connect(lelinkServiceInfo);
            if (n2 == 4) {
                this.reconnectWait(3000L);
            }
        }
        catch (Exception exception) {
            SourceLog.w(TAG, exception);
            if (iConnectListener != null) {
                iConnectListener.onDisconnect(lelinkServiceInfo, 212000, 212010);
            }
            this.disconnectedListenerCallback(lelinkServiceInfo, 212000, 212010);
        }
    }

    private void reconnectWait(long l2) {
        this.stopWaitTask();
        this.mReconnectTask = new ReconnectTask();
        this.mTimer.schedule((TimerTask)this.mReconnectTask, l2);
    }

    public void stopWaitReconnectTask() {
        SourceLog.i(TAG, " stopTask ");
        if (this.mReconnectTask != null) {
            this.mReconnectTask.cancel();
            this.mTimer.purge();
        }
    }

    public void groupReconnect() {
        SourceLog.i(TAG, "=======groupReconnect all " + this.mConnectionBridges.size());
        this.mConnectProtocol = -1;
        this.mLocalConnectState.set(2);
        this.mCloudConnectState.set(2);
        for (int i2 = 0; i2 < this.mConnectionBridges.size(); ++i2) {
            ((ConnectBridge)this.mConnectionBridges.valueAt(i2)).setConnectListener(this.wifiReconnectConnectListener);
            ((ConnectBridge)this.mConnectionBridges.valueAt(i2)).connect(this.mInfo);
        }
    }

    private void setLocalWifi() {
        try {
            BrowserInfo browserInfo = this.mInfo.getBrowserInfos().get(1);
            if (browserInfo != null) {
                browserInfo.setLocalWifi(this.mLocalConnectState.get() == 1);
            }
        }
        catch (Exception exception) {
            SourceLog.w(TAG, exception);
        }
    }

    public void switchGroupConnection(int n2) {
        try {
            this.mConnectBridge = ((ConnectBridge)this.mConnectionBridges.get((int)n2)).mConnectBridge;
            this.mConnectProtocol = n2;
        }
        catch (Exception exception) {
            SourceLog.w(TAG, exception);
        }
    }

    private void connectWait(long l2) {
        this.stopWaitTask();
        this.mWaitTask = new ConnectWaitTask();
        this.mTimer.schedule((TimerTask)this.mWaitTask, l2);
    }

    public void stopWaitTask() {
        SourceLog.i(TAG, " stopTask ");
        if (this.mWaitTask != null) {
            this.mWaitTask.cancel();
            this.mTimer.purge();
        }
    }

    @Override
    public LelinkServiceInfo getServiceInfo() {
        return this.mInfo;
    }

    @Override
    public boolean isConnected() {
        return this.mLocalConnectState.get() == 1 || this.mCloudConnectState.get() == 1;
    }

    private boolean isConnectConnected() {
        return this.mLocalConnectState.get() == 1 || this.mCloudConnectState.get() == 1;
    }

    public void setConnectCheckListener(IConnectListener iConnectListener) {
        this.mConnectCheckListener = iConnectListener;
    }

    @Override
    public void setConnectListener(IConnectListener iConnectListener) {
        this.mOuterListener = iConnectListener;
    }

    private void onConnectCallback(LelinkServiceInfo lelinkServiceInfo, int n2) {
        SourceLog.i(TAG, "---------------->> onConnectCallback local:" + this.mLocalConnectState.get() + " cloud:" + this.mCloudConnectState.get());
        if (this.mLocalConnectState.get() == 0 || this.mCloudConnectState.get() == 0) {
            return;
        }
        this.stopWaitTask();
        if (this.mLocalConnectState.get() == 1 && this.mCloudConnectState.get() == 1) {
            SourceLog.i(TAG, "all connected ...");
            this.mConnectProtocol = 6;
            this.chooseConnectBridge();
            this.connectedListenerCallback(lelinkServiceInfo, n2);
            return;
        }
        if (this.mCloudConnectState.get() == 1 || this.mLocalConnectState.get() == 1) {
            this.mConnectProtocol = n2;
            this.chooseConnectBridge();
            this.connectedListenerCallback(lelinkServiceInfo, n2);
            return;
        }
    }

    private void connectedListenerCallback(LelinkServiceInfo lelinkServiceInfo, int n2) {
        SourceLog.i(TAG, " connectedListenerCallback ");
        this.setLocalWifi();
        if (this.mConnectCheckListener != null) {
            this.mConnectCheckListener.onConnect(lelinkServiceInfo, this.mConnectProtocol);
        }
        if (this.mOuterListener != null) {
            this.mOuterListener.onConnect(lelinkServiceInfo, n2);
        }
    }

    private void disconnectedListenerCallback(LelinkServiceInfo lelinkServiceInfo, int n2, int n3) {
        SourceLog.i(TAG, "disconnectedListenerCallback ");
        if (this.mOuterListener != null) {
            this.mOuterListener.onDisconnect(lelinkServiceInfo, n2, n3);
        }
        if (this.mConnectCheckListener != null) {
            this.mConnectCheckListener.onDisconnect(lelinkServiceInfo, n2, n3);
        }
    }

    private void onDisconnectCallback(LelinkServiceInfo lelinkServiceInfo, int n2, int n3) {
        SourceLog.i(TAG, "onDisconnectCallback local:" + this.mLocalConnectState.get() + " cloud:" + this.mCloudConnectState.get() + " " + n2 + "/" + n3);
        if (this.mLocalConnectState.get() == 0 || this.mCloudConnectState.get() == 0) {
            return;
        }
        this.stopWaitTask();
        if (this.mLocalConnectState.get() == 2 && this.mCloudConnectState.get() == 2) {
            this.disconnectedListenerCallback(lelinkServiceInfo, n2, n3);
            return;
        }
        if (this.mLocalConnectState.get() == 1) {
            this.mConnectProtocol = 1;
            this.connectedListenerCallback(lelinkServiceInfo, this.mConnectProtocol);
            return;
        }
        if (this.mCloudConnectState.get() == 1) {
            this.mConnectProtocol = 4;
            this.connectedListenerCallback(lelinkServiceInfo, this.mConnectProtocol);
            return;
        }
    }

    public void disconnect() {
        try {
            this.isDisconnected = true;
            SourceLog.i(TAG, this.mConnectionBridges.size() + "  disconnect ");
            for (int i2 = 0; i2 < this.mConnectionBridges.size(); ++i2) {
                ((ConnectBridge)this.mConnectionBridges.valueAt(i2)).setConnectListener(null);
                ((ConnectBridge)this.mConnectionBridges.valueAt(i2)).disconnect(2);
            }
        }
        catch (Exception exception) {
            SourceLog.w(TAG, exception);
        }
        this.mConnectionBridges.clear();
        this.mConnectProtocol = -1;
    }

    @Override
    public void release() {
        SourceLog.i(TAG, "release " + this.mConnectionBridges.size());
        try {
            for (int i2 = 0; i2 < this.mConnectionBridges.size(); ++i2) {
                ((ConnectBridge)this.mConnectionBridges.valueAt(i2)).release();
            }
        }
        catch (Exception exception) {
            SourceLog.w(TAG, exception);
        }
        this.mConnectionBridges.clear();
        this.mConnectProtocol = -1;
        this.mConnectCheckListener = null;
        this.mOuterListener = null;
    }

    private void chooseConnectBridge() {
        this.mConnectBridge = this.mConnectProtocol == 4 ? ((ConnectBridge)this.mConnectionBridges.get((int)4)).mConnectBridge : ((ConnectBridge)this.mConnectionBridges.get((int)1)).mConnectBridge;
    }

    class ConnectWaitTask
    extends TimerTask {
        ConnectWaitTask() {
        }

        @Override
        public void run() {
            SourceLog.i(GroupConnectBridge.TAG, "ConnectWaitTask time out");
            if (GroupConnectBridge.this.isDisconnected) {
                return;
            }
            if (GroupConnectBridge.this.isConnectConnected()) {
                try {
                    GroupConnectBridge.this.chooseConnectBridge();
                }
                catch (Exception exception) {
                    SourceLog.w(GroupConnectBridge.TAG, exception);
                    return;
                }
                GroupConnectBridge.this.connectedListenerCallback(GroupConnectBridge.this.mInfo, GroupConnectBridge.this.mConnectProtocol);
            } else {
                if (GroupConnectBridge.this.mReconnect < 1) {
                    try {
                        CloudConnectBridge cloudConnectBridge = (CloudConnectBridge)((ConnectBridge)((GroupConnectBridge)GroupConnectBridge.this).mConnectionBridges.get((int)4)).mConnectBridge;
                        cloudConnectBridge.reconnectServer();
                    }
                    catch (Exception exception) {
                        SourceLog.w(GroupConnectBridge.TAG, exception);
                        GroupConnectBridge.this.disconnectedListenerCallback(GroupConnectBridge.this.mInfo, 212010, 212011);
                    }
                } else {
                    GroupConnectBridge.this.disconnectedListenerCallback(GroupConnectBridge.this.mInfo, 212010, 212011);
                }
                GroupConnectBridge.this.mReconnect++;
            }
        }
    }

    class ReconnectTask
    extends TimerTask {
        ReconnectTask() {
        }

        @Override
        public void run() {
            try {
                SourceLog.w(GroupConnectBridge.TAG, "ReconnectTask  restart server ");
                ((CloudConnectBridge)((ConnectBridge)((GroupConnectBridge)GroupConnectBridge.this).mConnectionBridges.get((int)4)).mConnectBridge).reconnectServer();
            }
            catch (Exception exception) {
                SourceLog.w(GroupConnectBridge.TAG, exception);
            }
        }
    }
}

