/*
 * Decompiled with CFR 0.152.
 */
package com.tony.bluetoothunityapi;

import com.tony.bluetoothunityapi.BluetoothHelper;
import com.tony.bluetoothunityapi.BluetoothStreamManager;
import com.tony.bluetoothunityapi.CharArrayWrapper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class BluetoothFixedLengthStreamManager
extends BluetoothStreamManager {
    private final List<Byte> messageBuffer;
    private final int length;

    public BluetoothFixedLengthStreamManager(BluetoothHelper helper, int length) {
        super(helper);
        this.length = length;
        this.messageBuffer = new ArrayList<Byte>();
    }

    @Override
    public void Listen() {
        this.transceiver.listen();
    }

    @Override
    public void OnMessageReceived(byte[] buff) {
        this.messageBuffer.addAll(Arrays.asList(BluetoothFixedLengthStreamManager.toObject(buff)));
        while (this.messageBuffer.size() >= this.length) {
            if (this.messageBuffer.size() == this.length) {
                this.helper.invokeDataReceivedEvent(new CharArrayWrapper(this.messageBuffer.toArray()));
                this.messageBuffer.clear();
                continue;
            }
            byte[] message = new byte[this.length];
            for (int i = 0; i < this.length; ++i) {
                message[i] = this.messageBuffer.get(0);
                this.messageBuffer.remove(0);
            }
            this.helper.invokeDataReceivedEvent(new CharArrayWrapper(message));
        }
    }

    @Override
    public void sendData() {
        this.transceiver.write(this.data_out);
    }
}

