/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.glide.load.engine.cache;

import android.annotation.TargetApi;
import android.app.ActivityManager;
import android.content.Context;
import android.os.Build;
import android.text.format.Formatter;
import android.util.DisplayMetrics;
import android.util.Log;

public class MemorySizeCalculator {
    private static final String TAG = "MemorySizeCalculator";
    static final int BYTES_PER_ARGB_8888_PIXEL = 4;
    static final int MEMORY_CACHE_TARGET_SCREENS = 2;
    static final int BITMAP_POOL_TARGET_SCREENS = 4;
    static final float MAX_SIZE_MULTIPLIER = 0.4f;
    static final float LOW_MEMORY_MAX_SIZE_MULTIPLIER = 0.33f;
    private final int bitmapPoolSize;
    private final int memoryCacheSize;
    private final Context context;

    public MemorySizeCalculator(Context context) {
        this(context, (ActivityManager)context.getSystemService("activity"), new DisplayMetricsScreenDimensions(context.getResources().getDisplayMetrics()));
    }

    MemorySizeCalculator(Context context, ActivityManager activityManager, ScreenDimensions screenDimensions) {
        this.context = context;
        int n2 = MemorySizeCalculator.getMaxSize(activityManager);
        int n3 = screenDimensions.getWidthPixels() * screenDimensions.getHeightPixels() * 4;
        int n4 = n3 * 4;
        int n5 = n3 * 2;
        if (n5 + n4 <= n2) {
            this.memoryCacheSize = n5;
            this.bitmapPoolSize = n4;
        } else {
            int n6 = Math.round((float)n2 / 6.0f);
            this.memoryCacheSize = n6 * 2;
            this.bitmapPoolSize = n6 * 4;
        }
        if (Log.isLoggable((String)TAG, (int)3)) {
            Log.d((String)TAG, (String)("Calculated memory cache size: " + this.toMb(this.memoryCacheSize) + " pool size: " + this.toMb(this.bitmapPoolSize) + " memory class limited? " + (n5 + n4 > n2) + " max size: " + this.toMb(n2) + " memoryClass: " + activityManager.getMemoryClass() + " isLowMemoryDevice: " + MemorySizeCalculator.isLowMemoryDevice(activityManager)));
        }
    }

    public int getMemoryCacheSize() {
        return this.memoryCacheSize;
    }

    public int getBitmapPoolSize() {
        return this.bitmapPoolSize;
    }

    private static int getMaxSize(ActivityManager activityManager) {
        int n2 = activityManager.getMemoryClass() * 1024 * 1024;
        boolean bl = MemorySizeCalculator.isLowMemoryDevice(activityManager);
        return Math.round((float)n2 * (bl ? 0.33f : 0.4f));
    }

    private String toMb(int n2) {
        return Formatter.formatFileSize((Context)this.context, (long)n2);
    }

    @TargetApi(value=19)
    private static boolean isLowMemoryDevice(ActivityManager activityManager) {
        if (Build.VERSION.SDK_INT >= 19) {
            return activityManager.isLowRamDevice();
        }
        return Build.VERSION.SDK_INT < 11;
    }

    private static class DisplayMetricsScreenDimensions
    implements ScreenDimensions {
        private final DisplayMetrics displayMetrics;

        public DisplayMetricsScreenDimensions(DisplayMetrics displayMetrics) {
            this.displayMetrics = displayMetrics;
        }

        @Override
        public int getWidthPixels() {
            return this.displayMetrics.widthPixels;
        }

        @Override
        public int getHeightPixels() {
            return this.displayMetrics.heightPixels;
        }
    }

    static interface ScreenDimensions {
        public int getWidthPixels();

        public int getHeightPixels();
    }
}

