/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.sdk.source.mdns;

import android.annotation.SuppressLint;
import android.util.Log;
import com.hpplay.sdk.source.mdns.MulticastDNSMulticastOnlyQuerier;
import com.hpplay.sdk.source.mdns.xbill.dns.Header;
import com.hpplay.sdk.source.mdns.xbill.dns.Message;
import com.hpplay.sdk.source.mdns.xbill.dns.Opcode;
import com.hpplay.sdk.source.mdns.xbill.dns.ResolverListener;
import java.lang.ref.WeakReference;

public class MulticastDNSResponder
implements ResolverListener {
    private static final String TAG = "MulticastDNSResponder";
    private boolean mdnsVerbose;
    private WeakReference<MulticastDNSMulticastOnlyQuerier> mMulticastOnlyQuerierWeakReference;

    public MulticastDNSResponder(boolean bl, MulticastDNSMulticastOnlyQuerier multicastDNSMulticastOnlyQuerier) {
        this.mdnsVerbose = bl;
        this.mMulticastOnlyQuerierWeakReference = new WeakReference<MulticastDNSMulticastOnlyQuerier>(multicastDNSMulticastOnlyQuerier);
    }

    @Override
    public void handleException(Object object, Exception exception) {
    }

    @Override
    @SuppressLint(value={"LongLogTag"})
    public void receiveMessage(Object object, Message message) {
        MulticastDNSMulticastOnlyQuerier multicastDNSMulticastOnlyQuerier = (MulticastDNSMulticastOnlyQuerier)this.mMulticastOnlyQuerierWeakReference.get();
        if (multicastDNSMulticastOnlyQuerier == null) {
            return;
        }
        int n2 = message.getRcode();
        Header header = message.getHeader();
        int n3 = header.getOpcode();
        if (header.getFlag(0) || header.getFlag(5)) {
            return;
        }
        if (this.mdnsVerbose) {
            Log.i((String)TAG, (String)("receiveMessage Opcode: " + Opcode.string(n3)));
        }
        try {
            switch (n3) {
                case 0: 
                case 1: {
                    if (multicastDNSMulticastOnlyQuerier.cache == null) {
                        return;
                    }
                    Message message2 = multicastDNSMulticastOnlyQuerier.cache.queryCache(message, 4);
                    if (message2 == null) break;
                    Header header2 = message2.getHeader();
                    if (header2.getCount(1) > 0 || header2.getCount(2) > 0 || header2.getCount(3) > 0) {
                        if (this.mdnsVerbose) {
                            Log.i((String)TAG, (String)("receiveMessage Query Reply ID: " + object + "\n" + message2));
                        }
                        header2.setFlag(5);
                        header2.setFlag(0);
                        multicastDNSMulticastOnlyQuerier.writeResponse(message2);
                        break;
                    }
                    if (this.mdnsVerbose) {
                        Log.i((String)TAG, (String)"receiveMessage No response, client knows answer.");
                    }
                    break;
                }
                case 2: 
                case 4: 
                case 5: {
                    Log.i((String)TAG, (String)("receiveMessage Received Invalid Request - Opcode: " + Opcode.string(n3)));
                }
            }
        }
        catch (Exception exception) {
            Log.i((String)TAG, (String)("Error replying to query - " + exception.getMessage()), (Throwable)exception);
        }
    }
}

