/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.component.adjuster;

import android.text.TextUtils;
import com.hpplay.component.common.ParamsMap;
import com.hpplay.component.common.browse.IBrowseResultListener;
import com.hpplay.component.common.browse.IBrowser;
import com.hpplay.component.common.protocol.ProtocolListener;
import com.hpplay.component.common.utils.CLog;
import com.hpplay.component.modulelinker.api.ModuleLinker;
import java.util.Iterator;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.atomic.AtomicBoolean;
import org.json.JSONObject;

public class DeviceAdjuster {
    public static final String TAG = "DeviceAdjuster";
    public static final int AUTO_STOP_TIME_OUT = 10000;
    public static final int ACTIVE_STOP_TIME_OUT = 1000;
    public static final String KEY_DEVICE_IP = "deviceip";
    public static final String KEY_LELINK_PORT = "lelinkport";
    public static final String KEY_RAOP_PORT = "raop";
    public static final String KEY_AIRPLAY_PORT = "airplay";
    public static final String KEY_MIRROR_PORT = "mirror";
    public static final String KEY_CHANNEL = "channel";
    public static final String KEY_MAC = "devicemac";
    public static final String KEY_LEBO_FEATURE = "lebofeature";
    public static final String KEY_REMOTE_PORT = "remote";
    public static final String KEY_VERSION = "version";
    public static final String KEY_DEVICE_NAME = "devicename";
    public static final String KEY_LELINK_VV = "vv";
    public static final String KEY_DLNA_DESC = "dlna_mode_desc";
    public static final String KEY_LELINK_UID = " u";
    private IBrowseResultListener mBrowseResultListener;
    private ConcurrentHashMap<String, CopyOnWriteArraySet> mInfos = new ConcurrentHashMap();
    private CopyOnWriteArraySet<String> mValidInfos = new CopyOnWriteArraySet();
    private ParamsMap mParamsMap;
    private ProtocolListener mRequestNewDeviceProtocolListener;
    private AtomicBoolean isRequestDev = new AtomicBoolean();
    private Timer mTimer = new Timer();
    private StopBrowseTask mStopBrowseTask;
    private boolean isFindDevice;
    private int mCurrentType;
    private IBrowseResultListener browseResultListener = new IBrowseResultListener(){

        @Override
        public void onBrowseResultCallback(int n2, Object object) {
            if (DeviceAdjuster.this.isRequestDev.get()) {
                DeviceAdjuster.this.filterDevices(n2, object);
            }
            if (DeviceAdjuster.this.mBrowseResultListener != null) {
                DeviceAdjuster.this.mBrowseResultListener.onBrowseResultCallback(n2, object);
            }
        }
    };

    public void setBrowseInfosPoolListener(IBrowseResultListener iBrowseResultListener) {
        this.claerTemp();
        this.mBrowseResultListener = iBrowseResultListener;
    }

    public IBrowseResultListener getBrowseResultListener() {
        return this.browseResultListener;
    }

    private void filterDevices(int n2, Object object) {
        try {
            if (this.mInfos != null && this.mParamsMap != null) {
                JSONObject jSONObject = new JSONObject(object.toString());
                String string = jSONObject.optString(KEY_DEVICE_IP);
                String string2 = jSONObject.optString(KEY_DEVICE_NAME);
                String string3 = jSONObject.optString(KEY_LELINK_UID);
                if (TextUtils.equals((CharSequence)string3, (CharSequence)this.mParamsMap.getStringParam("uid")) || TextUtils.equals((CharSequence)string, (CharSequence)this.mParamsMap.getIp()) || TextUtils.equals((CharSequence)this.mParamsMap.getStringParam("sink_name"), (CharSequence)string2)) {
                    CLog.i(TAG, " find new devices " + string2 + "  type " + n2);
                    this.mValidInfos.add(object.toString());
                    this.mInfos.put(String.valueOf(n2), this.mValidInfos);
                } else {
                    CLog.i(TAG, " no find new devices name " + string2 + " new dev  " + string.replace(".", "") + " request " + this.mParamsMap.getIp());
                }
                if (this.mCurrentType == this.convertType(n2) && (object.toString().contains(this.mParamsMap.getStringParam("uid")) || object.toString().contains(this.mParamsMap.getStringParam("sink_name"))) && !this.isFindDevice) {
                    CLog.i(TAG, "mCurrentType " + this.mCurrentType + "  type " + n2 + "   convert " + this.convertType(n2));
                    this.isFindDevice = true;
                    this.delayStopBrowse(1000L);
                }
            }
        }
        catch (Exception exception) {
            CLog.w(TAG, exception);
            this.delayStopBrowse(0L);
        }
    }

    private int convertType(int n2) {
        if (n2 == 2) {
            return 1;
        }
        if (n2 == 1) {
            return 2;
        }
        return n2;
    }

    private void rebrowse(int n2) {
        try {
            this.claerTemp();
            this.delayStopBrowse(10000L);
            this.isRequestDev.set(true);
            IBrowser iBrowser = (IBrowser)ModuleLinker.getInstance().loadModule("50864AD7EE4B3A3BC9253C4CE7EBB55C");
            iBrowser.stopBrowse();
            iBrowser.startBrowse(n2);
            CLog.i(TAG, "rebrowse ...browse type :" + n2);
        }
        catch (Exception exception) {
            CLog.w(TAG, exception);
        }
    }

    private void delayStopBrowse(long l2) {
        CLog.i(TAG, "delayStopBrowse ... " + l2);
        if (this.mStopBrowseTask != null) {
            this.mStopBrowseTask.cancel();
            this.mTimer.purge();
        }
        this.mStopBrowseTask = new StopBrowseTask();
        this.mTimer.schedule((TimerTask)this.mStopBrowseTask, l2);
    }

    private void matchDevice() {
        CLog.i(TAG, " start match device " + this.mInfos.size());
        if (this.mInfos.size() > 0) {
            String string;
            Iterator iterator;
            CopyOnWriteArraySet copyOnWriteArraySet = this.mInfos.get(String.valueOf(2));
            CopyOnWriteArraySet copyOnWriteArraySet2 = this.mInfos.get(String.valueOf(1));
            String string2 = null;
            String string3 = null;
            if (copyOnWriteArraySet != null) {
                iterator = copyOnWriteArraySet.iterator();
                while (iterator.hasNext()) {
                    string2 = string = (String)iterator.next();
                    if (!string.contains(this.mParamsMap.getStringParam("uid")) && !string.contains(this.mParamsMap.getStringParam("sink_name"))) continue;
                    if (this.mRequestNewDeviceProtocolListener != null) {
                        this.mRequestNewDeviceProtocolListener.onResult(20, this.deviceConvert(1, string2));
                    }
                    return;
                }
            }
            if (copyOnWriteArraySet2 != null) {
                iterator = copyOnWriteArraySet2.iterator();
                while (iterator.hasNext()) {
                    string3 = string = (String)iterator.next();
                    if (!string.contains(this.mParamsMap.getStringParam("sink_name"))) continue;
                    if (this.mRequestNewDeviceProtocolListener != null) {
                        this.mRequestNewDeviceProtocolListener.onResult(20, this.deviceConvert(3, string));
                    }
                    return;
                }
                if (!TextUtils.isEmpty(string2)) {
                    if (this.mRequestNewDeviceProtocolListener != null) {
                        this.mRequestNewDeviceProtocolListener.onResult(20, this.deviceConvert(1, this.deviceConvert(1, string2)));
                    }
                } else if (this.mRequestNewDeviceProtocolListener != null) {
                    this.mRequestNewDeviceProtocolListener.onResult(20, this.deviceConvert(3, string3));
                }
            }
        } else if (this.mRequestNewDeviceProtocolListener != null) {
            String[] stringArray = null;
            this.mRequestNewDeviceProtocolListener.onResult(20, stringArray);
        }
    }

    private String deviceConvert(int n2, String string) {
        try {
            JSONObject jSONObject = new JSONObject(string);
            int[] nArray = new int[]{n2};
            this.mParamsMap.putParam("connect_support", nArray).putParam("ip", jSONObject.optString(KEY_DEVICE_IP)).putParam("port", jSONObject.optString(KEY_LELINK_PORT)).putParam("lelink_port", jSONObject.optString(KEY_LELINK_PORT)).putParam("raop_port", jSONObject.optString(KEY_RAOP_PORT)).putParam("sink_name", jSONObject.optString(KEY_DEVICE_NAME)).putParam(KEY_LELINK_VV, jSONObject.optString(KEY_LELINK_VV)).putParam("mirror_port", jSONObject.optString(KEY_MIRROR_PORT)).putParam("airplay_port", jSONObject.optString(KEY_AIRPLAY_PORT)).putParam("channel_version", jSONObject.optString(KEY_CHANNEL)).putParam(KEY_REMOTE_PORT, jSONObject.optString(KEY_REMOTE_PORT)).putParam("mac", jSONObject.optString(KEY_MAC)).putParam("location_uri", jSONObject.optString(KEY_DLNA_DESC));
            String string2 = this.mParamsMap.toJason();
            CLog.i(TAG, "covert device info " + string2);
            return string2;
        }
        catch (Exception exception) {
            CLog.w(TAG, exception);
            return null;
        }
    }

    public void requestNewDevices(int n2, ParamsMap paramsMap, ProtocolListener protocolListener) {
        try {
            this.mCurrentType = n2;
            String string = paramsMap.getStringParam("sink_name");
            String string2 = paramsMap.getIp();
            this.isFindDevice = false;
            this.claerTemp();
            this.mParamsMap = paramsMap;
            this.mRequestNewDeviceProtocolListener = protocolListener;
            this.rebrowse(n2);
            CLog.i(TAG, "requestNewDevices ... requestName: " + string + " request  " + string2.replace(".", ""));
        }
        catch (Exception exception) {
            CLog.w(TAG, exception);
            String[] stringArray = null;
            protocolListener.onResult(20, stringArray);
        }
    }

    public void stopRequestDevice() {
        this.mRequestNewDeviceProtocolListener = null;
        if (this.mStopBrowseTask != null) {
            this.mStopBrowseTask.cancel();
            this.mTimer.purge();
        }
    }

    public void requestNewDevices(ParamsMap paramsMap, ProtocolListener protocolListener) {
        this.requestNewDevices(3, paramsMap, protocolListener);
    }

    private void claerTemp() {
        if (this.mInfos != null) {
            this.mInfos.clear();
        }
        if (this.mValidInfos != null) {
            this.mValidInfos.clear();
        }
    }

    class StopBrowseTask
    extends TimerTask {
        StopBrowseTask() {
        }

        @Override
        public void run() {
            try {
                DeviceAdjuster.this.isRequestDev.set(false);
                IBrowser iBrowser = (IBrowser)ModuleLinker.getInstance().loadModule("50864AD7EE4B3A3BC9253C4CE7EBB55C");
                iBrowser.stopBrowse();
                CLog.i(DeviceAdjuster.TAG, " StopBrowseTask ");
                DeviceAdjuster.this.matchDevice();
            }
            catch (Exception exception) {
                CLog.w(DeviceAdjuster.TAG, exception);
            }
        }
    }
}

