/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.component.protocol.plist;

import com.hpplay.component.protocol.plist.BinaryPropertyListWriter;
import com.hpplay.component.protocol.plist.NSObject;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.util.Locale;
import java.util.Scanner;

public class NSString
extends NSObject
implements Comparable<Object> {
    private String content;
    private static CharsetEncoder asciiEncoder;
    private static CharsetEncoder utf16beEncoder;
    private static CharsetEncoder utf8Encoder;

    public NSString(byte[] byArray, String string) {
        this(byArray, 0, byArray.length, string);
    }

    public NSString(byte[] byArray, int n2, int n3, String string) {
        this.content = new String(byArray, n2, n3 - n2, string);
    }

    public NSString(String string) {
        this.content = string;
    }

    public int intValue() {
        double d2 = this.doubleValue();
        if (d2 > 2.147483647E9) {
            return Integer.MAX_VALUE;
        }
        if (d2 < -2.147483648E9) {
            return Integer.MIN_VALUE;
        }
        return (int)d2;
    }

    public float floatValue() {
        double d2 = this.doubleValue();
        if (d2 > 3.4028234663852886E38) {
            return Float.MAX_VALUE;
        }
        if (d2 < -3.4028234663852886E38) {
            return -3.4028235E38f;
        }
        return (float)d2;
    }

    public double doubleValue() {
        Scanner scanner = new Scanner(this.content.trim()).useLocale(Locale.ROOT).useDelimiter("[^0-9.+-]+");
        if (scanner.hasNextDouble()) {
            return scanner.nextDouble();
        }
        return 0.0;
    }

    public boolean boolValue() {
        Scanner scanner = new Scanner(this.content.trim()).useLocale(Locale.ROOT);
        return scanner.hasNext("([+-]?[0]*)?[YyTt1-9].*");
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String string) {
        this.content = string;
    }

    public void append(NSString nSString) {
        this.append(nSString.getContent());
    }

    public void append(String string) {
        this.content = this.content + string;
    }

    public void prepend(String string) {
        this.content = string + this.content;
    }

    public void prepend(NSString nSString) {
        this.prepend(nSString.getContent());
    }

    public boolean equals(Object object) {
        return object != null && this.getClass() == object.getClass() && this.content.equals(((NSString)object).content);
    }

    public int hashCode() {
        return this.content.hashCode();
    }

    public String toString() {
        return this.content;
    }

    @Override
    public NSString clone() {
        return new NSString(this.content);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void toXML(StringBuilder stringBuilder, int n2) {
        this.indent(stringBuilder, n2);
        stringBuilder.append("<string>");
        Class<NSString> clazz = NSString.class;
        synchronized (NSString.class) {
            if (utf8Encoder == null) {
                utf8Encoder = Charset.forName("UTF-8").newEncoder();
            } else {
                utf8Encoder.reset();
            }
            try {
                ByteBuffer byteBuffer = utf8Encoder.encode(CharBuffer.wrap(this.content));
                byte[] byArray = new byte[byteBuffer.remaining()];
                byteBuffer.get(byArray);
                this.content = new String(byArray, "UTF-8");
            }
            catch (Exception exception) {
                throw new RuntimeException("Could not encode the NSString into UTF-8: " + String.valueOf(exception.getMessage()));
            }
            if (this.content.contains("&") || this.content.contains("<") || this.content.contains(">")) {
                stringBuilder.append("<![CDATA[");
                stringBuilder.append(this.content.replaceAll("]]>", "]]]]><![CDATA[>"));
                stringBuilder.append("]]>");
            } else {
                stringBuilder.append(this.content);
            }
            stringBuilder.append("</string>");
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void toBinary(BinaryPropertyListWriter binaryPropertyListWriter) {
        CharBuffer charBuffer = CharBuffer.wrap(this.content);
        Object object = NSString.class;
        synchronized (NSString.class) {
            ByteBuffer byteBuffer;
            int n2;
            if (asciiEncoder == null) {
                asciiEncoder = Charset.forName("ASCII").newEncoder();
            } else {
                asciiEncoder.reset();
            }
            if (asciiEncoder.canEncode((CharSequence)charBuffer)) {
                n2 = 5;
                byteBuffer = asciiEncoder.encode(charBuffer);
            } else {
                if (utf16beEncoder == null) {
                    utf16beEncoder = Charset.forName("UTF-16BE").newEncoder();
                } else {
                    utf16beEncoder.reset();
                }
                n2 = 6;
                byteBuffer = utf16beEncoder.encode(charBuffer);
            }
            // ** MonitorExit[var5_3] (shouldn't be in output)
            object = new byte[byteBuffer.remaining()];
            byteBuffer.get((byte[])object);
            binaryPropertyListWriter.writeIntHeader(n2, this.content.length());
            binaryPropertyListWriter.write((byte[])object);
            return;
        }
    }

    @Override
    protected void toASCII(StringBuilder stringBuilder, int n2) {
        this.indent(stringBuilder, n2);
        stringBuilder.append("\"");
        stringBuilder.append(NSString.escapeStringForASCII(this.content));
        stringBuilder.append("\"");
    }

    @Override
    protected void toASCIIGnuStep(StringBuilder stringBuilder, int n2) {
        this.indent(stringBuilder, n2);
        stringBuilder.append("\"");
        stringBuilder.append(NSString.escapeStringForASCII(this.content));
        stringBuilder.append("\"");
    }

    @Override
    public int compareTo(Object object) {
        if (object instanceof NSString) {
            return this.getContent().compareTo(((NSString)object).getContent());
        }
        if (object instanceof String) {
            return this.getContent().compareTo((String)object);
        }
        return -1;
    }

    static String escapeStringForASCII(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        for (char c2 : string.toCharArray()) {
            if (c2 > '\u007f') {
                stringBuilder.append("\\U");
                String string2 = Integer.toHexString(c2);
                while (string2.length() < 4) {
                    string2 = "0" + string2;
                }
                stringBuilder.append(string2);
                continue;
            }
            if (c2 == '\\') {
                stringBuilder.append("\\\\");
                continue;
            }
            if (c2 == '\"') {
                stringBuilder.append("\\\"");
                continue;
            }
            if (c2 == '\b') {
                stringBuilder.append("\\b");
                continue;
            }
            if (c2 == '\n') {
                stringBuilder.append("\\n");
                continue;
            }
            if (c2 == '\r') {
                stringBuilder.append("\\r");
                continue;
            }
            if (c2 == '\t') {
                stringBuilder.append("\\t");
                continue;
            }
            stringBuilder.append(c2);
        }
        return stringBuilder.toString();
    }
}

