/*
 * Decompiled with CFR 0.152.
 */
package com.yasirkula.unity;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.Fragment;
import android.app.RemoteAction;
import android.content.ContentUris;
import android.content.ContentValues;
import android.content.Context;
import android.content.Intent;
import android.database.Cursor;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Environment;
import android.provider.MediaStore;
import android.util.Log;
import android.webkit.MimeTypeMap;
import com.yasirkula.unity.NativeGalleryMediaPickerFragment;
import com.yasirkula.unity.NativeGalleryMediaReceiver;
import com.yasirkula.unity.NativeGalleryPermissionFragment;
import com.yasirkula.unity.NativeGalleryPermissionReceiver;
import com.yasirkula.unity.NativeGalleryUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

public class NativeGallery {
    public static final int MEDIA_TYPE_IMAGE = 1;
    public static final int MEDIA_TYPE_VIDEO = 2;
    public static final int MEDIA_TYPE_AUDIO = 4;
    public static boolean overwriteExistingMedia = false;
    public static boolean mediaSaveOmitDCIM = false;
    public static boolean PermissionFreeMode = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String SaveMedia(Context context, int mediaType, String filePath, String directoryName) {
        block50: {
            File originalFile = new File(filePath);
            if (!originalFile.exists()) {
                Log.e((String)"Unity", (String)"Original media file is missing or inaccessible!");
                return "";
            }
            int pathSeparator = filePath.lastIndexOf(47);
            int extensionSeparator = filePath.lastIndexOf(46);
            String filename = pathSeparator >= 0 ? filePath.substring(pathSeparator + 1) : filePath;
            String extension = extensionSeparator >= 0 ? filePath.substring(extensionSeparator + 1) : "";
            String mimeType = extension.length() > 0 ? MimeTypeMap.getSingleton().getMimeTypeFromExtension(extension.toLowerCase(Locale.ENGLISH)) : null;
            ContentValues values = new ContentValues();
            values.put("title", filename);
            values.put("_display_name", filename);
            values.put("date_added", Long.valueOf(System.currentTimeMillis() / 1000L));
            if (mimeType != null && mimeType.length() > 0) {
                values.put("mime_type", mimeType);
            }
            if (mediaType == 1) {
                int imageOrientation = NativeGalleryUtils.GetImageOrientation(context, filePath);
                switch (imageOrientation) {
                    case 7: 
                    case 8: {
                        values.put("orientation", Integer.valueOf(270));
                        break;
                    }
                    case 3: {
                        values.put("orientation", Integer.valueOf(180));
                        break;
                    }
                    case 5: 
                    case 6: {
                        values.put("orientation", Integer.valueOf(90));
                    }
                }
            }
            Uri externalContentUri = mediaType == 1 ? MediaStore.Images.Media.EXTERNAL_CONTENT_URI : (mediaType == 2 ? MediaStore.Video.Media.EXTERNAL_CONTENT_URI : MediaStore.Audio.Media.EXTERNAL_CONTENT_URI);
            if (Build.VERSION.SDK_INT >= 29) {
                values.put("relative_path", mediaSaveOmitDCIM ? directoryName + "/" : (mediaType != 4 ? "DCIM/" : "Music/") + directoryName + "/");
                values.put("datetaken", Long.valueOf(System.currentTimeMillis()));
                for (int i = 0; i < 2; ++i) {
                    block49: {
                        values.put("is_pending", Boolean.valueOf(true));
                        if (i == 1) {
                            String filenameWithoutExtension = extension.length() > 0 && filename.length() > extension.length() ? filename.substring(0, filename.length() - extension.length() - 1) : filename;
                            String newFilename = filenameWithoutExtension + " " + new SimpleDateFormat("yyyy-MM-dd'T'HH.mm.ss").format(new Date());
                            if (extension.length() > 0) {
                                newFilename = newFilename + "." + extension;
                            }
                            values.put("title", newFilename);
                            values.put("_display_name", newFilename);
                        }
                        Uri uri = null;
                        if (!overwriteExistingMedia) {
                            uri = context.getContentResolver().insert(externalContentUri, values);
                        } else {
                            try (Cursor cursor = null;){
                                String selection = "relative_path=? AND _display_name=?";
                                String[] selectionArgs = new String[]{values.getAsString("relative_path"), values.getAsString("_display_name")};
                                cursor = context.getContentResolver().query(externalContentUri, new String[]{"_id"}, selection, selectionArgs, null);
                                if (cursor != null && cursor.moveToFirst()) {
                                    uri = ContentUris.withAppendedId((Uri)externalContentUri, (long)cursor.getLong(cursor.getColumnIndex("_id")));
                                    Log.d((String)"Unity", (String)"Overwriting existing media");
                                }
                            }
                            if (uri == null) {
                                uri = context.getContentResolver().insert(externalContentUri, values);
                            }
                        }
                        if (uri != null) {
                            try {
                                if (!NativeGalleryUtils.WriteFileToStream(originalFile, context.getContentResolver().openOutputStream(uri, "rwt"))) break block49;
                                values.put("is_pending", Boolean.valueOf(false));
                                context.getContentResolver().update(uri, values, null, null);
                                Log.d((String)"Unity", (String)("Saved media to: " + uri.toString()));
                                try {
                                    Intent mediaScanIntent = new Intent("android.intent.action.MEDIA_SCANNER_SCAN_FILE");
                                    mediaScanIntent.setData(uri);
                                    context.sendBroadcast(mediaScanIntent);
                                }
                                catch (Exception e) {
                                    Log.e((String)"Unity", (String)"Exception:", (Throwable)e);
                                }
                                String path = NativeGalleryUtils.GetPathFromURI(context, uri);
                                return path != null && path.length() > 0 ? path : uri.toString();
                            }
                            catch (IllegalStateException e) {
                                if (i == 1) {
                                    Log.e((String)"Unity", (String)"Exception:", (Throwable)e);
                                }
                                context.getContentResolver().delete(uri, null, null);
                            }
                            catch (Exception e) {
                                Log.e((String)"Unity", (String)"Exception:", (Throwable)e);
                                if (overwriteExistingMedia && e.getClass().getName().equals("android.app.RecoverableSecurityException")) {
                                    try {
                                        RemoteAction remoteAction = (RemoteAction)e.getClass().getMethod("getUserAction", new Class[0]).invoke((Object)e, new Object[0]);
                                        context.startIntentSender(remoteAction.getActionIntent().getIntentSender(), null, 0, 0, 0);
                                    }
                                    catch (Exception e2) {
                                        Log.e((String)"Unity", (String)"RecoverableSecurityException failure:", (Throwable)e2);
                                        return "";
                                    }
                                    String path = NativeGalleryUtils.GetPathFromURI(context, uri);
                                    return path != null && path.length() > 0 ? path : uri.toString();
                                }
                                context.getContentResolver().delete(uri, null, null);
                                return "";
                            }
                        }
                    }
                    if (!overwriteExistingMedia) {
                        continue;
                    }
                    break;
                }
            } else {
                File file;
                File directory = new File(mediaSaveOmitDCIM ? Environment.getExternalStorageDirectory() : Environment.getExternalStoragePublicDirectory((String)Environment.DIRECTORY_DCIM), directoryName);
                directory.mkdirs();
                int fileIndex = 1;
                String filenameWithoutExtension = extension.length() > 0 && filename.length() > extension.length() ? filename.substring(0, filename.length() - extension.length() - 1) : filename;
                String newFilename = filename;
                do {
                    file = new File(directory, newFilename);
                    newFilename = filenameWithoutExtension + fileIndex++;
                    if (extension.length() <= 0) continue;
                    newFilename = newFilename + "." + extension;
                } while (!overwriteExistingMedia && file.exists());
                try {
                    if (!NativeGalleryUtils.WriteFileToStream(originalFile, new FileOutputStream(file))) break block50;
                    values.put("_data", file.getAbsolutePath());
                    if (!overwriteExistingMedia) {
                        context.getContentResolver().insert(externalContentUri, values);
                    } else {
                        Uri existingMediaUri = null;
                        try (Cursor cursor = null;){
                            cursor = context.getContentResolver().query(externalContentUri, new String[]{"_id"}, "_data=?", new String[]{values.getAsString("_data")}, null);
                            if (cursor != null && cursor.moveToFirst()) {
                                existingMediaUri = ContentUris.withAppendedId((Uri)externalContentUri, (long)cursor.getLong(cursor.getColumnIndex("_id")));
                                Log.d((String)"Unity", (String)"Overwriting existing media");
                            }
                        }
                        if (existingMediaUri == null) {
                            context.getContentResolver().insert(externalContentUri, values);
                        } else {
                            context.getContentResolver().update(existingMediaUri, values, null, null);
                        }
                    }
                    Log.d((String)"Unity", (String)("Saved media to: " + file.getPath()));
                    Intent mediaScanIntent = new Intent("android.intent.action.MEDIA_SCANNER_SCAN_FILE");
                    mediaScanIntent.setData(Uri.fromFile((File)file));
                    context.sendBroadcast(mediaScanIntent);
                    return file.getAbsolutePath();
                }
                catch (Exception e) {
                    Log.e((String)"Unity", (String)"Exception:", (Throwable)e);
                }
            }
        }
        return "";
    }

    public static void MediaDeleteFile(Context context, String path, int mediaType) {
        if (mediaType == 1) {
            context.getContentResolver().delete(MediaStore.Images.Media.EXTERNAL_CONTENT_URI, "_data=?", new String[]{path});
        } else if (mediaType == 2) {
            context.getContentResolver().delete(MediaStore.Video.Media.EXTERNAL_CONTENT_URI, "_data=?", new String[]{path});
        } else {
            context.getContentResolver().delete(MediaStore.Audio.Media.EXTERNAL_CONTENT_URI, "_data=?", new String[]{path});
        }
    }

    public static void PickMedia(Context context, NativeGalleryMediaReceiver mediaReceiver, int mediaType, boolean selectMultiple, String savePath, String mime, String title) {
        if (NativeGallery.CheckPermission(context, true, mediaType) != 1) {
            if (!selectMultiple) {
                mediaReceiver.OnMediaReceived("");
            } else {
                mediaReceiver.OnMultipleMediaReceived("");
            }
            return;
        }
        Bundle bundle = new Bundle();
        bundle.putInt("NGMP_MEDIA_TYPE", mediaType);
        bundle.putBoolean("NGMP_MULTIPLE", selectMultiple);
        bundle.putString("NGMP_SAVE_PATH", savePath);
        bundle.putString("NGMP_MIME", mime);
        bundle.putString("NGMP_TITLE", title);
        NativeGalleryMediaPickerFragment request = new NativeGalleryMediaPickerFragment(mediaReceiver);
        request.setArguments(bundle);
        ((Activity)context).getFragmentManager().beginTransaction().add(0, (Fragment)request).commitAllowingStateLoss();
    }

    @TargetApi(value=23)
    public static int CheckPermission(Context context, boolean readPermission, int mediaType) {
        if (Build.VERSION.SDK_INT < 23) {
            return 1;
        }
        if (PermissionFreeMode) {
            return 1;
        }
        if (!readPermission) {
            if (Build.VERSION.SDK_INT >= 29) {
                return 1;
            }
            if (context.checkSelfPermission("android.permission.WRITE_EXTERNAL_STORAGE") != 0) {
                return 0;
            }
        }
        if ((Build.VERSION.SDK_INT < 33 || context.getApplicationInfo().targetSdkVersion < 33) && context.checkSelfPermission("android.permission.READ_EXTERNAL_STORAGE") != 0) {
            return 0;
        }
        return 1;
    }

    public static void RequestPermission(Context context, NativeGalleryPermissionReceiver permissionReceiver, boolean readPermission, int mediaType) {
        if (NativeGallery.CheckPermission(context, readPermission, mediaType) == 1) {
            permissionReceiver.OnPermissionResult(1);
            return;
        }
        Bundle bundle = new Bundle();
        bundle.putBoolean("NG_ReadOnly", readPermission);
        bundle.putInt("NG_MediaType", mediaType);
        NativeGalleryPermissionFragment request = new NativeGalleryPermissionFragment(permissionReceiver);
        request.setArguments(bundle);
        ((Activity)context).getFragmentManager().beginTransaction().add(0, (Fragment)request).commitAllowingStateLoss();
    }

    public static void OpenSettings(Context context) {
        Uri uri = Uri.fromParts((String)"package", (String)context.getPackageName(), null);
        Intent intent = new Intent();
        intent.setAction("android.settings.APPLICATION_DETAILS_SETTINGS");
        intent.setData(uri);
        context.startActivity(intent);
    }

    public static boolean CanSelectMultipleMedia() {
        return Build.VERSION.SDK_INT >= 18;
    }

    public static boolean CanSelectMultipleMediaTypes() {
        return Build.VERSION.SDK_INT >= 19;
    }

    public static String GetMimeTypeFromExtension(String extension) {
        if (extension == null || extension.length() == 0) {
            return "";
        }
        String mime = MimeTypeMap.getSingleton().getMimeTypeFromExtension(extension.toLowerCase(Locale.ENGLISH));
        return mime != null ? mime : "";
    }

    public static String LoadImageAtPath(Context context, String path, String temporaryFilePath, int maxSize) {
        return NativeGalleryUtils.LoadImageAtPath(context, path, temporaryFilePath, maxSize);
    }

    public static String GetImageProperties(Context context, String path) {
        return NativeGalleryUtils.GetImageProperties(context, path);
    }

    @TargetApi(value=17)
    public static String GetVideoProperties(Context context, String path) {
        return NativeGalleryUtils.GetVideoProperties(context, path);
    }

    @TargetApi(value=29)
    public static String GetVideoThumbnail(Context context, String path, String savePath, boolean saveAsJpeg, int maxSize, double captureTime) {
        return NativeGalleryUtils.GetVideoThumbnail(context, path, savePath, saveAsJpeg, maxSize, captureTime);
    }
}

